/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector2d;
import net.geocentral.geometria.model.GPoint3d;

public class GStar {
    public GPoint3d owner;
    private List<GPoint3d> neighbors;

    public GStar(GPoint3d owner) {
        this.owner = owner;
        this.neighbors = new ArrayList<GPoint3d>();
    }

    public void addNeighbor(GPoint3d p) {
        if (!this.neighbors.contains(p)) {
            this.neighbors.add(p);
        }
    }

    public Point fitLabel(int labelWidth, int labelAscent) {
        ArrayList<Double> angles = new ArrayList<Double>();
        for (GPoint3d p : this.neighbors) {
            Vector2d v = new Vector2d((double)(p.scrCoords.x - this.owner.scrCoords.x), (double)(p.scrCoords.y - this.owner.scrCoords.y));
            v.normalize();
            double angle = Math.acos(v.x);
            if (v.y < 0.0) {
                angle = Math.PI * 2 - angle;
            }
            angles.add(angle);
        }
        Collections.sort(angles);
        angles.add((Double)angles.get(0) + Math.PI * 2);
        double angle1 = 0.0;
        double angle2 = Math.PI * 2;
        double gap = 0.0;
        for (int i = 0; i < angles.size() - 1; ++i) {
            if (!((Double)angles.get(i + 1) - (Double)angles.get(i) > gap)) continue;
            angle1 = (Double)angles.get(i);
            angle2 = (Double)angles.get(i + 1);
            gap = angle2 - angle1;
            if (gap > 1.5707963267948966) break;
        }
        double angle = (angle1 + angle2) / 2.0;
        Point labelPos = new Point(this.owner.scrCoords.x + (int)((double)(labelWidth + 2) * Math.cos(angle)), this.owner.scrCoords.y + (int)((double)(labelAscent + 2) * Math.sin(angle)));
        labelPos.translate(-labelWidth / 2, labelAscent / 2);
        return labelPos;
    }
}

