/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.model.GOptions;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GXmlUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class GOptionsManager {
    private static final String FILENAME = "options.xml";
    private GOptions options;
    private static GOptionsManager instance;
    private static Logger logger;

    private GOptionsManager() {
        this.loadOptions();
    }

    public static GOptionsManager getInstance() {
        if (instance == null) {
            instance = new GOptionsManager();
        }
        return instance;
    }

    private void loadOptions() {
        String optionsFilePath;
        logger.info((Object)"");
        try {
            optionsFilePath = this.getOptionsFilePath();
        }
        catch (Exception exception) {
            logger.warn((Object)String.format("Cannot find options path. Using defaults", new Object[0]));
            this.options = new GOptions();
            this.options.setDefaults();
            return;
        }
        File optionsFile = new File(optionsFilePath);
        if (!optionsFile.exists()) {
            logger.warn((Object)String.format("Cannot find options path. Using defaults", new Object[0]));
            this.options = new GOptions();
            this.options.setDefaults();
            return;
        }
        try {
            InputSource in = new InputSource(new FileInputStream(optionsFile));
            this.options = GXmlUtils.readOptions(in);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            this.options = new GOptions();
            this.options.setDefaults();
            return;
        }
        logger.info((Object)String.format("Options loaded from %s", optionsFilePath));
    }

    private String getOptionsFilePath() throws Exception {
        logger.info((Object)"");
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            logger.error((Object)"No user.home property");
            throw new Exception();
        }
        File homeDir = new File(userHome);
        File optionsDir = new File(homeDir, ".geometria");
        if (!optionsDir.exists() && !optionsDir.mkdir()) {
            logger.error((Object)"Cannot create the .geometria directory");
            throw new Exception();
        }
        String optionsFilePath = new File(optionsDir, FILENAME).getPath();
        return optionsFilePath;
    }

    public boolean saveOptions() {
        String optionsFilePath;
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        try {
            optionsFilePath = this.getOptionsFilePath();
        }
        catch (Exception exception) {
            documentHandler.error(GDictionary.get("CannotSaveOptions", new String[0]));
            return false;
        }
        try {
            FileWriter writer = new FileWriter(optionsFilePath);
            StringBuffer buf = new StringBuffer();
            this.options.serialize(buf, true);
            writer.write(String.valueOf(buf));
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            documentHandler.error(GDictionary.get("CannotSaveOptions", new String[0]));
            return false;
        }
        logger.info((Object)String.format("Options saved to %s", optionsFilePath));
        return true;
    }

    public GOptions getOptions() {
        return this.options;
    }

    static {
        logger = Logger.getLogger((String)"net.geocentral.geometria");
    }
}

