/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;

public class GRatioInputPane
extends JPanel {
    private JTextField numeratorTextField;
    private JTextField denominatorTextField;
    private static final long serialVersionUID = 1L;

    public GRatioInputPane(String numerator, String denominator) {
        this.layoutComponents(numerator, denominator);
    }

    private void layoutComponents(String numerator, String denominator) {
        GGraphicsFactory.getInstance().createTitledBorder(" " + GDictionary.get("Ratio", new String[0]) + " ", this);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalGlue());
        this.numeratorTextField = GGraphicsFactory.getInstance().createNumberInput(numerator);
        this.add(this.numeratorTextField);
        this.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JLabel label = new JLabel(" : ");
        this.add(label);
        this.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.denominatorTextField = GGraphicsFactory.getInstance().createNumberInput(denominator);
        this.add(this.denominatorTextField);
        this.add(Box.createHorizontalGlue());
    }

    public void prefill(String numeratorString, String denominatorString) {
        this.numeratorTextField.setText(numeratorString);
        this.denominatorTextField.setText(denominatorString);
    }

    public void setInputEnabled(boolean enableInput) {
        this.numeratorTextField.setEnabled(enableInput);
        this.denominatorTextField.setEnabled(enableInput);
    }

    public String getNumerator() {
        return this.numeratorTextField.getText().trim();
    }

    public String getDenominator() {
        return this.denominatorTextField.getText().trim();
    }
}

