/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.geocentral.geometria.action.GEnvelopeAction;
import net.geocentral.geometria.model.GAuthor;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GDocumentEnvelope;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GEnvelopeEditPane;
import net.geocentral.geometria.view.GEnvelopeViewPane;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GEnvelopeDialog
extends JDialog
implements GHelpOkCancelDialog {
    private GDocument document;
    private GEnvelopeAction action;
    private GEnvelopeEditPane editPane;
    private int option = 1;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GEnvelopeDialog(Frame ownerFrame, GDocument document, GEnvelopeAction action) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.action = action;
        this.document = document;
        this.editPane = new GEnvelopeEditPane(document);
        this.setDefaultCloseOperation(2);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.TOP_LEFT);
        this.setTitle(GDictionary.get("Envelope", new String[0]));
        this.setResizable(true);
    }

    private void layoutComponents() {
        String editPaneTitle;
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        String problemLabel = GDictionary.get("Problem", new String[0]);
        String solutionLabel = GDictionary.get("Solution", new String[0]);
        if (this.document instanceof GSolution) {
            JPanel problemPane = GGraphicsFactory.getInstance().createTitledBorderPane(problemLabel, false);
            problemPane.setLayout(new BoxLayout(problemPane, 1));
            GProblem problem = ((GSolution)this.document).getProblem();
            GEnvelopeViewPane viewPane = new GEnvelopeViewPane(problem);
            viewPane.layoutComponents();
            problemPane.add(viewPane);
            this.getContentPane().add(problemPane);
            editPaneTitle = solutionLabel;
        } else {
            editPaneTitle = problemLabel;
        }
        JPanel documentPane = GGraphicsFactory.getInstance().createTitledBorderPane(editPaneTitle, false);
        documentPane.setLayout(new BoxLayout(documentPane, 1));
        this.editPane.layoutComponents();
        documentPane.add(this.editPane);
        documentPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.getContentPane().add(documentPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    @Override
    public void ok() {
        logger.info((Object)"");
        String authorName = this.editPane.getAuthorName();
        String authorEmail = this.editPane.getAuthorEmail();
        String authorWeb = this.editPane.getAuthorWeb();
        GAuthor author = new GAuthor(authorName, authorEmail, authorWeb);
        String comments = this.editPane.getComments();
        GDocumentEnvelope envelope = new GDocumentEnvelope(author, comments);
        this.document.setEnvelope(envelope);
        this.dispose();
        this.option = 0;
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }
}

