/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import org.apache.log4j.Logger;

public class GEnvelopeEditPane
extends JPanel {
    private GDocument document;
    private JTextField authorNameTextField;
    private JTextField authorEmailTextField;
    private JTextField authorWebTextField;
    private JTextArea commentsTextArea;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GEnvelopeEditPane(GDocument document) {
        logger.info((Object)"");
        this.document = document;
    }

    public void layoutComponents() {
        logger.info((Object)"");
        this.setLayout(new BoxLayout(this, 1));
        JPanel authorPane = this.layoutAuthorPane();
        this.add(authorPane);
        JPanel commentsPane = this.layoutCommentsPane();
        this.add(commentsPane);
    }

    private JPanel layoutAuthorPane() {
        logger.info((Object)"");
        JPanel authorPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("Author", new String[0]));
        authorPane.setLayout(new BoxLayout(authorPane, 0));
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 1));
        labelPane.add(new JLabel(GDictionary.get("Name", new String[0])));
        labelPane.add(Box.createVerticalGlue());
        labelPane.add(new JLabel(GDictionary.get("Email", new String[0])));
        labelPane.add(Box.createVerticalGlue());
        labelPane.add(new JLabel(GDictionary.get("Web", new String[0])));
        authorPane.add(labelPane);
        authorPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 1));
        this.authorNameTextField = GGraphicsFactory.getInstance().createAuthorInput(this.document.getEnvelope().getAuthor().getName());
        inputPane.add(this.authorNameTextField);
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.authorEmailTextField = GGraphicsFactory.getInstance().createAuthorInput(this.document.getEnvelope().getAuthor().getEmail());
        inputPane.add(this.authorEmailTextField);
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.authorWebTextField = GGraphicsFactory.getInstance().createAuthorInput(this.document.getEnvelope().getAuthor().getWeb());
        inputPane.add(this.authorWebTextField);
        authorPane.add(inputPane);
        return authorPane;
    }

    private JPanel layoutCommentsPane() {
        logger.info((Object)"");
        JPanel commentsPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("Comments", new String[0]));
        commentsPane.setLayout(new BoxLayout(commentsPane, 1));
        this.commentsTextArea = new JTextArea(this.document.getEnvelope().getComments());
        JScrollPane sp = GGraphicsFactory.getInstance().createCommentsArea(this.commentsTextArea);
        commentsPane.add(sp);
        return commentsPane;
    }

    public String getAuthorName() {
        return this.authorNameTextField.getText().trim();
    }

    public String getAuthorEmail() {
        return this.authorEmailTextField.getText().trim();
    }

    public String getAuthorWeb() {
        return this.authorWebTextField.getText().trim();
    }

    public String getComments() {
        return this.commentsTextArea.getText().trim();
    }
}

