/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.BorderLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.util.GNotepadMouseAdapter;
import net.geocentral.geometria.view.GNotepadPopupMenu;
import net.geocentral.geometria.view.NotepadRecordRenderer;
import org.apache.log4j.Logger;

public class GNotepadPane
extends JPanel {
    private GNotepad notepad;
    private JList recordList;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GNotepadPane() {
        logger.info((Object)"");
        this.layoutComponents();
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.setLayout(new BorderLayout());
        this.recordList = new JList();
        new GNotepadMouseAdapter(this, this.recordList);
        this.recordList.setCellRenderer(new NotepadRecordRenderer());
        JScrollPane sp = new JScrollPane(this.recordList);
        this.add(sp);
    }

    public void documentChanged(GDocument document) {
        logger.info((Object)"");
        if (document != null) {
            this.notepad = document.getNotepad();
            this.recordList.setModel(this.notepad.getModel());
            ListSelectionModel selectionModel = this.recordList.getSelectionModel();
            selectionModel.setSelectionMode(0);
            this.notepad.setSelectionModel(selectionModel);
        } else {
            this.recordList.setModel(new DefaultListModel());
        }
    }

    public void repaintRecords() {
        this.recordList.repaint();
    }

    public void popupMenu(int x, int y) {
        GNotepadPopupMenu popup = new GNotepadPopupMenu(this);
        popup.show(this, x, y);
    }

    public void clearSelection() {
        this.recordList.clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.recordList.isSelectionEmpty();
    }
}

