/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jtides.Harmonic;
import jtides.JTides;
import jtides.Rts;
import jtides.SiteSet;
import jtides.ThreadStopper;
import jtides.TideConstants;
import jtides.TideEvent;
import jtides.TidesDoc;
import jtides.TimeBundle;

public final class TideComp {
    String[] unitsStr = new String[]{"Meters", "Feet", "Knots"};
    JTides main;
    public Vector fileList = new Vector();
    public TreeSet siteIndex = new TreeSet();
    boolean indexFileValid = false;
    boolean siteIndexValid = false;
    boolean indexValid = false;
    boolean generatingIndex = false;
    boolean indexReplaced = false;
    String[] lookAndFeelClassNames;
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tide/Current Selection");
    DefaultTreeModel dtm = new DefaultTreeModel(this.root);
    String tidePath = "";

    TideComp(JTides jTides) {
        this.main = jTides;
        this.getLookAndFeelNames();
    }

    private void getLookAndFeelNames() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelClassNames = new String[lookAndFeelInfoArray.length];
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            this.lookAndFeelClassNames[i] = lookAndFeelInfoArray[i].getClassName();
        }
    }

    public void setupLookAndFeel(int n) {
        this.main.configValues.LookAndFeel = n;
        try {
            UIManager.setLookAndFeel(this.lookAndFeelClassNames[n]);
            SwingUtilities.updateComponentTreeUI(this.main);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startProgressBar(JProgressBar jProgressBar, long l, long l2, long l3) {
        if (jProgressBar != null) {
            jProgressBar.setMinimum((int)l);
            jProgressBar.setMaximum((int)l2);
            jProgressBar.setValue((int)l2);
        }
    }

    public void updateProgressBar(JProgressBar jProgressBar, long l) {
        if (jProgressBar != null) {
            jProgressBar.setValue((int)l);
        }
    }

    public void stopProgressBar(JProgressBar jProgressBar) {
        if (jProgressBar != null) {
            jProgressBar.setValue(jProgressBar.getMinimum());
        }
    }

    public String readFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string);
            while ((n = fileInputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public String readStream(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public String srchRplc(int n, String string, String string2, String string3) {
        if (string2.compareTo(string3) != 0) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = string.toCharArray();
            if (n > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            int n3 = string2.length();
            while ((n2 = string.indexOf(string2, n)) != -1) {
                stringBuffer.append(cArray, n, n2 - n);
                stringBuffer.append(string3);
                n = n2 + n3;
            }
            if (n < string.length()) {
                stringBuffer.append(cArray, n, string.length() - n);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public String srchRplc(String string, String string2, String string3) {
        return this.srchRplc(0, string, string2, string3);
    }

    long setDT(long l, TidesDoc tidesDoc) {
        l = (long)((double)l + tidesDoc.siteSet.tz * 3600.0);
        l -= l % 86400L;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date((l + 43200L) * 1000L));
        boolean bl = this.main.tideComp.isDST(gregorianCalendar);
        tidesDoc.siteSet.daylightInEffect = this.main.configValues.daylightTime == 2 | this.main.configValues.daylightTime == 1 & bl;
        return l;
    }

    String hmsFormat(int n, int n2) {
        return "" + this.padChar(n, 2, "0") + ":" + this.padChar(n2, 2, "0");
    }

    String hmsFormat(int n, int n2, int n3) {
        return this.hmsFormat(n, n2) + ":" + this.padChar(n3, 2, "0");
    }

    String formatSunHMS(double d, boolean bl) {
        String string = "";
        if (d < 0.0) {
            string = "[Below]";
        } else if (d > 24.0) {
            string = "[Above]";
        } else {
            int n = (int)d;
            int n2 = (int)(d * 60.0);
            int n3 = (int)(d * 3600.0);
            TimeBundle timeBundle = this.hourAmPmFormat(n, " AM", " PM");
            string = bl ? this.padChar(timeBundle.hour, 2, "0") + ":" + this.padChar(n2, 2, "0") + ":" + this.padChar(n3 %= 60, 2, "0") + timeBundle.ampm : this.padChar(timeBundle.hour, 2, "0") + ":" + this.padChar(n2 %= 60, 2, "0") + timeBundle.ampm;
        }
        return string;
    }

    String formatSunHMS(double d) {
        return this.formatSunHMS(d, false);
    }

    String padChar(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        n -= string.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    String padChar(int n, int n2, String string) {
        return this.padChar("" + n, n2, string);
    }

    TimeBundle hourAmPmFormat(int n, String string, String string2) {
        TimeBundle timeBundle = new TimeBundle(n);
        if (this.main.configValues.ampmFlag) {
            timeBundle.ampm = timeBundle.hour >= 12 ? string2 : string;
            timeBundle.hour %= 12;
            timeBundle.hour = timeBundle.hour < 1 ? 12 + timeBundle.hour : timeBundle.hour;
        }
        return timeBundle;
    }

    String formatDate(long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l));
        return this.formatDate(gregorianCalendar, bl, bl2, bl3, bl4, string);
    }

    String formatDate(GregorianCalendar gregorianCalendar, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        String string2 = "";
        String string3 = "";
        if (bl3) {
            string3 = "/" + gregorianCalendar.get(1);
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = gregorianCalendar.get(11);
            stringBuffer.append(gregorianCalendar.get(1));
            stringBuffer.append("-");
            stringBuffer.append(gregorianCalendar.get(2) + 1);
            stringBuffer.append("-");
            stringBuffer.append(gregorianCalendar.get(5));
            stringBuffer.append(string);
            stringBuffer.append(this.padChar(gregorianCalendar.get(11), 2, "0"));
            stringBuffer.append(":");
            stringBuffer.append(this.padChar(gregorianCalendar.get(12), 2, "0"));
            stringBuffer.append(":");
            stringBuffer.append(this.padChar(gregorianCalendar.get(13), 2, "0"));
            string2 = stringBuffer.toString();
        } else {
            if (bl4) {
                gregorianCalendar.add(13, 30);
            }
            int n = gregorianCalendar.get(11);
            TimeBundle timeBundle = this.hourAmPmFormat(n, " AM", " PM");
            string2 = bl2 ? "" + this.padChar(timeBundle.hour, 2, "0") + ":" + this.padChar(gregorianCalendar.get(12), 2, "0") + timeBundle.ampm : TideConstants.dowNames[gregorianCalendar.get(7) - 1] + " " + this.padChar(gregorianCalendar.get(2) + 1, 2, "0") + "/" + this.padChar(gregorianCalendar.get(5), 2, "0") + string3 + " " + this.padChar(timeBundle.hour, 2, "0") + ":" + this.padChar(gregorianCalendar.get(12), 2, "0") + ":" + this.padChar(gregorianCalendar.get(13), 2, "0") + timeBundle.ampm;
        }
        return string2;
    }

    String old_formatDataString(TidesDoc tidesDoc, int n, Vector vector, boolean bl, boolean bl2, String string, boolean bl3, boolean bl4, boolean bl5, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'L', 'H'};
        char[] cArray2 = new char[]{'E', 'F'};
        if (tidesDoc.siteSet.current) {
            cArray = cArray2;
        }
        long l = ((TideEvent)vector.elementAt((int)n)).t;
        double d = this.main.tideComp.ConvertHeight(tidesDoc.siteSet, ((TideEvent)vector.elementAt((int)n)).height);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l * 1000L));
        String string4 = this.formatDate(gregorianCalendar, bl, bl2, bl3, true, string2);
        if (((TideEvent)vector.elementAt((int)n)).slack) {
            string3 = !bl ? "Slack  " : "0.0" + string2 + "S";
        } else {
            string3 = bl ? "" + this.formatDouble(d, 2) : "" + this.formatDouble(d, 1);
            if (bl5) {
                string3 = string3 + (bl ? string2 : " ") + (((TideEvent)vector.elementAt((int)n)).high ? cArray[1] : cArray[0]);
            }
        }
        if (bl) {
            if (bl4) {
                this.setDT(l, tidesDoc);
                Rts rts = this.main.sunComp.compRTS(tidesDoc.siteSet, l, 0);
                Rts rts2 = this.main.sunComp.compRTS(tidesDoc.siteSet, l, 1);
                stringBuffer.append(string4);
                stringBuffer.append(string2);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                stringBuffer.append(string);
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts2.rise, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts.rise, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts.transit, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts.set, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts2.set, true));
                stringBuffer.append(string2);
                stringBuffer.append(tidesDoc.siteSet.daylightInEffect ? "1" : "0");
            } else {
                stringBuffer.append(string4);
                stringBuffer.append(string2);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(string4 + " " + this.padString(string3, 7, 2));
        }
        return stringBuffer.toString();
    }

    String formatDataString(TidesDoc tidesDoc, int n, Vector vector, boolean bl, boolean bl2, String string, boolean bl3, boolean bl4, boolean bl5, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'L', 'H'};
        char[] cArray2 = new char[]{'E', 'F'};
        if (tidesDoc.siteSet.current) {
            cArray = cArray2;
        }
        long l = ((TideEvent)vector.elementAt((int)n)).t;
        double d = this.main.tideComp.ConvertHeight(tidesDoc.siteSet, ((TideEvent)vector.elementAt((int)n)).height);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = gregorianCalendar.getTimeZone().getRawOffset();
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "");
        simpleTimeZone.setRawOffset(n2);
        gregorianCalendar.setTimeZone(simpleTimeZone);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(new Date(l * 1000L));
        long l2 = l - (long)(tidesDoc.siteSet.tz * 3600.0);
        gregorianCalendar.setTime(new Date(l2 * 1000L));
        String string4 = this.formatDate(gregorianCalendar, bl, bl2, bl3, true, string2);
        String string5 = this.formatDate(gregorianCalendar2, bl, bl2, bl3, true, string2);
        if (((TideEvent)vector.elementAt((int)n)).slack) {
            string3 = !bl ? "Slack  " : "0.0" + string2 + "S";
        } else {
            string3 = bl ? "" + this.formatDouble(d, 2) : "" + this.formatDouble(d, 1);
            if (bl5) {
                string3 = string3 + (bl ? string2 : " ") + (((TideEvent)vector.elementAt((int)n)).high ? cArray[1] : cArray[0]);
            }
        }
        if (bl) {
            if (bl4) {
                this.setDT(l, tidesDoc);
                Rts rts = this.main.sunComp.compRTS(tidesDoc.siteSet, l, 0);
                Rts rts2 = this.main.sunComp.compRTS(tidesDoc.siteSet, l, 1);
                stringBuffer.append(string4);
                stringBuffer.append(string2);
                stringBuffer.append(string5);
                stringBuffer.append(string2);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                stringBuffer.append(string);
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts2.rise, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts.rise, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts.transit, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts.set, true));
                stringBuffer.append(string2);
                stringBuffer.append(this.formatSunHMS(rts2.set, true));
                stringBuffer.append(string2);
                stringBuffer.append(tidesDoc.siteSet.daylightInEffect ? "1" : "0");
            } else {
                stringBuffer.append(string4);
                stringBuffer.append(string2);
                stringBuffer.append(string5);
                stringBuffer.append(string2);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
        } else {
            int n3 = bl5 ? 8 : 6;
            stringBuffer.append(this.padString(string5, 8, 0) + this.padString(string3, n3, 2));
        }
        return stringBuffer.toString();
    }

    String padString(String string, int n, int n2) {
        int n3;
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n; ++n3) {
            stringBuffer.append(' ');
        }
        n3 = n2 == 0 ? 0 : (n2 == 1 ? (n - n4) / 2 : n - n4);
        n3 = n3 < 0 ? 0 : n3;
        stringBuffer.replace(n3, n3 + n4, string);
        return stringBuffer.toString();
    }

    public void tweakFont(Component component) {
        component.setFont(new Font("Monospaced", component.getFont().getStyle(), component.getFont().getSize()));
    }

    public void verifyIndex(String string, String string2, String string3, boolean bl) {
        boolean bl2 = !this.readFileList(string, string2, this.fileList);
        if (bl2 = this.testIndexFiles(string, string2, bl2, this.fileList)) {
            this.indexReplaced = true;
            this.buildNewIndex(string, string2, this.fileList);
        }
        if (!this.indexFileValid) {
            this.readFileList(string, string2, this.fileList);
        }
        this.setupIndex1(string, string2, string3, bl);
    }

    public void setupIndex1(String string, String string2, String string3, boolean bl) {
        if (!this.siteIndexValid) {
            this.readIndex(string, string2);
        }
        this.setupIndex2(string, string2, string3, bl);
    }

    public void setupIndex2(String string, String string2, String string3, boolean bl) {
        if (!this.indexValid) {
            this.setupIndex3(string, string2);
        }
        if (bl) {
            this.main.openFileList(string3, true);
        }
    }

    public void setupIndex3(final String string, final String string2) {
        if (!this.indexValid) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    TideComp.this.setupIndexThread(string, string2);
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setupIndexThread(String string, String string2) {
        if (this.root.getChildCount() < 2) {
            this.root.removeAllChildren();
            Vector vector = new Vector();
            int n = this.siteIndex.size();
            int n2 = 0;
            this.main.startProgressBar("Setting up Index", 0L, n2, 0L);
            for (String string3 : this.siteIndex) {
                vector = this.parseDelimLine(string3, "\t");
                this.recurseTree(this.root, vector, 0);
                if (++n2 % 100 != 0) continue;
                this.main.updateProgressBar(n2);
            }
            this.main.stopProgressBar();
        }
        this.indexValid = true;
    }

    private void recurseTree(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("");
        if (n < 4 && n < vector.size()) {
            int n2;
            String string = (String)vector.elementAt(n);
            if (n == 0) {
                if (string.equals("C")) {
                    string = "Current Stations";
                }
                if (string.equals("T")) {
                    string = "Tide Stations";
                }
            }
            if ((n2 = this.matchNodes(defaultMutableTreeNode, string)) < 0) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                this.dtm.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            } else {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            }
            this.recurseTree(defaultMutableTreeNode2, vector, n + 1);
        }
    }

    int matchNodes(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        boolean bl = false;
        while (n2 < n && !bl) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            String string2 = defaultMutableTreeNode2.toString();
            bl = string.equals(string2);
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            n2 = -1;
        }
        return n2;
    }

    String doubleToStr(double d) {
        String string = new Double(d).toString();
        return string;
    }

    double strToDouble(String string, boolean bl) {
        double d = new Double(string);
        if (bl) {
            d = Math.abs(d);
        }
        return d;
    }

    boolean isDST(GregorianCalendar gregorianCalendar) {
        boolean bl = false;
        if (this.main.configValues.daylightTime == 1) {
            TimeZone timeZone = gregorianCalendar.getTimeZone();
            bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
        } else {
            bl = this.main.configValues.daylightTime == 2;
        }
        return bl;
    }

    String FormatDegMin(double d, char c, char c2) {
        long l = (long)(Math.abs(d) * 6000.0);
        long l2 = l / 6000L;
        String string = "" + l2 + '\u00b0' + " " + this.formatDouble((double)(l %= 6000L) / 100.0, 2, false) + "' " + (d < 0.0 ? c2 : c);
        return string;
    }

    String formatDouble(double d, int n, boolean bl) {
        String string = bl ? "+" : "";
        String string2 = bl ? "-" : "";
        String string3 = "000000000000";
        String string4 = "###0." + string3.substring(0, n);
        DecimalFormat decimalFormat = new DecimalFormat(string + string4 + ";" + string2 + string4);
        return decimalFormat.format(d);
    }

    String formatDouble(double d, int n) {
        return this.formatDouble(d, n, true);
    }

    String FormatLatLng(double d, double d2) {
        String string = "Lat. " + this.FormatDegMin(d, 'N', 'S') + " Lng. " + this.FormatDegMin(d2, 'E', 'W');
        return string;
    }

    int skipWS(String string, int n) {
        while (Character.isWhitespace(string.charAt(n)) && n < string.length()) {
            ++n;
        }
        return n;
    }

    FieldData getWSField(String string, int n) {
        int n2 = n = this.skipWS(string, n);
        while (n < string.length() && !Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        String string2 = string.substring(n2, n);
        return new FieldData(string2, n);
    }

    String mergeDelimLine(Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)vector.elementAt(i) + (i < n - 1 ? string : ""));
        }
        return stringBuffer.toString();
    }

    Vector parseLine(String string) {
        string = string.trim();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < string.length()) {
            FieldData fieldData = this.getWSField(string, n);
            n = fieldData.pos;
            vector.add(fieldData.field);
        }
        return vector;
    }

    Vector parseDelimLine(String string, String string2) {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            String string3 = string.substring(n2, n);
            vector.addElement(string3);
            n2 = n + n3;
        }
        if (n2 <= string.length()) {
            vector.addElement(string.substring(n2));
        }
        return vector;
    }

    String shortForm(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.parseDelimLine(string, "\t");
        for (int i = 0; i < n && i < vector.size(); ++i) {
            stringBuffer.append((String)vector.elementAt(i) + "\t");
        }
        return stringBuffer.toString();
    }

    boolean readFileList(String string, String string2, Vector vector) {
        boolean bl = true;
        try {
            File file = new File(string2 + TideConstants.SYSTEM_FILESEP + string);
            if (file != null) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                vector.clear();
                boolean bl2 = true;
                while (bl2 && bl) {
                    Vector vector2;
                    String string3 = randomAccessFile.readLine();
                    if (string3.charAt(0) == '-') {
                        bl2 = false;
                        continue;
                    }
                    if (!bl2 || (vector2 = this.parseDelimLine(string3, "\t")).size() <= 1) continue;
                    vector.add(vector2.elementAt(1));
                    if (new File(this.tidePath + TideConstants.SYSTEM_FILESEP + (String)vector2.elementAt(1)) != null) continue;
                    bl = false;
                }
                randomAccessFile.close();
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    void readIndex(final String string, final String string2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                TideComp.this.readIndexThread(string, string2);
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void readIndexThread(String string, String string2) {
        String string3 = string2 + TideConstants.SYSTEM_FILESEP + string;
        long l = this.fileSize(string3);
        this.main.startProgressBar("Reading Site Index", 0L, l, 0L);
        if (this.indexFileValid) {
            try {
                File file = new File(string2 + TideConstants.SYSTEM_FILESEP + string);
                if (file != null) {
                    this.siteIndexValid = false;
                    this.siteIndex.clear();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    boolean bl = false;
                    long l2 = 0L;
                    String string4 = "";
                    this.siteIndex.clear();
                    boolean bl2 = true;
                    while ((string4 = randomAccessFile.readLine()) != null) {
                        l2 = randomAccessFile.getFilePointer();
                        this.main.updateProgressBar(l2);
                        if (!bl2) {
                            this.siteIndex.add(string4);
                        }
                        if (!bl2 || string4.charAt(0) != '-') continue;
                        bl2 = false;
                    }
                    randomAccessFile.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.main.stopProgressBar();
            this.siteIndexValid = true;
        }
    }

    String getUnitsTag(SiteSet siteSet) {
        int n = siteSet.units < 2 ? this.main.configValues.displayUnits : siteSet.units;
        return this.unitsStr[n];
    }

    double ConvertHeight(SiteSet siteSet, double d) {
        if (siteSet.units < 2) {
            int n = this.main.configValues.displayUnits - siteSet.units;
            if (n == -1) {
                d *= 0.3048;
            } else if (n == 1) {
                d *= 3.280839895013123;
            }
        }
        return d;
    }

    boolean findStr(FindData findData) {
        boolean bl;
        findData.index = findData.data.indexOf(findData.srch);
        boolean bl2 = bl = findData.index != -1;
        if (bl) {
            findData.index += findData.srch.length();
        }
        return bl;
    }

    int checkYear(SiteSet siteSet, int n) {
        n = n < siteSet.startYear ? siteSet.startYear : n;
        n = n >= siteSet.endYear ? siteSet.endYear - 1 : n;
        return n;
    }

    int useCalendar(Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(n);
    }

    Date checkYear(SiteSet siteSet, Date date) {
        int n = this.useCalendar(date, 1);
        n = this.checkYear(siteSet, n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, this.useCalendar(date, 2), this.useCalendar(date, 5), 0, 0, 0);
        Date date2 = gregorianCalendar.getTime();
        return date2;
    }

    void yearCorrect(SiteSet siteSet, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, 0, 1, 0, 0, 0);
        Date date = gregorianCalendar.getTime();
        siteSet.epochTime = date.getTime() / 1000L;
        int n2 = n - siteSet.startYear;
        n2 = n2 < 0 ? 0 : n2;
        int n3 = n2 = n2 >= siteSet.equMax ? siteSet.equMax - 1 : n2;
        if (siteSet.harmBase.length >= siteSet.constituentMax) {
            for (int i = 0; i < siteSet.constituentMax; ++i) {
                Harmonic harmonic = new Harmonic();
                harmonic.epoch = siteSet.harmBase[i].epoch - siteSet.equArgs[i][n2];
                harmonic.amplitude = siteSet.harmBase[i].amplitude * siteSet.nodeFacts[i][n2];
                siteSet.harm[i] = harmonic;
            }
        }
        siteSet.currentYear = n;
    }

    void testYear(SiteSet siteSet, long l) {
        Date date = new Date(l * 1000L);
        int n = this.useCalendar(date, 1);
        this.checkYear(siteSet, n);
        if (siteSet.currentYear != n) {
            this.yearCorrect(siteSet, n);
        }
    }

    double performSignedRoot(double d) {
        return d < 0.0 ? -Math.sqrt(-d) : Math.sqrt(d);
    }

    double timeToTide(SiteSet siteSet, long l, boolean bl) {
        double d = siteSet.baseHeight;
        if (bl) {
            this.testYear(siteSet, l);
        }
        double d2 = (double)(l -= siteSet.epochTime) * 2.777777777777778E-4;
        for (int i = 0; i < siteSet.constituentMax; ++i) {
            d += siteSet.harm[i].amplitude * Math.cos(siteSet.constSpeeds[i] * d2 - siteSet.harm[i].epoch);
        }
        if (siteSet.needRoot) {
            d = this.performSignedRoot(d);
        }
        return d;
    }

    void findHiLoWater(SiteSet siteSet, Date date, int n) {
        long l;
        long l2 = l + 31536000L;
        double d = 1.0;
        double d2 = -1.0;
        for (l = date.getTime() / 1000L; l < l2; l += 7200L) {
            double d3 = this.timeToTide(siteSet, l, true);
            d2 = d2 < d3 ? d3 : d2;
            d = d > d3 ? d3 : d;
        }
        siteSet.mLoWater = this.ConvertHeight(siteSet, d);
        siteSet.mHiWater = this.ConvertHeight(siteSet, d2);
        siteSet.gLoWater = (int)siteSet.mLoWater - 1;
        siteSet.gHiWater = (int)siteSet.mHiWater + 1;
        siteSet.currentDisplayUnits = this.main.configValues.displayUnits;
    }

    double timeToTideDeriv(SiteSet siteSet, long l, int n, boolean bl) {
        double d = 0.0;
        double d2 = 1.570796326794897 * (double)n;
        if (bl) {
            this.testYear(siteSet, l);
        }
        double d3 = (double)(l -= siteSet.epochTime) * 2.777777777777778E-4;
        for (int i = 0; i < siteSet.constituentMax; ++i) {
            double d4 = siteSet.harm[i].amplitude * Math.cos(d2 + siteSet.constSpeeds[i] * d3 - siteSet.harm[i].epoch);
            for (int j = 0; j < n; ++j) {
                d4 *= siteSet.constSpeeds[i];
            }
            d += d4;
        }
        if (siteSet.needRoot) {
            d = this.performSignedRoot(d);
        }
        return d;
    }

    long findRoot(SiteSet siteSet, long l, long l2, double d) {
        boolean bl;
        long l3 = l - l2;
        int n = 0;
        boolean bl2 = bl = d > 0.0;
        while (n++ < 50 && Math.abs(l3) > 1L) {
            double d2 = this.timeToTideDeriv(siteSet, l2 += l3, 1, false);
            boolean bl3 = d2 > 0.0;
            if (d < (d2 = Math.abs(d2)) || bl != bl3) {
                l3 = -l3 / 2L;
            }
            d = d2;
            bl = bl3;
        }
        return l2;
    }

    long findSlackRoot(SiteSet siteSet, long l, long l2, double d) {
        boolean bl;
        long l3 = l - l2;
        int n = 0;
        boolean bl2 = bl = d > 0.0;
        while (n++ < 50 && Math.abs(l3) > 1L) {
            double d2 = this.timeToTide(siteSet, l2 += l3, false);
            boolean bl3 = d2 > 0.0;
            if (d < (d2 = Math.abs(d2)) || bl != bl3) {
                l3 = -l3 / 2L;
            }
            d = d2;
            bl = bl3;
        }
        return l2;
    }

    long getNextEventTime(SiteSet siteSet, long l, boolean bl) {
        boolean bl2;
        boolean bl3 = this.timeToTideDeriv(siteSet, l, 1, false) > 0.0;
        int n = 0;
        do {
            boolean bl4 = bl2 = this.timeToTideDeriv(siteSet, l += bl ? 960L : -960L, 1, false) > 0.0;
        } while (n++ < 90 && bl2 == bl3);
        return l;
    }

    void predictSlackEvents(SiteSet siteSet, long l, long l2, long l3, long l4, Vector vector, JProgressBar jProgressBar, ThreadStopper threadStopper) {
        long l5 = l;
        boolean bl = this.timeToTide(siteSet, l, true) > 0.0;
        boolean bl2 = false;
        this.startProgressBar(jProgressBar, l, l2, 0L);
        for (long i = l; !(i > l2 || threadStopper != null && threadStopper.stop); i += 960L) {
            this.updateProgressBar(jProgressBar, i);
            double d = this.timeToTide(siteSet, i, true);
            boolean bl3 = d > 0.0;
            if (bl3 != bl) {
                long l6 = this.findSlackRoot(siteSet, l5, i, d);
                TideEvent tideEvent = new TideEvent();
                tideEvent.t = l6 + 30L;
                tideEvent.height = 0.0;
                tideEvent.slack = true;
                if (tideEvent.t >= l3 && tideEvent.t <= l4) {
                    vector.add(tideEvent);
                }
            }
            bl = bl3;
            l5 = i;
        }
        this.stopProgressBar(jProgressBar);
    }

    Vector predictTideEvents(SiteSet siteSet, long l, long l2, long l3, long l4, JProgressBar jProgressBar, ThreadStopper threadStopper) {
        this.startProgressBar(jProgressBar, l, l2, 0L);
        Vector<TideEvent> vector = new Vector<TideEvent>();
        long l5 = l;
        boolean bl = this.timeToTideDeriv(siteSet, l, 1, true) > 0.0;
        boolean bl2 = false;
        for (long i = l; !(i > l2 || threadStopper != null && threadStopper.stop); i += 960L) {
            this.updateProgressBar(jProgressBar, i);
            TideEvent tideEvent = new TideEvent();
            double d = this.timeToTideDeriv(siteSet, i, 1, true);
            boolean bl3 = d > 0.0;
            if (bl3 != bl) {
                long l6 = this.findRoot(siteSet, l5, i, d);
                d = this.timeToTide(siteSet, l6, true);
                tideEvent.t = l6;
                tideEvent.height = d;
                boolean bl4 = tideEvent.high = this.timeToTideDeriv(siteSet, l6, 2, false) < 0.0;
                if (tideEvent.t >= l3 && tideEvent.t <= l4) {
                    vector.add(tideEvent);
                }
            }
            bl = bl3;
            l5 = i;
        }
        this.stopProgressBar(jProgressBar);
        if (siteSet.current) {
            this.predictSlackEvents(siteSet, l, l2, l3, l4, vector, jProgressBar, threadStopper);
        }
        Collections.sort(vector, new CompareTC());
        return vector;
    }

    Date IncDecCTime(SiteSet siteSet, Date date, int n, int n2, int n3) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.useCalendar(date, 1), this.useCalendar(date, 2), this.useCalendar(date, 5), 0, 0, 0);
        if (n3 > 0) {
            gregorianCalendar.add(5, 1);
        } else if (n3 < 0) {
            gregorianCalendar.add(5, -1);
        }
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(siteSet.startYear, 0, 1, 0, 0, 0);
        if (gregorianCalendar.getTime().getTime() < gregorianCalendar2.getTime().getTime()) {
            gregorianCalendar = gregorianCalendar2;
        }
        int n4 = gregorianCalendar.get(1);
        int n5 = gregorianCalendar.get(2);
        int n6 = gregorianCalendar.get(5);
        if ((n5 += n2) < 1) {
            n5 = 12;
            --n4;
        }
        if (n5 > 12) {
            n5 = 1;
            ++n4;
        }
        n4 = (n4 += n) < siteSet.startYear ? siteSet.startYear : n4;
        n4 = n4 > siteSet.startYear + siteSet.equMax - 1 ? siteSet.startYear + siteSet.equMax - 1 : n4;
        this.checkYear(siteSet, n4);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar(n4, n5 - 1, n6, 0, 0, 0);
        return gregorianCalendar3.getTime();
    }

    String getFullEntry(String string) {
        String string2 = "";
        SortedSet<String> sortedSet = this.siteIndex.tailSet(string);
        if (sortedSet != null) {
            string2 = sortedSet.first();
        }
        return string2;
    }

    double stringToDouble(String string) {
        double d = 0.0;
        try {
            d = new Double(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    int stringToInt(String string) {
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private String readNonBlankLine(RandomAccessFile randomAccessFile) {
        String string = null;
        try {
            do {
                if ((string = randomAccessFile.readLine()) == null) continue;
                string = string.trim();
            } while (string != null && string.length() == 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    void readSite(SiteSet siteSet, String string, int n) {
        siteSet.currentYear = -1;
        siteSet.currentDisplayUnits = -1;
        siteSet.needRoot = false;
        siteSet.current = false;
        siteSet.valid = false;
        long l = 0L;
        if (string.length() > 0) {
            Vector vector = this.parseDelimLine(string, "\t");
            if (vector.size() >= 9) {
                String string2;
                File file;
                siteSet.current = ((String)vector.elementAt(0)).equals("C");
                siteSet.shortName = siteSet.name = (String)vector.elementAt(3);
                int n2 = siteSet.name.indexOf(",");
                if (n2 != -1) {
                    siteSet.shortName = siteSet.name.substring(0, n2);
                }
                siteSet.lng = this.stringToDouble((String)vector.elementAt(4));
                siteSet.lat = this.stringToDouble((String)vector.elementAt(5));
                Vector vector2 = this.parseDelimLine((String)vector.elementAt(6), ":");
                int n3 = this.stringToInt((String)vector2.elementAt(0));
                int n4 = this.stringToInt((String)vector2.elementAt(1));
                siteSet.tz = (double)n3 + (double)n4 / 60.0;
                int n5 = this.stringToInt((String)vector.elementAt(7));
                long l2 = this.stringToInt((String)vector.elementAt(8));
                siteSet.indexNumber = (int)l2;
                if (n5 != siteSet.currentLoadedFile) {
                    this.ReadDataFile(siteSet, n5);
                }
                if ((file = new File(string2 = this.main.basePath + TideConstants.SYSTEM_FILESEP + siteSet.dataFileName)) == null) {
                    this.errorMessage("Cannot read file ", string2);
                    return;
                }
                try {
                    String string3;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    randomAccessFile.seek(l2);
                    String string4 = this.readNonBlankLine(randomAccessFile);
                    vector = this.parseDelimLine(string4, ":");
                    double d = this.stringToDouble((String)vector.elementAt(0));
                    double d2 = this.stringToDouble((String)vector.elementAt(1));
                    d += d < 0.0 ? -d2 / 60.0 : d2 / 60.0;
                    if (n3 != 0) {
                        siteSet.tz = d;
                    } else if (vector.size() > 2) {
                        string3 = (String)vector.get(2);
                        System.out.println("Time zone name: " + string3);
                        TimeZone timeZone = TimeZone.getTimeZone(string3);
                        siteSet.tz = timeZone.getRawOffset() / 3600000;
                    }
                    string4 = this.readNonBlankLine(randomAccessFile);
                    vector = this.parseLine(string4);
                    siteSet.baseHeight = this.stringToDouble((String)vector.elementAt(0));
                    string3 = (String)vector.elementAt(1);
                    int n6 = siteSet.units = string3.indexOf("meters") != -1 ? 0 : 1;
                    if (string3.indexOf("knots") != -1) {
                        siteSet.units = 2;
                    }
                    if (string3.indexOf("^2") != -1) {
                        siteSet.needRoot = true;
                    }
                    siteSet.harmBase = new Harmonic[siteSet.constituentMax];
                    for (int i = 0; i < siteSet.constituentMax && (string4 = this.readNonBlankLine(randomAccessFile)) != null; ++i) {
                        vector = this.parseLine(string4);
                        if (vector.size() > 2) {
                            Harmonic harmonic = new Harmonic();
                            harmonic.amplitude = this.stringToDouble((String)vector.elementAt(1));
                            harmonic.epoch = this.stringToDouble((String)vector.elementAt(2));
                            harmonic.epoch *= 0.01745329251994329;
                            siteSet.harmBase[i] = harmonic;
                            continue;
                        }
                        randomAccessFile.close();
                        this.errorMessage("parse error in readSite", string2);
                    }
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            siteSet.valid = true;
            siteSet.fullName = string;
            this.yearCorrect(siteSet, n);
            this.findHiLoWater(siteSet, new GregorianCalendar(n, 0, 1, 0, 0, 0).getTime(), 172800);
        }
    }

    String getComDatLine(RandomAccessFile randomAccessFile) {
        String string = "";
        try {
            while ((string = randomAccessFile.readLine()) != null && (string.charAt(0) != '#' || string.indexOf(33) == -1)) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    void getNonCommentLine(RandomAccessFile randomAccessFile, ScanData scanData) {
        scanData.line = "";
        try {
            while ((scanData.line = randomAccessFile.readLine()) != null && (scanData.line.length() <= 0 || scanData.line.charAt(0) == '#')) {
            }
            if (scanData.line != null) {
                scanData.line = scanData.line.trim();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void getNonCommentLinePos(RandomAccessFile randomAccessFile, ScanData scanData) {
        scanData.line = "";
        scanData.pos = 0L;
        try {
            do {
                scanData.pos = randomAccessFile.getFilePointer();
                scanData.line = randomAccessFile.readLine();
                if (scanData.line == null) continue;
                scanData.line = scanData.line.trim();
            } while (scanData.line != null && scanData.line.charAt(0) == '#');
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String getCommentLine(RandomAccessFile randomAccessFile) {
        String string = "";
        try {
            while ((string = randomAccessFile.readLine()) != null && string.charAt(0) != '#') {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    long fileDate(String string) {
        long l = 0L;
        File file = new File(string);
        if (file != null) {
            l = file.lastModified();
        }
        return l;
    }

    long fileSize(String string) {
        long l = 0L;
        File file = new File(string);
        if (file != null) {
            l = file.length();
        }
        return l;
    }

    boolean testIndexFiles(String string, String string2, boolean bl, Vector vector) {
        int n = vector.size();
        vector.clear();
        String string3 = string2 + TideConstants.SYSTEM_FILESEP + string;
        long l = this.fileDate(string3);
        if (l == 0L) {
            bl = true;
        }
        int n2 = 0;
        String string4 = ".txt";
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i].toLowerCase();
                if (string5.lastIndexOf(string4) != string5.length() - string4.length()) continue;
                string = string2 + TideConstants.SYSTEM_FILESEP + stringArray[i];
                vector.add(stringArray[i]);
                ++n2;
                long l2 = this.fileDate(string);
                if (l2 != 0L && l2 <= l) continue;
                bl = true;
            }
            if (n2 != n) {
                bl = true;
            }
        }
        if (!bl) {
            this.indexFileValid = true;
        }
        return bl;
    }

    void buildNewIndex(final String string, final String string2, final Vector vector) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                TideComp.this.buildNewIndexThread(string, string2, vector);
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void buildNewIndexThread(String string, String string2, Vector vector) {
        this.indexFileValid = false;
        Vector vector2 = new Vector();
        try {
            int n;
            String string3 = string2 + TideConstants.SYSTEM_FILESEP + string;
            File file = new File(string3);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(0L);
            for (n = 0; n < vector.size(); ++n) {
                randomAccessFile.writeBytes("" + n + "\t" + (String)vector.elementAt(n) + TideConstants.SYSTEM_EOL);
                this.writeSingleIndex(vector2, string2, (String)vector.elementAt(n), n);
            }
            randomAccessFile.writeBytes("--------" + TideConstants.SYSTEM_EOL);
            Collections.sort(vector2);
            n = 0;
            int n2 = 0;
            int n3 = vector2.size();
            for (int i = 0; i < vector2.size(); ++i) {
                String string4 = (String)vector2.elementAt(i);
                n2 += string4.length();
                randomAccessFile.writeBytes(string4 + TideConstants.SYSTEM_EOL);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.indexFileValid = true;
    }

    void writeSingleIndex(Vector vector, String string, String string2, int n) {
        String string3 = string + TideConstants.SYSTEM_FILESEP + string2;
        long l = this.fileSize(string3);
        File file = new File(string3);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            this.main.startProgressBar("Rebuilding Index -- Reading file \"" + string2 + "\"", 0L, l, 0L);
            int n2 = 0;
            String string4 = "";
            boolean bl = false;
            long l2 = 0L;
            while (string4 != null) {
                Object object;
                String string5 = "";
                String string6 = "";
                double d = 0.0;
                double d2 = 0.0;
                String string7 = "T";
                int n3 = 0;
                string4 = this.getComDatLine(randomAccessFile);
                if (string4 == null) continue;
                l2 = randomAccessFile.getFilePointer();
                this.main.updateProgressBar(l2);
                boolean bl2 = true;
                do {
                    if (this.findStr((FindData)(object = new FindData(string4, "!longitude:", n2)))) {
                        ++n3;
                        string4 = string4.substring(((FindData)object).index);
                        d2 = this.stringToDouble(string4);
                        continue;
                    }
                    ((FindData)object).srch = "!latitude:";
                    if (!this.findStr((FindData)object)) continue;
                    ++n3;
                    string4 = string4.substring(((FindData)object).index);
                    d = this.stringToDouble(string4);
                } while (bl2 = (string4 = randomAccessFile.readLine()) != null ? string4.charAt(0) == '#' && string4.indexOf(33) != -1 : false);
                if (string4 == null || string4.charAt(0) == '#') continue;
                ++n3;
                String string8 = string4 = string4.trim();
                String string9 = "";
                n2 = string8.lastIndexOf(44);
                if (n2 != -1 && (n2 = (string9 = string8.substring(n2 + 1)).indexOf(40)) != -1) {
                    string9 = string9.substring(0, n2);
                }
                if (string9.indexOf(41) != -1) {
                    string9 = "";
                }
                if ((n2 = string9.indexOf(" Current")) != -1) {
                    string9 = string9.substring(0, n2);
                    string7 = "C";
                }
                if ((string9 = string9.trim()).length() == 0) {
                    string9 = "Other";
                }
                object = new ScanData();
                this.getNonCommentLinePos(randomAccessFile, (ScanData)object);
                long l3 = ((ScanData)object).pos;
                Vector vector2 = this.parseLine(((ScanData)object).line);
                if (vector2.size() > 1) {
                    string6 = (String)vector2.elementAt(0);
                    string5 = ((String)vector2.elementAt(1)).substring(1);
                    n2 = string5.indexOf(47);
                    if (n2 != -1) {
                        string5 = string5.substring(0, n2);
                    }
                    n3 += 2;
                }
                if (n3 != 5) continue;
                String string10 = string7 + "\t" + string5 + "\t" + string9 + "\t" + string8 + "\t" + d2 + "\t" + d + "\t" + string6 + "\t" + n + "\t" + l3;
                vector.add(string10);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.main.stopProgressBar();
    }

    void errorMessage(String string, String string2) {
        File file;
        boolean bl;
        String string3 = this.main.basePath + "/" + "JTidesData.index";
        String string4 = "Data Format Error: " + string + ", file " + string2 + "\n\nThis error may result from an index file that is not\nsynchronized with the installed data files. The remedy\nis to delete the index file. The file is located at\n" + string3 + " on this system.\nThis file will be automatically regenerated\nteh next time you run JTides.\n\nPress OK to delete the file, Cancel to preserve it.";
        int n = JOptionPane.showConfirmDialog(this.main, string4, "Error reading file", 2);
        if (n == 0 && (bl = (file = new File(string3)).delete())) {
            JOptionPane.showConfirmDialog(this.main, "Please exit and restart JTides.", "Index File Deleted", -1);
        }
    }

    private String readNonWSChars(RandomAccessFile randomAccessFile) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while (Character.isWhitespace(c = (char)randomAccessFile.readByte())) {
            }
            while (!Character.isWhitespace(c)) {
                stringBuffer.append(c);
                c = (char)randomAccessFile.readByte();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    boolean ReadDataFile(SiteSet siteSet, int n) {
        if (n >= this.fileList.size()) {
            this.errorMessage("Index file not synchronized", "");
            return false;
        }
        siteSet.dataFileName = (String)this.fileList.elementAt(n);
        siteSet.equMax = -1;
        siteSet.nodeMax = -1;
        siteSet.constituentMax = -1;
        String string = this.main.basePath + TideConstants.SYSTEM_FILESEP + siteSet.dataFileName;
        try {
            int n2;
            int n3;
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "r");
            String string2 = "";
            ScanData scanData = new ScanData();
            this.getNonCommentLine(randomAccessFile, scanData);
            if (scanData.line == null) {
                randomAccessFile.close();
                this.errorMessage("Cannot read argument count", siteSet.dataFileName);
                return false;
            }
            siteSet.constituentMax = this.stringToInt(scanData.line);
            siteSet.harm = new Harmonic[siteSet.constituentMax];
            siteSet.constSpeeds = new double[siteSet.constituentMax];
            for (n3 = 0; n3 < siteSet.constituentMax && scanData.line != null; ++n3) {
                this.getNonCommentLine(randomAccessFile, scanData);
                if (scanData.line == null) {
                    randomAccessFile.close();
                    this.errorMessage("Premature end of constituent data", siteSet.dataFileName);
                    return false;
                }
                Vector vector = this.parseLine(scanData.line);
                double d = this.stringToDouble((String)vector.elementAt(1));
                siteSet.constSpeeds[n3] = d *= 0.01745329251994329;
            }
            this.getNonCommentLine(randomAccessFile, scanData);
            if (scanData.line == null) {
                randomAccessFile.close();
                this.errorMessage("Cannot read base year", siteSet.dataFileName);
                return false;
            }
            siteSet.startYear = this.stringToInt(scanData.line);
            this.getNonCommentLine(randomAccessFile, scanData);
            if (scanData.line == null) {
                randomAccessFile.close();
                this.errorMessage("Cannot read equ count", siteSet.dataFileName);
                return false;
            }
            siteSet.equMax = this.stringToInt(scanData.line);
            siteSet.endYear = siteSet.startYear + siteSet.equMax;
            siteSet.equArgs = new double[siteSet.constituentMax][siteSet.equMax];
            for (n3 = 0; n3 < siteSet.constituentMax; ++n3) {
                this.readNonWSChars(randomAccessFile);
                for (n2 = 0; n2 < siteSet.equMax; ++n2) {
                    string2 = this.readNonWSChars(randomAccessFile);
                    double d = this.stringToDouble(string2);
                    siteSet.equArgs[n3][n2] = d *= 0.01745329251994329;
                }
                if (string2 != null) continue;
                randomAccessFile.close();
                this.errorMessage("Premature end of equ data", siteSet.dataFileName);
                return false;
            }
            string2 = this.readNonWSChars(randomAccessFile);
            if (!string2.equals("*END*")) {
                randomAccessFile.close();
                this.errorMessage("Missing equ end mark", siteSet.dataFileName);
                return false;
            }
            this.getNonCommentLine(randomAccessFile, scanData);
            if (scanData.line == null) {
                randomAccessFile.close();
                this.errorMessage("Cannot read node count", siteSet.dataFileName);
                return false;
            }
            siteSet.nodeMax = this.stringToInt(scanData.line);
            siteSet.nodeFacts = new double[siteSet.constituentMax][siteSet.nodeMax];
            for (n3 = 0; n3 < siteSet.constituentMax; ++n3) {
                this.readNonWSChars(randomAccessFile);
                for (n2 = 0; n2 < siteSet.nodeMax; ++n2) {
                    double d;
                    string2 = this.readNonWSChars(randomAccessFile);
                    siteSet.nodeFacts[n3][n2] = d = this.stringToDouble(string2);
                }
                if (string2 != null) continue;
                randomAccessFile.close();
                this.errorMessage("Premature end of node data", siteSet.dataFileName);
                return false;
            }
            string2 = this.readNonWSChars(randomAccessFile);
            if (!string2.equals("*END*")) {
                randomAccessFile.close();
                this.errorMessage("Missing node end mark", siteSet.dataFileName);
                return false;
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            this.errorMessage("Cannot open file", siteSet.dataFileName);
            return false;
        }
        siteSet.currentLoadedFile = n;
        return true;
    }

    final class CompareTC
    implements Comparator {
        CompareTC() {
        }

        public int compare(Object object, Object object2) {
            return (int)(((TideEvent)object).t - ((TideEvent)object2).t);
        }
    }

    final class FindData {
        String data;
        String srch;
        int index;

        public FindData(String string, String string2, int n) {
            this.data = string;
            this.srch = string2;
            this.index = n;
        }
    }

    final class ScanData {
        public String line = "";
        public long pos = 0L;

        ScanData(String string, long l) {
            this.pos = l;
            this.line = string;
        }

        ScanData() {
        }
    }

    final class FieldData {
        public String field;
        public int pos;

        FieldData(String string, int n) {
            this.pos = n;
            this.field = string;
        }
    }
}

