/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.JDictionary;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FileDownloader {
    public boolean stop = false;

    public void terminate() {
        this.stop = true;
    }

    public byte[] download(URL url, JProgressBar progressBar) {
        if (url == null) {
            return null;
        }
        DataInputStream din = null;
        int offset = 0;
        int length = 1024;
        int temp = 0;
        int fileSize = 0;
        try {
            fileSize = url.openConnection().getContentLength();
            din = new DataInputStream(url.openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        if (progressBar != null) {
            progressBar.setMaximum(fileSize);
            progressBar.setMinimum(0);
        }
        byte[] b = new byte[fileSize];
        try {
            while (true) {
                if (this.stop) {
                    din.close();
                    byte[] byArray = null;
                    return byArray;
                }
                temp = din.read(b, offset, length);
                if (temp == -1) {
                    try {
                        din.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    byte[] byArray = b;
                    return byArray;
                }
                if (fileSize - (offset += temp) < length) {
                    length = fileSize - offset;
                }
                this.notifyProgressBar(progressBar, offset, fileSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                din.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    void notifyProgressBar(final JProgressBar progressBar, final int currentState, final int topValue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (progressBar != null) {
                    progressBar.setValue(currentState);
                    progressBar.setString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(currentState / 1024))).append(" ").append(JDictionary.getString("KB of")).append(" ").append(topValue / 1024).append(" ").append(JDictionary.getString("KB")))));
                    progressBar.validate();
                    progressBar.repaint();
                }
            }
        });
    }
}

