/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.modules;

import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.IconBank;
import info.jdictionary.JDictionary;
import info.jdictionary.NewsAgent;
import info.jdictionary.events.NewJDictionaryVersionEvent;
import info.jdictionary.events.NewsEvent;
import info.jdictionary.events.PluginScanFinishedEvent;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.gui.UpgradeAgent;
import info.jdictionary.listeners.NewJDictionaryVersionListener;
import info.jdictionary.listeners.NewsListener;
import info.jdictionary.listeners.PluginScanFinishedListener;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.pluginstuff.PluginDownloader;
import info.jdictionary.pluginstuff.PluginManager;
import info.jdictionary.pluginstuff.PluginStatusChanger;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class DefaultToolBar
extends JToolBar {
    DefaultFrameAssembler assembler;
    PluginManager pluginManager;
    JButton downloadButton = new JButton();
    JButton activateButton = new JButton();
    JButton rescanButton = new JButton();
    JButton preferencesButton = new JButton();
    JButton newsButton = new JButton();
    JButton upgradeButton;
    ButtonFlasher downloadButtonFlasher;
    ButtonFlasher activateButtonFlasher;
    ButtonFlasher upgradeButtonFlasher;
    ButtonFlasher newsButtonFlasher;

    public DefaultToolBar(DefaultFrameAssembler assembler) {
        this.assembler = assembler;
        this.pluginManager = assembler.getJDictionary().getPluginManager();
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.add(this.rescanButton);
        this.add(this.activateButton);
        this.add(this.downloadButton);
        this.add(this.preferencesButton);
        this.add(this.newsButton);
        this.pluginManager.addPluginScanFinishedListener(new PluginScanFinishedListener(){

            public void pluginScanFinished(PluginScanFinishedEvent e) {
                DefaultToolBar.this.pluginManager_PluginScanFinished(e);
            }
        });
        this.downloadButton.setIcon(IconBank.FolderIn);
        this.downloadButton.setMargin(new Insets(2, 2, 2, 2));
        this.downloadButton.setToolTipText(JDictionary.getString("Download&Install"));
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultToolBar.this.downloadButton_actionPerformed(e);
            }
        });
        this.activateButton.setIcon(IconBank.plug);
        this.activateButton.setMargin(new Insets(2, 2, 2, 2));
        this.activateButton.setToolTipText(JDictionary.getString("ActivateDeactivate"));
        this.activateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultToolBar.this.activateButton_actionPerformed(e);
            }
        });
        this.rescanButton.setIcon(IconBank.rescan);
        this.rescanButton.setMargin(new Insets(2, 2, 2, 2));
        this.rescanButton.setToolTipText(JDictionary.getString("Rescan"));
        this.rescanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultToolBar.this.rescanButton_actionPerformed(e);
            }
        });
        this.preferencesButton.setIcon(IconBank.hammer);
        this.preferencesButton.setMargin(new Insets(2, 2, 2, 2));
        this.preferencesButton.setToolTipText(JDictionary.getString("Preferences"));
        this.preferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultToolBar.this.preferencesButton_actionPerformed(e);
            }
        });
        this.newsButton.setIcon(IconBank.envelope);
        this.newsButton.setMargin(new Insets(2, 2, 2, 2));
        this.newsButton.setToolTipText(JDictionary.getString("News"));
        this.newsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultToolBar.this.newsButton_actionPerformed(e);
            }
        });
        assembler.getJDictionary().getNewsChecker().addNewsListener(new NewsListener(){

            public void newsUpdated(NewsEvent e) {
                DefaultToolBar.this.newsChecker_newsUpdated(e);
            }
        });
        assembler.getJDictionary().getNewJDictionaryVersionChecker().addNewJDictionaryVersionListener(new NewJDictionaryVersionListener(){

            public void newJDictionaryVersionAvailable(NewJDictionaryVersionEvent e) {
                DefaultToolBar.this.newJDictionaryVersionChecker_newJDictionaryVersionAvailable(e);
            }
        });
    }

    void downloadButton_actionPerformed(ActionEvent e) {
        this.assembler.getOutput().show(this.assembler.getJDictionary().getPluginDownloader());
    }

    void activateButton_actionPerformed(ActionEvent e) {
        this.assembler.getOutput().show(this.assembler.getJDictionary().getPluginStatusChanger());
    }

    void rescanButton_actionPerformed(ActionEvent e) {
        this.assembler.getJDictionary().getPluginManager().scanPlugins();
    }

    void preferencesButton_actionPerformed(ActionEvent e) {
        this.assembler.getOutput().show(this.assembler.getJDictionary().getPreferencesScreen());
    }

    void newsButton_actionPerformed(ActionEvent e) {
        this.assembler.getOutput().show(this.assembler.getJDictionary().getNewsAgent());
    }

    void upgradeButton_actionPerformed(ActionEvent e) {
        this.assembler.getOutput().show(this.assembler.getJDictionary().getUpgradeAgent());
    }

    void pluginManager_PluginScanFinished(PluginScanFinishedEvent e) {
        if (this.pluginManager.getNumberOfPluginFiles() == 0) {
            if (this.downloadButtonFlasher == null) {
                this.pluginManager.addPluginSelectionListener(new PluginSelectionListener(){

                    public void pluginSelected(PluginSelectionEvent e) {
                        if (DefaultToolBar.this.assembler.getOutput().getOutputComponent() != null && DefaultToolBar.this.assembler.getOutput().getOutputComponent() instanceof PluginDownloader) {
                            DefaultToolBar.this.downloadButtonFlasher.terminate();
                            DefaultToolBar.this.downloadButton.setIcon(IconBank.FolderIn);
                            DefaultToolBar.this.downloadButton.setBackground(DefaultToolBar.this.downloadButton.getParent().getBackground());
                        }
                    }
                });
            } else {
                this.downloadButtonFlasher.terminate();
            }
            this.downloadButtonFlasher = new ButtonFlasher(this, this.downloadButton, IconBank.FolderIn, IconBank.Folder, 4);
            this.downloadButtonFlasher.start();
        } else if (this.downloadButtonFlasher != null) {
            this.downloadButtonFlasher.terminate();
            this.downloadButton.setBackground(this.downloadButton.getParent().getBackground());
        }
        if (this.pluginManager.getNumberOfPluginFiles() > 0 && this.pluginManager.getNumberOfLoadedPlugins() == 0) {
            if (this.activateButtonFlasher == null) {
                this.pluginManager.addPluginSelectionListener(new PluginSelectionListener(){

                    public void pluginSelected(PluginSelectionEvent e) {
                        if (DefaultToolBar.this.assembler.getOutput().getOutputComponent() != null && DefaultToolBar.this.assembler.getOutput().getOutputComponent() instanceof PluginStatusChanger) {
                            DefaultToolBar.this.activateButtonFlasher.terminate();
                            DefaultToolBar.this.activateButton.setIcon(IconBank.plug);
                            DefaultToolBar.this.activateButton.setBackground(DefaultToolBar.this.activateButton.getParent().getBackground());
                        }
                    }
                });
            } else {
                this.activateButtonFlasher.terminate();
            }
            this.activateButtonFlasher = new ButtonFlasher(this, this.activateButton, IconBank.unPlug, IconBank.plug, 4);
            this.activateButtonFlasher.start();
        } else if (this.activateButtonFlasher != null) {
            this.activateButtonFlasher.terminate();
            this.activateButton.setIcon(IconBank.plug);
            this.activateButton.setBackground(this.activateButton.getParent().getBackground());
        }
    }

    void newsChecker_newsUpdated(NewsEvent e) {
        if (this.assembler.getOutput().getOutputComponent() != null && this.assembler.getOutput().getOutputComponent() instanceof NewsAgent) {
            return;
        }
        if (this.newsButtonFlasher == null) {
            this.pluginManager.addPluginSelectionListener(new PluginSelectionListener(){

                public void pluginSelected(PluginSelectionEvent e) {
                    if (DefaultToolBar.this.assembler.getOutput().getOutputComponent() != null && DefaultToolBar.this.assembler.getOutput().getOutputComponent() instanceof NewsAgent) {
                        DefaultToolBar.this.newsButtonFlasher.terminate();
                        DefaultToolBar.this.newsButton.setIcon(IconBank.envelope);
                        DefaultToolBar.this.newsButton.setBackground(DefaultToolBar.this.newsButton.getParent().getBackground());
                    }
                }
            });
        } else {
            this.newsButtonFlasher.terminate();
        }
        this.newsButtonFlasher = new ButtonFlasher(this, this.newsButton, IconBank.envelopeOpen, IconBank.envelope, 4);
        this.newsButtonFlasher.start();
    }

    void newJDictionaryVersionChecker_newJDictionaryVersionAvailable(NewJDictionaryVersionEvent e) {
        this.upgradeButton = new JButton(IconBank.laptopIn);
        this.upgradeButton.setToolTipText(JDictionary.getString("NewJDictionaryAvailableToolTip"));
        this.upgradeButton.setMargin(new Insets(2, 2, 2, 2));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultToolBar.this.add(DefaultToolBar.this.upgradeButton);
                DefaultToolBar.this.validate();
                DefaultToolBar.this.repaint();
            }
        });
        this.upgradeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultToolBar.this.upgradeButton_actionPerformed(e);
            }
        });
        if (this.upgradeButtonFlasher == null) {
            this.pluginManager.addPluginSelectionListener(new PluginSelectionListener(){

                public void pluginSelected(PluginSelectionEvent e) {
                    if (DefaultToolBar.this.assembler.getOutput().getOutputComponent() != null && DefaultToolBar.this.assembler.getOutput().getOutputComponent() instanceof UpgradeAgent) {
                        DefaultToolBar.this.upgradeButtonFlasher.terminate();
                        DefaultToolBar.this.upgradeButton.setIcon(IconBank.laptopIn);
                        DefaultToolBar.this.upgradeButton.setBackground(DefaultToolBar.this.upgradeButton.getParent().getBackground());
                    }
                }
            });
        } else {
            this.upgradeButtonFlasher.terminate();
        }
        this.upgradeButtonFlasher = new ButtonFlasher(this, this.upgradeButton, IconBank.laptop, IconBank.laptopIn, 4);
        this.upgradeButtonFlasher.start();
    }

    class ButtonFlasher
    extends Thread {
        private JButton button;
        private ImageIcon icon1;
        private ImageIcon icon2;
        private int count;
        private boolean stop = false;

        public ButtonFlasher(DefaultToolBar this$0, JButton button, ImageIcon icon1, ImageIcon icon2, int count) {
            this.icon1 = icon1;
            this.icon2 = icon2;
            this.button = button;
            this.count = count;
        }

        public void terminate() {
            this.stop = true;
        }

        public void run() {
            for (int i = 0; i < this.count; ++i) {
                try {
                    Thread.sleep(500L);
                    if (this.stop) {
                        return;
                    }
                    this.button.setIcon(this.icon2);
                    Thread.sleep(500L);
                    if (this.stop) {
                        return;
                    }
                    this.button.setIcon(this.icon1);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.stop) {
                this.button.setBackground(Color.orange);
            }
        }
    }
}

