/*
 * 01/09/2002 - 20:43:57
 *
 * LatestVersionChecker.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary;

import java.net.URL;
import java.io.DataInputStream;

public class LatestVersionChecker {

    private URL url;

    public LatestVersionChecker(URL url) {
        this.url = url;
    }

    public float whichIsTheLatest() {
        byte[] b = new byte[32];
        try {
            DataInputStream dis = new DataInputStream(url.openStream());
            dis.read(b);
        } catch (java.io.IOException e) {
            return 0;
        }
        Float f = new Float(new String(b));
        return f.floatValue();
    }
}


