/*
 * 01/09/2002 - 20:43:57
 *
 * Preferences.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundatin; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary;

import org.apache.regexp.RE;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import javax.swing.JComboBox;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.listeners.PluginSelectionListener;

public class Preferences extends JPanel {

    private JDictionary jDictionary;
    private Prefs prefs;
    private boolean changesSaved = false;
    private JButton applyButton;
    private JPanel output;
    private JScrollPane outputScrollPane;

    private JTextField serverTextField;
    private JTextField portTextField;
    private JTextField loginTextField;
    private JPasswordField passwordField;

    private JCheckBox upgradeCheckBox;
    private JCheckBox newsCheckBox;
    private JCheckBox proxyCheckBox;
    private JCheckBox authCheckBox;

    private JComboBox typeComboBox = new JComboBox();
    private String httpType = new String("HTTP Type");
    private String socksType = new String("SOCKS Proxy");
    private String shownType;

    boolean usingHttpProxy;
    boolean usingSocksProxy;
    boolean usingHttpProxyLogin;
    boolean usingSocksProxyLogin;
    String socksServer;
    String socksPort;
    String socksLogin;
    char[] socksPassword;
    String httpServer;
    String httpPort;
    String httpLogin;
    char[] httpPassword;

    private JLabel portLabel;
    private JLabel serverLabel;
    private JLabel typeLabel;
    private JLabel loginLabel;
    private JLabel passwordLabel;

    private Color highLightColor = Color.orange;

    public Preferences(JDictionary jDictionary) {
        super();
        this.jDictionary = jDictionary;
        this.prefs = jDictionary.getPrefs();
        //jDictionary.getPluginManager().addPluginSelectionListener(new PluginSelectionListener() {
        //    public void pluginSelected(PluginSelectionEvent e) {
        //        pluginManager_pluginSelected(e);
        //    }
        //});

        socksServer = new String(prefs.socksProxyServer);
        socksPort = new String(prefs.socksProxyPort);
        socksLogin = new String(prefs.socksProxyLogin);
        socksPassword = new String(prefs.socksProxyPassword).toCharArray();
        httpServer = new String(prefs.httpProxyServer);
        httpPort = new String(prefs.httpProxyPort);
        httpLogin = new String(prefs.httpProxyLogin);
        httpPassword = new String(prefs.httpProxyPassword).toCharArray();
        usingHttpProxy = prefs.usingHttpProxy;
        usingSocksProxy = prefs.usingSocksProxy;
        usingHttpProxyLogin = prefs.usingHttpProxyLogin;
        usingSocksProxyLogin = prefs.usingSocksProxyLogin;

        setBackground(Color.white);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        setMinimumSize(new Dimension(400, 300));
        setPreferredSize(new Dimension(400, 300));

        JLabel header = new JLabel();
        header = new JLabel(ImageBank.getImageByName("PreferencesHeader.png"));
        header.setAlignmentX((float) 0.0);
        header.setMinimumSize(new Dimension(300, 65));
        header.setPreferredSize(new Dimension(500, 65));
        header.setBackground(Color.white);

        if(this.usingSocksProxy)
                   shownType = socksType;
                   else
                   shownType = httpType;

        //setting up network section///////////////////////////////////////////
        serverTextField = new JTextField();
        serverTextField.setMaximumSize(new Dimension(200, 22));
        serverTextField.setPreferredSize(new Dimension(200, 22));
        serverTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(KeyEvent e) {
                serverTextField_keyTyped(e);
            }
        });

        portTextField = new JTextField();
        portTextField.setMaximumSize(new Dimension(200, 22));
        portTextField.setPreferredSize(new Dimension(200, 22));
        portTextField.addKeyListener(new java.awt.event.KeyAdapter() {
                    public void keyTyped(KeyEvent e) {
                        portTextField_keyTyped(e);
                    }
        });

        loginTextField = new JTextField();
        loginTextField.setMaximumSize(new Dimension(200, 22));
        loginTextField.setPreferredSize(new Dimension(200, 22));
        loginTextField.addKeyListener(new java.awt.event.KeyAdapter() {
                    public void keyTyped(KeyEvent e) {
                        loginTextField_keyTyped(e);
                    }
        });

        passwordField = new JPasswordField();
        passwordField.setMaximumSize(new Dimension(200, 22));
        passwordField.setPreferredSize(new Dimension(200, 22));
        passwordField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(KeyEvent e) {
                passwordField_keyTyped(e);
            }
        });

        proxyCheckBox = new JCheckBox(JDictionary.getString("IUseProxy"));
        proxyCheckBox.setAlignmentX((float)0.0);
        proxyCheckBox.setBackground(Color.white);
        proxyCheckBox.setSelected(usingHttpProxy || usingSocksProxy);
        proxyCheckBox.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                proxyCheckBox_stateChanged(e);
            }
        });

        authCheckBox = new JCheckBox(JDictionary.getString("LoginToProxy"));
        authCheckBox.setBackground(Color.white);
        authCheckBox.addChangeListener(new ChangeListener() {
                    public void stateChanged(ChangeEvent e) {
                        authCheckBox_stateChanged(e);
                    }
        });
        typeComboBox.setMaximumSize(new Dimension(200, 24));
        typeComboBox.setPreferredSize(new Dimension(200, 24));
        typeComboBox.setBackground(Color.white);
        typeComboBox.addItem(httpType);
        typeComboBox.addItem(socksType);
        if(usingHttpProxy)
            typeComboBox.setSelectedItem(httpType);
        if(usingSocksProxy)
            typeComboBox.setSelectedItem(socksType);
        typeComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                typeComboBox_actionPerformed(e);
            }
        });

        JPanel networkPanel = new JPanel();
        networkPanel.setBackground(Color.white);
        networkPanel.setLayout(new BoxLayout(networkPanel, BoxLayout.X_AXIS));
        networkPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("ConnectPrefs")));

        JLabel networkLabel = new JLabel();
        networkLabel.setAlignmentY(0);
        networkLabel = new JLabel(IconBank.getIconByName("NetworkBig.png"));

        JPanel networkIconPanel = new JPanel();
        networkIconPanel.setBackground(Color.white);
        networkIconPanel.setAlignmentY(0);
        networkIconPanel.add(networkLabel);
        networkIconPanel.setMaximumSize(new Dimension(64, 64));

        JPanel proxyPanel = new JPanel();
        proxyPanel.setBackground(Color.white);
        proxyPanel.setAlignmentY(0);
        proxyPanel.setLayout(new BoxLayout(proxyPanel, BoxLayout.Y_AXIS));
        proxyPanel.add(proxyCheckBox);
        proxyPanel.add(typeComboBox);
        proxyPanel.setMaximumSize(new Dimension(380, 160));
        proxyPanel.setPreferredSize(new Dimension(300, 160));

        JPanel typePanel = new JPanel();
        typePanel.setAlignmentX((float)0.0);
        typePanel.setLayout(new BoxLayout(typePanel, BoxLayout.X_AXIS));
        typePanel.setBackground(Color.white);
        typeLabel = new JLabel(JDictionary.getString("ProxyType"));
        typePanel.add(typeLabel);
        JPanel typeSpacer = new JPanel();
        typeSpacer.setBackground(Color.white);
        typePanel.add(typeSpacer);
        typePanel.add(typeComboBox);
        proxyPanel.add(typePanel);

        JPanel serverPanel = new JPanel();
        serverPanel.setBackground(Color.white);
        serverPanel.setAlignmentX((float)0.0);
        serverPanel.setLayout(new BoxLayout(serverPanel, BoxLayout.X_AXIS));
        serverLabel = new JLabel(JDictionary.getString("ProxyServer"));
        serverPanel.add(serverLabel);
        JPanel serverSpacer = new JPanel();
        serverSpacer.setBackground(Color.white);
        serverPanel.add(serverSpacer);
        serverPanel.add(serverTextField);
        proxyPanel.add(serverPanel);

        JPanel portPanel = new JPanel();
        portPanel.setBackground(Color.white);
        portPanel.setAlignmentX((float)0.0);
        portPanel.setLayout(new BoxLayout(portPanel, BoxLayout.X_AXIS));
        portLabel = new JLabel(JDictionary.getString("ProxyPort"));
        portPanel.add(portLabel);
        JPanel portSpacer = new JPanel();
        portSpacer.setBackground(Color.white);
        portPanel.add(portSpacer);
        portPanel.add(portTextField);
        proxyPanel.add(portPanel);

        proxyPanel.add(authCheckBox);

        JPanel loginPanel = new JPanel();
        loginPanel.setBackground(Color.white);
        loginPanel.setAlignmentX((float)0.0);
        loginPanel.setLayout(new BoxLayout(loginPanel, BoxLayout.X_AXIS));
        loginLabel = new JLabel(JDictionary.getString("ProxyLogin"));
        loginPanel.add(loginLabel);
        JPanel loginSpacer = new JPanel();
        loginSpacer.setBackground(Color.white);
        loginPanel.add(loginSpacer);
        loginPanel.add(loginTextField);
        proxyPanel.add(loginPanel);

        JPanel passwordPanel = new JPanel();
        passwordPanel.setBackground(Color.white);
        passwordPanel.setLayout(new BoxLayout(passwordPanel, BoxLayout.X_AXIS));
        passwordLabel = new JLabel(JDictionary.getString("ProxyPassword"));
        passwordPanel.add(passwordLabel);
        JPanel passwordSpacer = new JPanel();
        passwordSpacer.setBackground(Color.white);
        passwordPanel.add(passwordSpacer);
        passwordPanel.add(passwordField);
        passwordPanel.setAlignmentX((float)0.0);
        proxyPanel.add(passwordPanel);

        networkPanel.add(networkIconPanel);
        JPanel networkSpacer = new JPanel();
        networkSpacer.setMaximumSize(new Dimension(30, 30));
        networkSpacer.setBackground(Color.white);
        networkPanel.add(networkSpacer);
        networkPanel.add(proxyPanel);
        //end of network section setup


        //setting up startup section
        JPanel startupPanel = new JPanel();
        startupPanel.setBackground(Color.white);
        startupPanel.setLayout(new BoxLayout(startupPanel, BoxLayout.X_AXIS));
        startupPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("StartupPrefs")));

        JLabel startupLabel = new JLabel();
        startupLabel = new JLabel(IconBank.getIconByName("Download.png"));
        startupLabel.setAlignmentY(0);

        JPanel startupIconPanel = new JPanel();
        startupIconPanel.setBackground(Color.white);
        startupIconPanel.add(startupLabel);
        startupIconPanel.setMaximumSize(new Dimension(64, 64));
        startupIconPanel.setAlignmentY(0);


        upgradeCheckBox = new JCheckBox(JDictionary.getString("CheckForUpgrades"));
        upgradeCheckBox.setBackground(Color.white);
        upgradeCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                upgradeCheckBox_actionPerformed(e);
            }
        });

        newsCheckBox = new JCheckBox(JDictionary.getString("CheckForNews"));
        newsCheckBox.setBackground(Color.white);
        newsCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                newsCheckBox_actionPerformed(e);
            }
        });

        JPanel startupSettingsPanel = new JPanel();
        startupSettingsPanel.setBackground(Color.white);
        startupSettingsPanel.setAlignmentY(0);
        startupSettingsPanel.setLayout(new BoxLayout(startupSettingsPanel, BoxLayout.Y_AXIS));
        startupSettingsPanel.add(upgradeCheckBox);
        startupSettingsPanel.add(newsCheckBox);
        startupSettingsPanel.setMaximumSize(new Dimension(380, 60));
        startupSettingsPanel.setPreferredSize(new Dimension(300, 60));

        startupPanel.add(startupIconPanel);
        JPanel startupSpacer = new JPanel();
        startupSpacer.setMaximumSize(new Dimension(30, 30));
        startupSpacer.setBackground(Color.white);
        startupPanel.add(startupSpacer);
        startupPanel.add(startupSettingsPanel);
        //end of startup section setup


        applyButton = new JButton(JDictionary.getString("ApplyButton"));
        applyButton.setAlignmentX((float)0.5);
        applyButton.setIcon(IconBank.getIconByName("Check.png"));
        applyButton.setEnabled(false);
        applyButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                applyButton_actionPerformed(e);
            }
        });

        output = new JPanel();
        output.setBackground(Color.white);
        output.setLayout(new BoxLayout(output, BoxLayout.Y_AXIS));
        output.setAlignmentX((float)0.0);
        JPanel outputSpacer1 = new JPanel();
        outputSpacer1.setBackground(Color.white);
        output.add(outputSpacer1);
        output.add(networkPanel);
        JPanel outputSpacer2 = new JPanel();
        outputSpacer2.setBackground(Color.white);
        output.add(outputSpacer2);
        output.add(startupPanel);
        JPanel outputSpacer3 = new JPanel();
        outputSpacer3.setBackground(Color.white);
        output.add(outputSpacer3);
        output.add(applyButton);
        JPanel outputSpacer4 = new JPanel();
        outputSpacer3.setBackground(Color.white);
        output.add(outputSpacer3);

        outputScrollPane = new JScrollPane();
        outputScrollPane.getViewport().add(output);

        add(header);
        add(outputScrollPane);

        updateNetworkSection();
        fillupNetworkTextFields();
        updateStartupSection();
    }


    void proxyCheckBox_stateChanged(ChangeEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
        updateNetworkSection();
    }


    void authCheckBox_stateChanged(ChangeEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
        if(authCheckBox.isSelected()) {
            if(typeComboBox.getSelectedItem().equals(httpType))
                usingHttpProxyLogin = true;
            if(typeComboBox.getSelectedItem().equals(socksType))
                usingSocksProxyLogin = true;
        }
        else {
            if(typeComboBox.getSelectedItem().equals(httpType))
                usingHttpProxyLogin = false;
            if(typeComboBox.getSelectedItem().equals(socksType))
                usingSocksProxyLogin = false;
        }
        updateNetworkSection();
    }


    void typeComboBox_actionPerformed(ActionEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
        updateNetworkSection();
        updateNetworkSectionTextFields();
    }


    void serverTextField_keyTyped(KeyEvent e) {
           changesSaved = false;
           checkApplyButtonStatus();
       }


    void portTextField_keyTyped(KeyEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
    }


    void loginTextField_keyTyped(KeyEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
    }


    void passwordField_keyTyped(KeyEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
    }


    void upgradeCheckBox_actionPerformed(ActionEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
        if(((JCheckBox)e.getSource()).isSelected())
            prefs.CheckingForUpgrade = true;
        else
            prefs.CheckingForUpgrade = false;
        updateStartupSection();
    }


    void newsCheckBox_actionPerformed(ActionEvent e) {
        changesSaved = false;
        checkApplyButtonStatus();
        if(((JCheckBox)e.getSource()).isSelected())
            prefs.CheckingForNews = true;
        else
            prefs.CheckingForNews = false;
        updateStartupSection();
    }

    void checkApplyButtonStatus() {
        if(!changesSaved)
            applyButton.setEnabled(true);
    }


    void applyButton_actionPerformed(ActionEvent e) {
        if(savePrefs()) {
            jDictionary.initProxy();
            applyButton.setEnabled(false);
        }
    }


    //this will perform some auto save like stuff
    //(if user forget to click the 'Apply' button)
    //void pluginManager_pluginSelected(PluginSelectionEvent e) {
    //    if(!changesSaved)
    //        if(savePrefs()) {
    //            jDictionary.initProxy();
    //            applyButton.setEnabled(false);
    //        }
    //}


    boolean savePrefs() {
        prefs.CheckingForNews = newsCheckBox.isSelected();
        prefs.CheckingForUpgrade = upgradeCheckBox.isSelected();

        if(validateNetworkSectionTextFileds()) {
            if(typeComboBox.getSelectedItem().equals(httpType)) {
                prefs.usingHttpProxy = true;
                prefs.usingSocksProxy = false;
                saveNetworkTextFields(httpType);
            }
            if(typeComboBox.getSelectedItem().equals(socksType)) {
                prefs.usingSocksProxy = true;
                prefs.usingHttpProxy = false;
                saveNetworkTextFields(socksType);
            }
            if(!proxyCheckBox.isSelected()) {
                prefs.usingSocksProxy = false;
                prefs.usingHttpProxy = false;
            }
            prefs.usingHttpProxyLogin = usingHttpProxyLogin;
            prefs.usingSocksProxyLogin = usingSocksProxyLogin;
            prefs.httpProxyServer = httpServer;
            prefs.httpProxyPort = httpPort;
            prefs.httpProxyLogin = httpLogin;
            prefs.httpProxyPassword = httpPassword;
            prefs.socksProxyServer = socksServer;
            prefs.socksProxyPort = socksPort;
            prefs.socksProxyLogin = socksLogin;
            prefs.socksProxyPassword = socksPassword;
            changesSaved = true;
            return true;
        }
        return false;
    }


    void updateNetworkSection() {
        if(proxyCheckBox.isSelected()) {
            typeComboBox.setEnabled(true);
            typeLabel.setEnabled(true);
            portTextField.setEnabled(true);
            serverTextField.setEnabled(true);
            serverLabel.setEnabled(true);
            portLabel.setEnabled(true);
            authCheckBox.setEnabled(true);

            if((usingHttpProxyLogin && typeComboBox.getSelectedItem().equals(httpType)) || usingSocksProxyLogin && typeComboBox.getSelectedItem().equals(socksType)) {
                if(!authCheckBox.isSelected())
                    authCheckBox.setSelected(true);
                loginTextField.setEnabled(true);
                passwordField.setEnabled(true);
                loginLabel.setEnabled(true);
                passwordLabel.setEnabled(true);
            }
            else {
                if(authCheckBox.isSelected())
                    authCheckBox.setSelected(false);
                loginTextField.setEnabled(false);
                passwordField.setEnabled(false);
                loginLabel.setEnabled(false);
                passwordLabel.setEnabled(false);
            }
        }
        else {
            typeComboBox.setEnabled(false);
            typeLabel.setEnabled(false);
            portTextField.setEnabled(false);
            serverTextField.setEnabled(false);
            serverLabel.setEnabled(false);
            portLabel.setEnabled(false);
            authCheckBox.setEnabled(false);
            loginTextField.setEnabled(false);
            passwordField.setEnabled(false);
            loginLabel.setEnabled(false);
            passwordLabel.setEnabled(false);
        }
    }


    void updateNetworkSectionTextFields() {

        if(shownType.equals(typeComboBox.getSelectedItem())) {
            return;
        }
        else {
            shownType = (String)typeComboBox.getSelectedItem();
            if(shownType.equals(httpType))
                this.saveNetworkTextFields(socksType);
            if(shownType.equals(socksType))
                this.saveNetworkTextFields(httpType);
            this.fillupNetworkTextFields();
        }
    }


    boolean validateNetworkSectionTextFileds() {
        boolean approved = true;

        if(proxyCheckBox.isSelected()) {
            if(serverTextField.getText().length() == 0 && portTextField.getText().length() == 0)
                proxyCheckBox.setSelected(false);
            else {
                if(serverTextField.getText().length() == 0) {
                    approved = false;
                    highLightTextField(serverTextField);
                }
                if(portTextField.getText().length() > 0) {
                    RE regexp = null;
                    try {
                        regexp = new RE("^[0-9]+$");
                    }
                    catch(org.apache.regexp.RESyntaxException e) {}
                    if(!regexp.match(portTextField.getText())) {
                        approved = false;
                        highLightTextField(portTextField);
                    }
                }
                else {
                    if(typeComboBox.getSelectedItem().equals(httpType))
                        portTextField.setText("80");
                    if(typeComboBox.getSelectedItem().equals(socksType))
                        portTextField.setText("1080");
                }
            }
        }

        if(authCheckBox.isSelected()) {
            if(loginTextField.getText().length() == 0 && passwordField.getPassword().length == 0)
                this.authCheckBox.setSelected(false);
            else {
                if(loginTextField.getText().length() == 0) {
                    approved = false;
                    highLightTextField(loginTextField);
                }
                if(passwordField.getPassword().length == 0) {
                    approved = false;
                    highLightTextField(passwordField);
                }
            }
        }
    return approved;
    }


    void fillupNetworkTextFields() {
        if(typeComboBox.getSelectedItem().equals(httpType)) {
                serverTextField.setText(httpServer);
                portTextField.setText(httpPort);
                loginTextField.setText(httpLogin);
                passwordField.setText(new String(httpPassword));
           }
           if(typeComboBox.getSelectedItem().equals(socksType)) {
               serverTextField.setText(socksServer);
               portTextField.setText(socksPort);
               loginTextField.setText(socksLogin);
               passwordField.setText(new String(socksPassword));
           }
    }


    void saveNetworkTextFields(String type) {
        if(type.equals(httpType)) {
            httpServer = serverTextField.getText();
            httpPort = portTextField.getText();
            httpLogin = loginTextField.getText();
            httpPassword = passwordField.getPassword();
        }
        if(type.equals(socksType)) {
            socksServer = serverTextField.getText();
            socksPort = portTextField.getText();
            socksLogin = loginTextField.getText();
            socksPassword = passwordField.getPassword();
        }
    }


    void updateStartupSection() {
        if(prefs.CheckingForNews)
            newsCheckBox.setSelected(true);
        else
            newsCheckBox.setSelected(false);
        if(prefs.CheckingForUpgrade)
            upgradeCheckBox.setSelected(true);
        else
            upgradeCheckBox.setSelected(false);
    }


    void highLightTextField(final JTextField textField) {
        if(textField.getBackground().equals(highLightColor))
            return;
        final Color originalColor = textField.getBackground();
        new Thread() {
            public void run() {
                textField.setBackground(highLightColor);
                try {
                    sleep(1500);
                }
                catch(java.lang.InterruptedException e) {}
                textField.setBackground(originalColor);
            }
        }.start();
    }
}