/*
 * 01/09/2002 - 20:43:57
 *
 * InfoPanel.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.gui;

import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.BoxLayout;
import java.awt.Color;
import java.awt.BorderLayout;


public abstract class InfoPanel extends JPanel {

    JLabel header = new JLabel(getHeader());
    JLabel text = new JLabel(getBody());
    JPanel jPanel = new JPanel();
    BorderLayout borderLayout = new BorderLayout();
    BoxLayout boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);

    public InfoPanel() {
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception {
        setLayout(boxLayout);
        jPanel.setLayout(borderLayout);
        jPanel.setBackground(Color.white);
        jPanel.setAlignmentX((float) 0.0);
        this.setBackground(Color.white);
        jPanel.add(text, BorderLayout.CENTER);
        this.add(header, null);
        this.add(jPanel, null);
    }

    abstract ImageIcon getHeader();
    abstract ImageIcon getBody();



}


