/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultHeader.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.modules;

import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.ImageBank;
import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JLabel;

public class DefaultHeader extends JPanel {

    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    DefaultFrameAssembler assembler;

    public DefaultHeader(DefaultFrameAssembler assembler) {
        super();
        this.assembler = assembler;

        setBackground(Color.black);
        setAlignmentX((float) 0.0);
        setAlignmentY((float) 0.0);
        setMaximumSize(new Dimension(2048, 60));
        setLayout(new BorderLayout());
        jLabel1.setIcon(ImageBank.getImageByName("MainHeaderLeftSide.png"));
        jLabel2.setIcon(ImageBank.getImageByName("MainHeaderRightSide.png"));
        add(jLabel1, BorderLayout.WEST);
        add(jLabel2, BorderLayout.EAST);
    }
}