/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultMenuBar.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary.modules;

import java.awt.event.ActionEvent;
import info.jdictionary.JDictionary;
import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.IconBank;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class DefaultMenuBar extends JMenuBar {

    DefaultFrameAssembler assembler;

    JMenu jDictionaryMenu = new JMenu();
    JMenu pluginMenu = new JMenu();
    JMenu toolsMenu = new JMenu();

    JMenuItem exitMenuItem = new JMenuItem();
    JMenuItem aboutMenuItem = new JMenuItem();
    JMenuItem downloadMenuItem = new JMenuItem();
    JMenuItem activateMenuItem = new JMenuItem();
    JMenuItem rescanMenuItem = new JMenuItem();
    JMenuItem preferencesMenuItem = new JMenuItem();
    JMenuItem newsAgentMenuItem = new JMenuItem();
    JMenuItem upgradeAgentMenuItem = new JMenuItem();

    public DefaultMenuBar(DefaultFrameAssembler assembler) {
        super();
        this.assembler = assembler;

        add(jDictionaryMenu);
        add(pluginMenu);
        add(toolsMenu);

        jDictionaryMenu.add(aboutMenuItem);
        jDictionaryMenu.addSeparator();
        jDictionaryMenu.add(exitMenuItem);

        pluginMenu.add(downloadMenuItem);
        pluginMenu.add(activateMenuItem);
        pluginMenu.add(rescanMenuItem);

        toolsMenu.add(upgradeAgentMenuItem);
        toolsMenu.add(newsAgentMenuItem);
        toolsMenu.add(preferencesMenuItem);

        jDictionaryMenu.setText(JDictionary.getString("JDictionaryMenu"));
        pluginMenu.setText(JDictionary.getString("PluginsMenu"));
        toolsMenu.setText(JDictionary.getString("ToolsMenu"));

        exitMenuItem.setText(JDictionary.getString("ExitMenuItem"));
        exitMenuItem.setIcon(IconBank.exit);
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitMenuItem_actionPerformed(e);
            }
        });

        aboutMenuItem.setText(JDictionary.getString("AboutMenuItem"));
        aboutMenuItem.setIcon(IconBank.info);
        aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                aboutMenuItem_actionPerformed(e);
            }
        });

        downloadMenuItem.setText(JDictionary.getString("Download&Install"));
        downloadMenuItem.setIcon(IconBank.FolderIn);
        downloadMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                downloadMenuItem_actionPerformed(e);
            }
        });

        activateMenuItem.setText(JDictionary.getString("ActivateDeactivate"));
        activateMenuItem.setIcon(IconBank.plug);
        activateMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                activateMenuItem_actionPerformed(e);
            }
        });

        rescanMenuItem.setText(JDictionary.getString("Rescan"));
        rescanMenuItem.setIcon(IconBank.rescan);
        rescanMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                rescanMenuItem_actionPerformed(e);
            }
        });

        newsAgentMenuItem.setText(JDictionary.getString("NewsAgentMenuItem"));
        newsAgentMenuItem.setIcon(IconBank.envelope);
        newsAgentMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                newsAgentMenuItem_actionPerformed(e);
            }
        });

        upgradeAgentMenuItem.setText(JDictionary.getString("UpgradeAgentMenuItem"));
        upgradeAgentMenuItem.setIcon(IconBank.laptopIn);
        upgradeAgentMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                upgradeAgentMenuItem_actionPerformed(e);
            }
        });

        preferencesMenuItem.setText(JDictionary.getString("Preferences"));
        preferencesMenuItem.setIcon(IconBank.hammer);
        preferencesMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                preferencesMenuItem_actionPerformed(e);
            }
        });
    }


   void aboutMenuItem_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getSplashScreen());
    }


    void exitMenuItem_actionPerformed(ActionEvent e) {
        assembler.getJDictionary().closeJDictionary();
    }


    void downloadMenuItem_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginDownloader());
    }


    void activateMenuItem_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginStatusChanger());
    }


    void rescanMenuItem_actionPerformed(ActionEvent e) {
        assembler.getJDictionary().getPluginManager().scanPlugins();
    }


    void newsAgentMenuItem_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getNewsAgent());
    }


    void upgradeAgentMenuItem_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getUpgradeAgent());
    }


    void preferencesMenuItem_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPreferencesScreen());
    }
}
