/*
 * 01/09/2002 - 20:43:57
 *
 * JDictionaryResources.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.resource;

import java.util.ListResourceBundle;

public class JDictionaryResources extends ListResourceBundle {

    public Object[][] getContents() {
        return contents;
    }


    static final Object[][] contents = {

        {"JDictionaryVersion", "1.8"},
        {"InfoServerURL", "http://jdictionary.sourceforge.net/info"},
        //{"InfoServerURL", "http://127.0.0.1"},  //for testing
        {"SourceforgeDownloadServerURL", "http://west.dl.sourceforge.net/sourceforge/jdictionary"},
        //{"SourceforgeDownloadServerURL", "http://127.0.0.1"},
        {"LatestFile", "LATEST"},  // On the infoserver
        {"LatestNewsFile", "LATEST_NEWS"}, // On the infoserver
        {"UpgradeFile", "upgrade"},  //On the infoserver
        {"NewsPage", "news"},  //On the infoserver
        {"InfoSheetsFile", "DownloadablePlugins"}, // On the infoserver
        {"InfoAboutNewVersionFile", "NewVersionInfo.png"},  // On the infoserver
        {"SavedDirName", ".jdictionary"},
        {"PluginInfoSheetFileName", "InfoSheet"},
        {"SavedPrefsFileName", "JDictionarySavedPrefs.obj"},
        {"PluginDirName", "Plugins"},
        {"ResourcesDirName" , "resources"},
        {"IconPackDirName" , "iconpack"},
        {"ImagesDirName", "images"},
        {"JDictionaryName", "jDictionary"},
        {"JDictionaryAuthor", "Csaba Kertsz"},
        {"Year", " (c) 2002"},
        {"WebSite", "http://jdictionary.info"},
        {"Dictionaries", "Dictionaries (Local Disk)"},
        {"Download&Install", "Download & Install Plugins"},
        {"ActivateDeactivate", "Activate/Deactivate Plugins"},
        {"Rescan", "Rescan Plugins"},
        {"News", "News & Info"},
        {"Dictionaries", "Dictionaries (Local Disk)"},
        {"KB", "kB"},
        {"KB of", "kB of"},
        {"AvailPlugins", "Available plugins on the pluginserver"},
        {"Tips", "Tips & Info"},
        {"DownloadTip1", "You can start more than one download process at a time"},
        {"DownloadTip2", "While downloading, you can use the plugins already installed"},
        {"DownloadTip3", "If your browser can reach the network you can download plugins from http://jdictionary.info"},
        {"DownloadTip4", "If your browser can reach the network download the new version from:"},
        {"PossibleProblems", "Network error! Possible problems:"},
        {"Problem1", "         - Check whether you are online and try again."},
        {"Problem2", "         - You are behind proxy.    "},
        {"Problem3", "         - Maybe the pluginserver overloaded. Try again a bit later."},
        {"DownloadingInfo", "Downloading info from pluginserver..."},
        {"DownloadingFile", "Downloading file: "},
        {"AvailPluginsPref", "There are "},
        {"AvailPluginsPostf", " plugins available on the pluginserver"},
        {"JDict", "JDict. "},
        {"Needed", " Needed"},
        {"PleseUpgr", "For this plugin please upgrade your JDictionary to version "},
        {"NetError", "Network error! Check the 'Tips & Info' below for possible problems"},
        //{"NetError3", "Network error! Check whether you are online and try again."},
        {"SearchingForDownloadServer", "Searching for Download Server"},
        {"StopDownloading", "Stop"},
        {"AlreadyInstalled", "Already installed"},
        {"YouCanDowngrade", "You can downgrade"},
        {"NewJDictionaryAvailable", "New jDictionary available"},
        {"NewJDictionaryAvailableToolTip", "New JDictionary is available! Click here to upgrade"},
        {"NewerAvailable", "Newer Available"},
        {"InfoAboutNewVersion", "Please wait while downloading the info about new JDictionary version..."},
        {"DownInst", "Download & Install"},
        {"DownUpgr", "Download & Upgrade"},
        {"NotInstalled", "Not installed yet"},
        {"YouHaveNewerVersion", "You have newer!"},
        {"Installing", "Installing dictionary plugin: "},
        {"ReadyToUse", " is ready to use!"},
        {"ErrorAtInstall", "Error occurred while installing "},
        {"ErrorAtDownload", "An error occurred while downloading "},
        {"DownStopPref", "Downloading "},
        {"DownStopPost", " has stopped"},
        {"DownloadAndUpgrade", "Download Upgrade, Install Upgrade and Restart"},
        {"StopDownload", "Stop Download"},
        {"NoPermission", "You have no permission to upgrade"},
        {"DowndloadingNews", "Downloading News..."},
        {"UsingLatestJDictionary", "You are using the latest jDictionary version. Upgrading is not possible."},
        {"PluginVersion", "Version: "},
        {"PluginAuthor", "Author: "},
        {"PluginName", "Name: "},
        {"PluginSize", "Size: "},
        {"PluginDescription", "Description: "},
        {"AvailablePlugins", "Available plugins on your computer"},
        {"NoPlugins", "There Are No Plugins Installed"},
        {"Uninstall", "Uninstall"},
        {"Active", "Active"},
        {"Deactivated", "Deactivated"},
        {"Activate", "Activate!"},
        {"Deactivate", "Deactivate!"},
        {"InstalledButDeactivated", "Installed but deactivated"},
        //preferences
        {"Preferences", "Preferences"},
        {"IUseProxy", "I use proxy server"},
        {"LoginToProxy", "Login to the proxy server"},
        {"ConnectPrefs", "Connection Preferences"},
        {"ProxyType", "Proxy type"},
        {"ProxyServer", "Proxy server:"},
        {"ProxyPort", "Proxy port:"},
        {"ProxyLogin", "Login:"},
        {"ProxyPassword", "Password:"},
        {"StartupPrefs", "Startup Preferences"},
        {"CheckForUpgrades", "Checking for upgrades at startup"},
        {"CheckForNews", "Checking for news at startup"},
        {"ApplyButton", "Apply Changes"},
        //proxyButton
        {"ProxySet", "Proxy settings"},
        //menu
        {"PluginsMenu", "Plugins"},
        {"JDictionaryMenu", "jDictionary"},
        {"ToolsMenu", "Tools"},
        {"AboutMenuItem", "About"},
        {"ExitMenuItem", "Exit"},
        {"NewsAgentMenuItem", "News Agent"},
        {"UpgradeAgentMenuItem", "Upgrade Agent"}
        };
}

