/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.compiler;

import antlr.collections.AST;
import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.Spreadsheet;
import csheets.core.Workbook;
import csheets.core.formula.Expression;
import csheets.core.formula.compiler.ExcelExpressionCompiler;
import csheets.core.formula.compiler.FormulaLexer;
import csheets.core.formula.compiler.FormulaParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;

public class Console {
    public Console(InputStream inputStream, OutputStream outputStream) {
        PrintStream printStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        Workbook workbook = new Workbook(1);
        Spreadsheet spreadsheet = workbook.getSpreadsheet(0);
        Cell cell = spreadsheet.getCell(new Address(0, 0));
        ExcelExpressionCompiler excelExpressionCompiler = new ExcelExpressionCompiler();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        block4: while (true) {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    FormulaParser formulaParser = new FormulaParser(new FormulaLexer(new StringReader(string)));
                    try {
                        formulaParser.expression();
                        AST aST = formulaParser.getAST();
                        if (aST == null) continue block4;
                        printStream.println("AST: " + aST.toStringTree());
                        Expression expression = excelExpressionCompiler.convert(cell, aST);
                        printStream.println("Formula: " + expression + " = " + expression.evaluate());
                        continue block4;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                break;
            }
        }
    }

    public static void main(String[] stringArray) {
        new Console(System.in, System.out);
    }
}

