/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import csheets.core.Cell;
import csheets.core.Value;
import csheets.ext.CellExtension;
import csheets.ext.assertion.AssertableCellListener;
import csheets.ext.assertion.Assertion;
import csheets.ext.assertion.AssertionArithmeticException;
import csheets.ext.assertion.MathException;
import csheets.ext.assertion.SGAssertion;
import csheets.ext.assertion.USAssertion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class AssertableCell
extends CellExtension {
    private static final long serialVersionUID = 4956240183977127091L;
    private USAssertion usAssertion;
    private SGAssertion sgAssertion;
    private transient List<AssertableCellListener> listeners = new ArrayList<AssertableCellListener>();
    private boolean mathError;
    private String mathErrorMsg;

    AssertableCell(Cell cell) {
        super(cell, "Assertions");
    }

    public void contentChanged(Cell cell) {
        if (this.getFormula() != null && !this.getFormula().getReferences().isEmpty()) {
            this.generateAssertion();
        } else {
            this.sgAssertion = null;
            for (Cell cell2 : this.getDependents()) {
                ((AssertableCell)cell2).generateAssertion();
            }
        }
    }

    public USAssertion getUSAssertion() {
        return this.usAssertion;
    }

    public SGAssertion getSGAssertion() {
        return this.sgAssertion;
    }

    public Assertion getPriorityAssertion() {
        if (this.isSGAsserted()) {
            return this.getSGAssertion();
        }
        if (this.isUSAsserted()) {
            return this.getUSAssertion();
        }
        return null;
    }

    public boolean isAsserted() {
        return this.isUSAsserted() || this.isSGAsserted();
    }

    public boolean isUSAsserted() {
        return this.usAssertion != null;
    }

    public boolean isSGAsserted() {
        return this.sgAssertion != null;
    }

    public void setUSAssertion(USAssertion uSAssertion) {
        this.usAssertion = uSAssertion;
        this.fireAssertionsChanged();
        if (this.sgAssertion == null) {
            for (Cell cell : this.getDependents()) {
                ((AssertableCell)cell).generateAssertion();
            }
        }
    }

    public void generateAssertion() {
        if (this.getFormula() != null && !this.getFormula().hasCircularReference()) {
            try {
                this.sgAssertion = new SGAssertion(this);
                this.mathError = false;
                this.mathErrorMsg = null;
            }
            catch (AssertionArithmeticException assertionArithmeticException) {
                this.sgAssertion = null;
                this.mathError = false;
                this.mathErrorMsg = null;
            }
            catch (MathException mathException) {
                this.mathErrorMsg = mathException.getMessage();
                this.mathError = true;
                this.sgAssertion = null;
            }
            for (Cell cell : this.getDependents()) {
                ((AssertableCell)cell).generateAssertion();
            }
            this.fireAssertionsChanged();
        }
    }

    public Assertion.Result assertUS() {
        return this.assertUS(this.getValue());
    }

    public Assertion.Result assertUS(Value value) {
        if (this.usAssertion != null) {
            return this.usAssertion.validate(value);
        }
        return Assertion.Result.OK;
    }

    public Assertion.Result assertSG() {
        return this.assertSG(this.getValue());
    }

    public Assertion.Result assertSG(Value value) {
        if (this.sgAssertion != null) {
            return this.sgAssertion.validate(value);
        }
        return Assertion.Result.OK;
    }

    public Assertion.Result assertAny(Value value) {
        Assertion.Result result = Assertion.Result.OK;
        if (this.isSGAsserted()) {
            result = this.assertSG(value);
        }
        if (result == Assertion.Result.OK && this.isUSAsserted()) {
            result = this.assertUS(value);
        }
        return result;
    }

    public Assertion.Result assertAny() {
        return this.assertAny(this.getValue());
    }

    public Assertion.ComparisonResult assertAssertions() {
        if (!this.isSGAsserted() && this.mathError) {
            Assertion.ComparisonResult comparisonResult = Assertion.ComparisonResult.ILLEGAL_INTERVAL;
            comparisonResult.setErrorMsg(this.mathErrorMsg);
            return comparisonResult;
        }
        if (this.isSGAsserted() && this.isUSAsserted()) {
            return this.sgAssertion.equals(this.usAssertion) ? Assertion.ComparisonResult.OK : Assertion.ComparisonResult.NON_EQUAL;
        }
        return Assertion.ComparisonResult.OK;
    }

    public boolean hasAssertionError() {
        return this.assertAssertions() != Assertion.ComparisonResult.OK || this.assertAny() != Assertion.Result.OK;
    }

    public void addAssertableCellListener(AssertableCellListener assertableCellListener) {
        this.listeners.add(assertableCellListener);
    }

    public void removeAssertableCellListener(AssertableCellListener assertableCellListener) {
        this.listeners.remove(assertableCellListener);
    }

    protected void fireAssertionsChanged() {
        for (AssertableCellListener assertableCellListener : this.listeners) {
            assertableCellListener.assertionsChanged(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new ArrayList<AssertableCellListener>();
    }
}

