/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import csheets.ext.assertion.AssertionException;
import csheets.ext.assertion.AssertionParserTokenTypes;
import csheets.ext.assertion.Interval;
import csheets.ext.assertion.USAssertion;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionParser
extends LLkParser
implements AssertionParserTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "EXCEPT", "','", "OR", "'['", "']'", "TO", "a numeric constant", "'>'", "'<'", "'>='", "'<='", "INTEGER", "end of line", "whitespace", "DIGIT", "'+'", "'-'", "EXPONENT"};

    protected AssertionParser(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
        this.tokenNames = _tokenNames;
    }

    public AssertionParser(TokenBuffer tokenBuffer) {
        this(tokenBuffer, 1);
    }

    protected AssertionParser(TokenStream tokenStream, int n) {
        super(tokenStream, n);
        this.tokenNames = _tokenNames;
    }

    public AssertionParser(TokenStream tokenStream) {
        this(tokenStream, 1);
    }

    public AssertionParser(ParserSharedInputState parserSharedInputState) {
        super(parserSharedInputState, 1);
        this.tokenNames = _tokenNames;
    }

    public final void assertion(USAssertion uSAssertion, List<Interval> list, List<Interval> list2) throws RecognitionException, TokenStreamException, AssertionException {
        uSAssertion.isInteger = false;
        switch (this.LA(1)) {
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.or_expr(list);
                break;
            }
            case 1: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 4: {
                this.except_clause(list2);
                break;
            }
            case 1: 
            case 15: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 15: {
                this.is_integer(uSAssertion);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(1);
    }

    public final void or_expr(List<Interval> list) throws RecognitionException, TokenStreamException, AssertionException {
        this.term(list);
        while (this.LA(1) == 6) {
            this.match(6);
            this.term(list);
        }
    }

    public final void except_clause(List<Interval> list) throws RecognitionException, TokenStreamException, AssertionException {
        this.match(4);
        this.term(list);
        while (this.LA(1) == 5) {
            this.match(5);
            this.term(list);
        }
    }

    public final void is_integer(USAssertion uSAssertion) throws RecognitionException, TokenStreamException {
        this.match(15);
        uSAssertion.isInteger = true;
    }

    public final void term(List<Interval> list) throws RecognitionException, TokenStreamException, AssertionException {
        switch (this.LA(1)) {
            case 7: 
            case 8: {
                this.interval(list);
                break;
            }
            case 10: {
                double d = this.constant();
                try {
                    list.add(new Interval(d));
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new AssertionException("Invalid constant specified in assertion");
                }
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.os_interval(list);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void interval(List<Interval> list) throws RecognitionException, TokenStreamException, AssertionException {
        Token token = null;
        Token token2 = null;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        switch (this.LA(1)) {
            case 7: {
                token = this.LT(1);
                this.match(7);
                bl = true;
                break;
            }
            case 8: {
                token2 = this.LT(1);
                this.match(8);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        d = this.constant();
        this.match(9);
        d2 = this.constant();
        switch (this.LA(1)) {
            case 7: {
                this.match(7);
                break;
            }
            case 8: {
                this.match(8);
                bl2 = true;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        Token token3 = bl ? token : token2;
        try {
            list.add(new Interval(d, d2, bl, bl2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionException(token3.getLine(), token3.getColumn(), illegalArgumentException.getMessage());
        }
    }

    public final double constant() throws RecognitionException, TokenStreamException {
        Token token = null;
        double d = 0.0;
        token = this.LT(1);
        this.match(10);
        d = Double.parseDouble(token.getText());
        return d;
    }

    public final void os_interval(List<Interval> list) throws RecognitionException, TokenStreamException, AssertionException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        double d = 0.0;
        boolean bl = false;
        boolean bl2 = true;
        switch (this.LA(1)) {
            case 11: {
                token = this.LT(1);
                this.match(11);
                break;
            }
            case 12: {
                token2 = this.LT(1);
                this.match(12);
                bl2 = false;
                break;
            }
            case 13: {
                token3 = this.LT(1);
                this.match(13);
                bl = true;
                break;
            }
            case 14: {
                token4 = this.LT(1);
                this.match(14);
                bl = true;
                bl2 = false;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        d = this.constant();
        Token token5 = bl2 ? (bl ? token3 : token) : (bl ? token4 : token2);
        try {
            if (bl2) {
                list.add(new Interval(d, Double.POSITIVE_INFINITY, bl, false));
            } else {
                list.add(new Interval(Double.NEGATIVE_INFINITY, d, false, bl));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionException(token5.getLine(), token5.getColumn(), illegalArgumentException.toString());
        }
    }
}

