/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.deptree;

import csheets.core.Cell;
import csheets.ext.deptree.CellNode;
import csheets.ext.deptree.DependencyTreeExtension;
import csheets.ext.deptree.ReferenceNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DependencyTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon formulaIcon = new ImageIcon(DependencyTreeExtension.class.getResource("res/img/formula.gif"));
    private Icon literalIcon = new ImageIcon(DependencyTreeExtension.class.getResource("res/img/literal.gif"));
    private Icon rangeIcon = new ImageIcon(DependencyTreeExtension.class.getResource("res/img/range.gif"));

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof CellNode) {
            Icon icon;
            Cell cell = ((CellNode)object).getCell();
            if (cell.getFormula() == null) {
                icon = this.literalIcon;
                this.setToolTipText(cell.getValue().toString());
            } else {
                icon = this.formulaIcon;
                this.setToolTipText(cell.getValue() + " = " + cell.getFormula());
            }
            if (bl3) {
                this.setLeafIcon(icon);
            } else {
                this.setOpenIcon(icon);
                this.setClosedIcon(icon);
            }
        } else if (object instanceof ReferenceNode) {
            this.setOpenIcon(this.rangeIcon);
            this.setClosedIcon(this.rangeIcon);
        }
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }
}

