/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.deptree;

import csheets.core.Cell;
import csheets.core.formula.Reference;
import csheets.core.formula.lang.CellReference;
import csheets.ext.deptree.CellNode;
import csheets.ext.deptree.ReferenceNode;
import csheets.ui.ctrl.UIController;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.tree.DefaultTreeModel;

public class PrecedentsNode
extends CellNode {
    private SortedSet<Reference> references = new TreeSet<Reference>();
    private UIController uiController;

    public PrecedentsNode(Cell cell, DefaultTreeModel defaultTreeModel, UIController uIController) {
        super(cell, defaultTreeModel);
        this.uiController = uIController;
        if (cell.getFormula() != null) {
            this.references = cell.getFormula().getReferences();
        }
    }

    protected void addChildren() {
        for (Reference reference : this.references) {
            if (reference instanceof CellReference) {
                Cell cell = ((CellReference)reference).getCell();
                this.add(new PrecedentsNode(cell, this.treeModel, this.uiController));
                continue;
            }
            this.add(new ReferenceNode(reference, this.getCell().getSpreadsheet(), this.treeModel, this.uiController));
        }
    }

    public boolean isLeaf() {
        return this.references.isEmpty();
    }
}

