/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.style;

import csheets.core.Cell;
import csheets.core.Value;
import csheets.ext.CellExtension;
import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class StylableCell
extends CellExtension {
    private static final long serialVersionUID = -4860391005521272291L;
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    public static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    public static final Font FONT = UIManager.getFont("Table.font");
    public static final int VERTICAL_ALIGNMENT = 0;
    public static final Color FOREGROUND = UIManager.getColor("Table.foreground");
    public static final Color BACKGROUND = UIManager.getColor("Table.background");
    public static final Border BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Format format;
    private Font font;
    private int hAlignment;
    private int vAlignment;
    private Color fgColor;
    private Color bgColor;
    private Border border;

    StylableCell(Cell cell) {
        super(cell, "Style");
        this.resetStyle();
    }

    public boolean isFormattable() {
        Value.Type type = this.getValue().getType();
        return type == Value.Type.NUMERIC || type == Value.Type.DATE;
    }

    public Format getFormat() {
        switch (this.getValue().getType()) {
            case NUMERIC: {
                return this.format instanceof NumberFormat ? this.format : NUMBER_FORMAT;
            }
            case DATE: {
                return this.format instanceof DateFormat ? this.format : DATE_FORMAT;
            }
        }
        return null;
    }

    public Font getFont() {
        return this.font;
    }

    public int getHorizontalAlignment() {
        if (this.hAlignment == -1) {
            switch (this.getValue().getType()) {
                case NUMERIC: 
                case DATE: {
                    return 4;
                }
                case BOOLEAN: 
                case ERROR: {
                    return 0;
                }
            }
            return 2;
        }
        return this.hAlignment;
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public Color getForegroundColor() {
        return this.fgColor;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setHorizontalAlignment(int n) {
        if (n != 2 && n != 0 && n != 4) {
            throw new IllegalArgumentException("Illegal alignment");
        }
        this.hAlignment = n;
    }

    public void setVerticalAlignment(int n) {
        if (n != 1 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Illegal alignment");
        }
        this.vAlignment = n;
    }

    public void setForegroundColor(Color color) {
        this.fgColor = color;
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void resetStyle() {
        this.format = null;
        this.font = FONT;
        this.hAlignment = -1;
        this.vAlignment = 0;
        this.fgColor = FOREGROUND;
        this.bgColor = BACKGROUND;
        this.border = BORDER;
    }

    public void cellCleared(Cell cell) {
        if (this.getDelegate().equals(cell)) {
            this.resetStyle();
        }
    }

    public void cellCopied(Cell cell, Cell cell2) {
        if (this.getDelegate().equals(cell)) {
            StylableCell stylableCell = (StylableCell)cell2.getExtension("Style");
            this.format = stylableCell.format;
            this.font = stylableCell.font;
            this.hAlignment = stylableCell.hAlignment;
            this.vAlignment = stylableCell.vAlignment;
            this.fgColor = stylableCell.fgColor;
            this.bgColor = stylableCell.bgColor;
            this.border = stylableCell.border;
        }
    }
}

