/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.style.ui;

import csheets.ext.style.StyleExtension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class BorderChooser
extends JComponent {
    private JToggleButton topButton = new JToggleButton(new ImageIcon(StyleExtension.class.getResource("res/img/border_top.gif")));
    private JToggleButton leftButton = new JToggleButton(new ImageIcon(StyleExtension.class.getResource("res/img/border_left.gif")));
    private JToggleButton rightButton = new JToggleButton(new ImageIcon(StyleExtension.class.getResource("res/img/border_right.gif")));
    private JToggleButton bottomButton = new JToggleButton(new ImageIcon(StyleExtension.class.getResource("res/img/border_bottom.gif")));
    private JLabel previewLabel = new JLabel("");
    private Color color = Color.black;

    public BorderChooser() {
        this(null);
    }

    public BorderChooser(Border border) {
        this.previewLabel.setPreferredSize(new Dimension(100, 80));
        this.previewLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Preview"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        PreviewLabelUpdater previewLabelUpdater = new PreviewLabelUpdater();
        this.topButton.addItemListener(previewLabelUpdater);
        this.leftButton.addItemListener(previewLabelUpdater);
        this.rightButton.addItemListener(previewLabelUpdater);
        this.bottomButton.addItemListener(previewLabelUpdater);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.leftButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.topButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.bottomButton, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.rightButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Border"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = new JButton(new ColorAction());
        jButton.setAlignmentY(0.5f);
        jPanel2.add(jButton);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Color"));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "East");
        this.add((Component)this.previewLabel, "South");
        this.setSelectedBorder(border);
    }

    public static Border showDialog(Component component, String string, Border border) {
        BorderChooser borderChooser = new BorderChooser(border);
        int n = JOptionPane.showConfirmDialog(component, borderChooser, string, 2, -1, null);
        if (n == 0) {
            return borderChooser.getSelectedBorder();
        }
        return null;
    }

    public Border getSelectedBorder() {
        return BorderFactory.createMatteBorder(this.topButton.isSelected() ? 1 : 0, this.leftButton.isSelected() ? 1 : 0, this.bottomButton.isSelected() ? 1 : 0, this.rightButton.isSelected() ? 1 : 0, this.color);
    }

    public void setSelectedBorder(Border border) {
        if (border instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)border;
            this.color = matteBorder.getMatteColor();
            Insets insets = matteBorder.getBorderInsets();
            this.topButton.setSelected(insets.top > 0);
            this.leftButton.setSelected(insets.left > 0);
            this.bottomButton.setSelected(insets.bottom > 0);
            this.rightButton.setSelected(insets.right > 0);
        }
    }

    private void updatePreviewBorder() {
        this.previewLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Preview"), BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.getSelectedBorder())));
    }

    private class ColorAction
    extends AbstractAction {
        public ColorAction() {
            this.putValue("SmallIcon", new ImageIcon(StyleExtension.class.getResource("res/img/color_bg.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(null, "Choose Border Color", BorderChooser.this.color);
            if (color != null) {
                BorderChooser.this.color = color;
                BorderChooser.this.updatePreviewBorder();
            }
        }
    }

    private class PreviewLabelUpdater
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            BorderChooser.this.updatePreviewBorder();
        }
    }
}

