/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.style.ui;

import csheets.core.Cell;
import csheets.ext.style.StylableCell;
import csheets.ext.style.StyleExtension;
import csheets.ui.ctrl.FocusOwnerAction;
import csheets.ui.ctrl.UIController;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;

public class ForegroundAction
extends FocusOwnerAction {
    protected UIController uiController;

    public ForegroundAction(UIController uIController) {
        this.uiController = uIController;
    }

    protected String getName() {
        return "Foreground Color...";
    }

    protected void defineProperties() {
        this.putValue("MnemonicKey", 67);
        this.putValue("SmallIcon", new ImageIcon(StyleExtension.class.getResource("res/img/color_fg.gif")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.focusOwner == null) {
            return;
        }
        Color color = JColorChooser.showDialog(null, "Choose Foreground Color", ((StylableCell)this.focusOwner.getSelectedCell().getExtension("Style")).getForegroundColor());
        if (color != null) {
            Cell[][] cellArray = this.focusOwner.getSelectedCells();
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cellArray2;
                for (Cell cell : cellArray2 = cellArray[i]) {
                    StylableCell stylableCell = (StylableCell)cell.getExtension("Style");
                    stylableCell.setForegroundColor(color);
                }
            }
            this.uiController.setWorkbookModified(this.focusOwner.getSpreadsheet().getWorkbook());
            this.focusOwner.repaint();
        }
    }
}

