/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test;

import csheets.core.Spreadsheet;
import csheets.ext.SpreadsheetExtension;
import csheets.ext.test.TestCase;
import csheets.ext.test.TestableCell;
import java.util.Set;

public class TestableSpreadsheet
extends SpreadsheetExtension {
    private static final long serialVersionUID = -8144504629252776866L;

    protected TestableSpreadsheet(Spreadsheet spreadsheet) {
        super(spreadsheet, "Test Cases");
    }

    public double getTestedness() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                TestableCell testableCell = (TestableCell)this.getCell(j, i);
                if (!testableCell.hasTestCases()) continue;
                Set<TestCase> set = testableCell.getTestCases();
                d += (double)set.size();
                for (TestCase testCase : set) {
                    if (testCase.getValidationState() != TestCase.ValidationState.VALID) continue;
                    d2 += 1.0;
                }
            }
        }
        if (d > 0.0) {
            return d2 / d;
        }
        return 0.0;
    }
}

