/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test.ui;

import csheets.core.Cell;
import csheets.ext.Extensible;
import csheets.ext.test.TestExtension;
import csheets.ext.test.TestableCell;
import csheets.ext.test.TestableCellListener;
import csheets.ext.test.TestableSpreadsheet;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;

public class TestToolBar
extends JToolBar
implements SelectionListener,
TestableCellListener {
    private JProgressBar cellTestednessBar;
    private JProgressBar spreadsheetTestednessBar;
    private JLabel lightLabelTestCases;
    private Icon redIcon;
    private Icon yellowIcon;
    private Icon greenIcon;

    public TestToolBar() {
        this.setName("Test Cases");
        this.redIcon = new ImageIcon(TestExtension.class.getResource("res/img/light_red.gif"), "Red light");
        this.yellowIcon = new ImageIcon(TestExtension.class.getResource("res/img/light_yellow.gif"), "Yellow light");
        this.greenIcon = new ImageIcon(TestExtension.class.getResource("res/img/light_green.gif"), "Green light");
        this.lightLabelTestCases = new JLabel(this.yellowIcon);
        this.cellTestednessBar = new JProgressBar(1);
        this.cellTestednessBar.setPreferredSize(new Dimension(20, 20));
        this.cellTestednessBar.setToolTipText("Cell Testedness");
        this.cellTestednessBar.setString("0 %");
        this.spreadsheetTestednessBar = new JProgressBar(1);
        this.spreadsheetTestednessBar.setPreferredSize(new Dimension(20, 20));
        this.spreadsheetTestednessBar.setToolTipText("Spreadsheet Testedness");
        this.spreadsheetTestednessBar.setString("0 %");
        this.add(new JLabel(new ImageIcon(TestExtension.class.getResource("res/img/logo.gif"))));
        this.addSeparator();
        this.add(this.lightLabelTestCases);
        this.addSeparator();
        this.add(this.cellTestednessBar);
        this.addSeparator();
        this.add(this.spreadsheetTestednessBar);
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Extensible<Cell> extensible;
        Cell cell = selectionEvent.getCell();
        if (cell != null) {
            extensible = (TestableCell)cell.getExtension("Test Cases");
            ((TestableCell)extensible).addTestableCellListener(this);
            this.testCasesChanged((TestableCell)extensible);
        } else {
            this.setTestCaseLamp(2);
            this.setTestCaseProgressBar(0.0);
        }
        if (selectionEvent.getPreviousCell() != null) {
            ((TestableCell)selectionEvent.getPreviousCell().getExtension("Test Cases")).removeTestableCellListener(this);
        }
        if (selectionEvent.getSpreadsheet() != null) {
            extensible = (TestableSpreadsheet)selectionEvent.getSpreadsheet().getExtension("Test Cases");
            this.setSpreadsheetTestednessBar(((TestableSpreadsheet)extensible).getTestedness());
        } else {
            this.setSpreadsheetTestednessBar(0.0);
        }
    }

    public void testCasesChanged(TestableCell testableCell) {
        double d = testableCell.getTestedness();
        this.setTestCaseProgressBar(d);
        if (testableCell.hasTestError()) {
            this.setTestCaseLamp(3);
        } else if (d < 1.0) {
            this.setTestCaseLamp(2);
        } else {
            this.setTestCaseLamp(1);
        }
    }

    public void testCaseParametersChanged(TestableCell testableCell) {
    }

    private void setTestCaseLamp(int n) {
        switch (n) {
            case 1: {
                this.lightLabelTestCases.setIcon(this.greenIcon);
                break;
            }
            case 2: {
                this.lightLabelTestCases.setIcon(this.yellowIcon);
                break;
            }
            case 3: {
                this.lightLabelTestCases.setIcon(this.redIcon);
                break;
            }
            default: {
                this.lightLabelTestCases.setIcon(this.yellowIcon);
            }
        }
    }

    private void setTestCaseProgressBar(double d) {
        this.cellTestednessBar.setValue((int)(d * 100.0));
        this.cellTestednessBar.setString((int)(d * 100.0) + "%");
    }

    private void setSpreadsheetTestednessBar(double d) {
        this.spreadsheetTestednessBar.setValue((int)(d * 100.0));
        this.spreadsheetTestednessBar.setString((int)(d * 100.0) + "%");
    }
}

