/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui;

import csheets.CleanSheets;
import csheets.core.Workbook;
import csheets.ui.FileChooser;
import csheets.ui.MenuBar;
import csheets.ui.StandardToolBar;
import csheets.ui.WindowClosingHandler;
import csheets.ui.ctrl.AboutAction;
import csheets.ui.ctrl.ActionManager;
import csheets.ui.ctrl.AddSpreadsheetAction;
import csheets.ui.ctrl.ClearAction;
import csheets.ui.ctrl.CloseAction;
import csheets.ui.ctrl.CloseAllAction;
import csheets.ui.ctrl.CopyAction;
import csheets.ui.ctrl.CutAction;
import csheets.ui.ctrl.ExitAction;
import csheets.ui.ctrl.HelpAction;
import csheets.ui.ctrl.InsertColumnAction;
import csheets.ui.ctrl.InsertRowAction;
import csheets.ui.ctrl.LicenseAction;
import csheets.ui.ctrl.NewAction;
import csheets.ui.ctrl.OpenAction;
import csheets.ui.ctrl.PasteAction;
import csheets.ui.ctrl.PreferencesAction;
import csheets.ui.ctrl.PrintAction;
import csheets.ui.ctrl.RedoAction;
import csheets.ui.ctrl.RemoveColumnAction;
import csheets.ui.ctrl.RemoveRowAction;
import csheets.ui.ctrl.RemoveSpreadsheetAction;
import csheets.ui.ctrl.RenameSpreadsheetAction;
import csheets.ui.ctrl.SaveAction;
import csheets.ui.ctrl.SaveAsAction;
import csheets.ui.ctrl.SearchAction;
import csheets.ui.ctrl.SelectAllAction;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.SortAction;
import csheets.ui.ctrl.UIController;
import csheets.ui.ctrl.UndoAction;
import csheets.ui.ext.UIExtension;
import csheets.ui.sheet.AddressBox;
import csheets.ui.sheet.CellEditor;
import csheets.ui.sheet.WorkbookPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class Frame
extends JFrame
implements SelectionListener {
    public static final String TITLE = "CleanSheets";
    private CleanSheets app;

    public Frame(CleanSheets cleanSheets) {
        Object object;
        this.app = cleanSheets;
        UIController uIController = new UIController(cleanSheets);
        FileChooser fileChooser = null;
        try {
            fileChooser = new FileChooser(this, cleanSheets.getUserProperties());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        ActionManager actionManager = new ActionManager(cleanSheets, uIController, fileChooser);
        actionManager.registerAction("new", new NewAction(cleanSheets));
        actionManager.registerAction("open", new OpenAction(cleanSheets, uIController, fileChooser));
        actionManager.registerAction("close", new CloseAction(cleanSheets, uIController, fileChooser));
        actionManager.registerAction("closeall", new CloseAllAction(cleanSheets, uIController, fileChooser));
        actionManager.registerAction("save", new SaveAction(cleanSheets, uIController, fileChooser));
        actionManager.registerAction("saveas", new SaveAsAction(cleanSheets, uIController, fileChooser));
        actionManager.registerAction("exit", new ExitAction(cleanSheets, uIController, fileChooser));
        actionManager.registerAction("print", new PrintAction());
        actionManager.registerAction("undo", new UndoAction());
        actionManager.registerAction("redo", new RedoAction());
        actionManager.registerAction("cut", new CutAction());
        actionManager.registerAction("copy", new CopyAction());
        actionManager.registerAction("paste", new PasteAction());
        actionManager.registerAction("clear", new ClearAction());
        actionManager.registerAction("selectall", new SelectAllAction());
        actionManager.registerAction("sort", new SortAction());
        actionManager.registerAction("search", new SearchAction());
        actionManager.registerAction("prefs", new PreferencesAction());
        actionManager.registerAction("addsheet", new AddSpreadsheetAction(uIController));
        actionManager.registerAction("removesheet", new RemoveSpreadsheetAction(uIController));
        actionManager.registerAction("renamesheet", new RenameSpreadsheetAction(uIController));
        actionManager.registerAction("insertcolumn", new InsertColumnAction());
        actionManager.registerAction("removecolumn", new RemoveColumnAction());
        actionManager.registerAction("insertrow", new InsertRowAction());
        actionManager.registerAction("removerow", new RemoveRowAction());
        actionManager.registerAction("help", new HelpAction());
        actionManager.registerAction("license", new LicenseAction());
        actionManager.registerAction("about", new AboutAction());
        WorkbookPane workbookPane = new WorkbookPane(uIController, actionManager);
        CellEditor cellEditor = new CellEditor(uIController);
        AddressBox addressBox = new AddressBox(uIController);
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.add(new StandardToolBar(actionManager));
        for (UIExtension object22 : uIController.getExtensions()) {
            object = object22.getToolBar();
            if (object == null) continue;
            jPanel.add((Component)object);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)addressBox, "West");
        jPanel2.add((Component)cellEditor, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        JTabbedPane jTabbedPane = new JTabbedPane(1, 0);
        jTabbedPane.setPreferredSize(new Dimension(170, 480));
        Font font = jTabbedPane.getFont();
        jTabbedPane.setFont(new Font(font.getFamily(), 0, font.getSize() - 1));
        for (UIExtension uIExtension : uIController.getExtensions()) {
            JComponent jComponent = uIExtension.getSideBar();
            if (jComponent == null) continue;
            jTabbedPane.insertTab(uIExtension.getExtension().getName(), uIExtension.getIcon(), jComponent, null, jTabbedPane.getTabCount());
        }
        workbookPane.setMinimumSize(new Dimension(300, 100));
        jTabbedPane.setMinimumSize(new Dimension(140, 100));
        object = new JSplitPane(1, workbookPane, jTabbedPane);
        ((JSplitPane)object).setOneTouchExpandable(true);
        ((JSplitPane)object).setResizeWeight(1.0);
        Container container = this.getContentPane();
        container.setPreferredSize(new Dimension(640, 480));
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel3, "North");
        container.add((Component)object, "Center");
        this.setJMenuBar(new MenuBar(cleanSheets, actionManager, uIController));
        uIController.addSelectionListener(this);
        this.addWindowListener(new WindowClosingHandler(this, actionManager.getAction("exit")));
        this.setTitle(TITLE);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(CleanSheets.class.getResource("res/img/sheet.gif")));
        this.pack();
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Workbook workbook = selectionEvent.getWorkbook();
        if (workbook != null) {
            this.setVisible(true);
            if (this.app.isWorkbookStored(workbook)) {
                this.setTitle("CleanSheets - " + this.app.getFile(workbook).getName());
            } else {
                this.setTitle("CleanSheets - Untitled");
            }
        } else {
            this.setTitle(TITLE);
        }
    }

    public static class Creator
    implements Runnable {
        private Frame frame;
        private CleanSheets app;

        public Creator(CleanSheets cleanSheets) {
            this.app = cleanSheets;
        }

        public Frame createAndWait() {
            try {
                EventQueue.invokeAndWait(this);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return null;
            }
            return this.frame;
        }

        public void createLater() {
            EventQueue.invokeLater(this);
        }

        public void run() {
            this.frame = new Frame(this.app);
        }
    }
}

