/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.ctrl;

import csheets.CleanSheets;
import csheets.SpreadsheetAppEvent;
import csheets.SpreadsheetAppListener;
import csheets.ui.FileChooser;
import csheets.ui.ctrl.BaseAction;
import csheets.ui.ctrl.EditEvent;
import csheets.ui.ctrl.EditListener;
import csheets.ui.ctrl.UIController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionManager {
    private Map<String, BaseAction> actions = new HashMap<String, BaseAction>();
    private List<BaseAction> modificationActions = new ArrayList<BaseAction>();
    private List<BaseAction> fileActions = new ArrayList<BaseAction>();

    public ActionManager(CleanSheets cleanSheets, UIController uIController, FileChooser fileChooser) {
        ActionEnabler actionEnabler = new ActionEnabler();
        cleanSheets.addSpreadsheetAppListener(actionEnabler);
        uIController.addEditListener(actionEnabler);
    }

    public BaseAction getAction(String string) {
        return this.actions.get(string);
    }

    public void registerAction(String string, BaseAction baseAction) {
        this.actions.put(string, baseAction);
        if (baseAction.requiresModification()) {
            this.modificationActions.add(baseAction);
        }
        if (baseAction.requiresFile()) {
            this.fileActions.add(baseAction);
        }
    }

    public class ActionEnabler
    implements SpreadsheetAppListener,
    EditListener {
        public void workbookCreated(SpreadsheetAppEvent spreadsheetAppEvent) {
            for (BaseAction baseAction : ActionManager.this.modificationActions) {
                baseAction.setEnabled(false);
            }
            for (BaseAction baseAction : ActionManager.this.fileActions) {
                baseAction.setEnabled(false);
            }
        }

        public void workbookLoaded(SpreadsheetAppEvent spreadsheetAppEvent) {
            for (BaseAction baseAction : ActionManager.this.modificationActions) {
                baseAction.setEnabled(false);
            }
            for (BaseAction baseAction : ActionManager.this.fileActions) {
                baseAction.setEnabled(true);
            }
        }

        public void workbookUnloaded(SpreadsheetAppEvent spreadsheetAppEvent) {
        }

        public void workbookSaved(SpreadsheetAppEvent spreadsheetAppEvent) {
            for (BaseAction baseAction : ActionManager.this.modificationActions) {
                baseAction.setEnabled(false);
            }
            for (BaseAction baseAction : ActionManager.this.fileActions) {
                baseAction.setEnabled(true);
            }
        }

        public void workbookModified(EditEvent editEvent) {
            for (BaseAction baseAction : ActionManager.this.modificationActions) {
                baseAction.setEnabled(true);
            }
        }
    }
}

