/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.grid;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class HeaderRenderer
extends DefaultTableCellRenderer {
    private int axis;

    public HeaderRenderer(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Axis must be either SwingConstants.HORIZONTAL or SwingConstants.VERTICAL");
        }
        this.axis = n;
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installProperty(this, "opaque", Boolean.TRUE);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.axis == 0) {
            bl = Arrays.binarySearch(jTable.getSelectedColumns(), n2) >= 0;
        }
        this.setBackground(UIManager.getColor("TableHeader." + (bl ? "selectionBackground" : "background")));
        this.setForeground(UIManager.getColor("TableHeader." + (bl ? "selectionForeground" : "foreground")));
        if (this.axis == 1) {
            this.setText(Integer.toString(n + 1));
        } else {
            int n3 = n2;
            String string = "";
            while (n3 >= 0) {
                string = (char)((char)(n3 % 26) + 65) + string;
                n3 = n3 / 26 - 1;
            }
            this.setText(string);
        }
        return this;
    }
}

