/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.sheet;

import csheets.core.Cell;
import csheets.core.formula.compiler.FormulaCompilationException;
import csheets.ui.sheet.CellTransferable;
import csheets.ui.sheet.SpreadsheetTable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class CellTransferHandler
extends TransferHandler {
    private SpreadsheetTable sourceTable;
    private int exportAction = -1;

    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof SpreadsheetTable) {
            this.sourceTable = (SpreadsheetTable)jComponent;
            return new CellTransferable(this.sourceTable.getSelectedCells());
        }
        return null;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            SpreadsheetTable spreadsheetTable = (SpreadsheetTable)jComponent;
            int n = spreadsheetTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            int n2 = spreadsheetTable.getSelectionModel().getAnchorSelectionIndex();
            if (transferable.isDataFlavorSupported(CellTransferable.LOCAL_CELL_FLAVOR)) {
                Cell[][] cellArray = null;
                try {
                    cellArray = (Cell[][])transferable.getTransferData(CellTransferable.LOCAL_CELL_FLAVOR);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
                for (int i = 0; i < cellArray.length; ++i) {
                    for (int j = 0; j < cellArray[i].length; ++j) {
                        Cell cell = cellArray[i][j];
                        Cell cell2 = spreadsheetTable.getSpreadsheet().getCell(n + j, n2 + i);
                        if (this.exportAction == 1) {
                            cell2.copyFrom(cell);
                            continue;
                        }
                        if (this.exportAction != 2 && this.exportAction != -1) continue;
                        cell2.moveFrom(cell);
                    }
                }
                return true;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = null;
                try {
                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
                if (string != null) {
                    String[] stringArray = string.split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2 = stringArray[i].split("\t");
                        for (int j = 0; j < stringArray2.length; ++j) {
                            Cell cell = spreadsheetTable.getSpreadsheet().getCell(n + j, n2 + i);
                            try {
                                cell.setContent(stringArray2[j]);
                                continue;
                            }
                            catch (FormulaCompilationException formulaCompilationException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.equals(CellTransferable.LOCAL_CELL_FLAVOR) && !dataFlavor.equals(DataFlavor.stringFlavor)) continue;
            bl = true;
            break;
        }
        return jComponent instanceof SpreadsheetTable && bl;
    }

    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.exportAction = n;
    }
}

