/*
 * Decompiled with CFR 0.152.
 */
import com.eteks.parser.CompilationException;
import com.eteks.parser.CompiledFunction;
import com.eteks.parser.FunctionParser;
import com.eteks.tools.awt.Curve2DDisplay;
import com.eteks.tools.awt.Curve3DDisplay;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JeksDisplay
extends Applet {
    private TextField functionField;
    private TextField parameterField;
    private Label resultLabel;
    private TextField minimumX;
    private TextField maximumX;
    private CheckboxGroup displayModeGroup;
    private Checkbox ligthingCheckbox;
    private Checkbox meshCheckbox;
    private Checkbox allMeshCheckbox;
    private Button defaultButton;
    private Panel containerDisplayParam;
    private Panel containerParam3D;
    private Component curveDisplay;
    private Curve2DDisplay displayCanvas2D = new Curve2DDisplay();
    private Curve3DDisplay displayCanvas3D = new Curve3DDisplay();
    private FunctionParser parser = new FunctionParser();
    private CompiledFunction lastFunction;
    private int meshSize = 20;

    public void init() {
        this.setLayout(new BorderLayout(4, 4));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Function :");
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.functionField = new TextField();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.functionField, gridBagConstraints);
        panel.add(this.functionField);
        label = new Label("Compute :");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.parameterField = new TextField();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagLayout.setConstraints(this.parameterField, gridBagConstraints);
        panel.add(this.parameterField);
        this.resultLabel = new Label();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.8;
        gridBagLayout.setConstraints(this.resultLabel, gridBagConstraints);
        panel.add(this.resultLabel);
        this.add("North", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(4, 1, 1, 1));
        panel2.add(new Label("Minimum :"));
        this.minimumX = new TextField("-2");
        panel2.add(this.minimumX);
        panel2.add(new Label("Maximum :"));
        this.maximumX = new TextField("2");
        panel2.add(this.maximumX);
        this.containerParam3D = new Panel();
        this.containerParam3D.setLayout(new GridLayout(5, 1, 1, 1));
        this.containerParam3D.add(new Label("Mesh mode :"));
        this.displayModeGroup = new CheckboxGroup();
        this.allMeshCheckbox = new Checkbox("Complete mesh", this.displayModeGroup, true);
        this.containerParam3D.add(this.allMeshCheckbox);
        this.meshCheckbox = new Checkbox("White mesh", this.displayModeGroup, false);
        this.containerParam3D.add(this.meshCheckbox);
        this.ligthingCheckbox = new Checkbox("Lighted mesh", this.displayModeGroup, false);
        this.containerParam3D.add(this.ligthingCheckbox);
        this.defaultButton = new Button("Default position");
        this.containerParam3D.add(this.defaultButton);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        this.containerDisplayParam = new Panel();
        this.containerDisplayParam.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        gridBagLayout.setConstraints(this.containerParam3D, gridBagConstraints);
        this.containerDisplayParam.add(panel2);
        this.add("East", this.containerDisplayParam);
        String string = this.getParameter("meshSize");
        if (string != null) {
            this.meshSize = Integer.parseInt(string);
        }
        if ((string = this.getParameter("defaultFunction")) != null) {
            ((TextComponent)this.functionField).setText(string);
            this.postEvent(new Event(this.functionField, 1001, string));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean action(Event var1_1, Object var2_2) {
        block26: {
            if (var1_1.target == this.functionField) {
                try {
                    var3_3 = this.parser.compileFunction(this.functionField.getText());
                    if (var3_3.getParameterCount() == 1 || var3_3.getParameterCount() == 2) {
                        this.resultLabel.setText("Compilation of " + var3_3.getName() + " OK.");
                        this.displayFunction(var3_3);
                    } else {
                        this.resultLabel.setText("Error : Can display only functions with 1 or 2 parameters.");
                    }
                    break block26;
                }
                catch (CompilationException var3_4) {
                    var4_8 = new StringBuffer("^");
                    var5_10 = 0;
                    ** while (var5_10 < var3_4.getCharacterIndex())
                }
lbl-1000:
                // 1 sources

                {
                    var4_8.insert(0, ' ');
                    ++var5_10;
                    continue;
                }
lbl18:
                // 1 sources

                this.resultLabel.setText("Error : " + var3_4.getMessage() + ".");
            } else if (this.lastFunction != null) {
                if (var1_1.target == this.minimumX || var1_1.target == this.maximumX) {
                    this.displayFunction(this.lastFunction);
                } else if (var1_1.target == this.parameterField) {
                    try {
                        var3_5 = new StringTokenizer(this.parameterField.getText(), " (,)");
                        if (!this.lastFunction.getName().equals(var3_5.nextToken())) {
                            throw new IllegalArgumentException("Unkonwn function");
                        }
                        var4_9 = new double[this.lastFunction.getParameterCount()];
                        var5_11 = 0;
                        while (var5_11 < this.lastFunction.getParameterCount()) {
                            var4_9[var5_11] = Double.valueOf(var3_5.nextToken());
                            ++var5_11;
                        }
                        this.resultLabel.setText("Result of " + this.parameterField.getText() + " = " + this.lastFunction.computeFunction(var4_9));
                    }
                    catch (NumberFormatException var3_6) {
                        this.resultLabel.setText("Error : " + var3_6 + ".");
                    }
                    catch (IllegalArgumentException var3_7) {
                        this.resultLabel.setText("Error : " + var3_7 + ".");
                    }
                    catch (NoSuchElementException v0) {
                        this.resultLabel.setText("Error : Missing function or parameters");
                    }
                } else if (this.lastFunction.getParameterCount() == 2) {
                    if (var1_1.target == this.defaultButton) {
                        this.displayCanvas3D.setDefaultPosition();
                    } else if (var1_1.target == this.ligthingCheckbox) {
                        this.displayCanvas3D.setDisplayMode(0);
                    } else if (var1_1.target == this.meshCheckbox) {
                        this.displayCanvas3D.setDisplayMode(1);
                    } else if (var1_1.target == this.allMeshCheckbox) {
                        this.displayCanvas3D.setDisplayMode(2);
                    }
                }
            }
        }
        return true;
    }

    private void displayFunction(CompiledFunction compiledFunction) {
        this.lastFunction = compiledFunction;
        if (this.curveDisplay != null) {
            this.remove(this.curveDisplay);
        }
        if (this.lastFunction.getParameterCount() == 1) {
            this.curveDisplay = this.displayCanvas2D;
            this.containerDisplayParam.remove(this.containerParam3D);
            this.displayCanvas2D.computeCurve(this.lastFunction, Double.valueOf(this.minimumX.getText()), Double.valueOf(this.maximumX.getText()));
        } else {
            this.curveDisplay = this.displayCanvas3D;
            this.containerDisplayParam.add(this.containerParam3D);
            this.displayCanvas3D.computeCurve(this.lastFunction, Double.valueOf(this.minimumX.getText()), Double.valueOf(this.maximumX.getText()), this.meshSize);
        }
        this.add("Center", this.curveDisplay);
        this.validate();
    }
}

