/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.DoubleInterpreter;
import com.eteks.parser.Syntax;

public class WrapperInterpreter
extends DoubleInterpreter {
    private boolean concatenationSupported;
    private boolean integerDivisionSupported;
    private boolean characterOperationSupported;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public WrapperInterpreter() {
        this(true, true, true);
    }

    public WrapperInterpreter(boolean bl) {
        this(bl, true, true);
    }

    public WrapperInterpreter(boolean bl, boolean bl2) {
        this(bl, true, true);
    }

    public WrapperInterpreter(boolean bl, boolean bl2, boolean bl3) {
        this.concatenationSupported = bl;
        this.integerDivisionSupported = bl2;
        this.characterOperationSupported = bl3;
    }

    public Object getLiteralValue(Object object) {
        if (object instanceof Number || object instanceof String || object instanceof Character) {
            return object;
        }
        throw new IllegalArgumentException("Literal " + object + " not an instance of Number, String or Character");
    }

    public Object getParameterValue(Object object) {
        if (object instanceof Number || object instanceof String || object instanceof Character || object instanceof Boolean) {
            return object;
        }
        throw new IllegalArgumentException("Parameter " + object + " not an instance of Number, String, Character or Boolean");
    }

    public Object getConstantValue(Object object) {
        if (Syntax.CONSTANT_TRUE.equals(object)) {
            return Boolean.TRUE;
        }
        if (Syntax.CONSTANT_FALSE.equals(object)) {
            return Boolean.FALSE;
        }
        return super.getConstantValue(object);
    }

    public Object getUnaryOperatorValue(Object object, Object object2) {
        if (object.equals(Syntax.OPERATOR_OPPOSITE)) {
            if (object2 instanceof Integer || object2 instanceof Long) {
                return new Long(-((Number)object2).longValue());
            }
            if (object2 instanceof Float || object2 instanceof Number) {
                return new Double(-((Number)object2).doubleValue());
            }
            if (this.characterOperationSupported && object2 instanceof Character) {
                return new Long(-((Character)object2).charValue());
            }
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Number" + (this.characterOperationSupported ? " or Character" : ""));
        }
        if (object.equals(Syntax.OPERATOR_POSITIVE)) {
            if (object2 instanceof Number) {
                return object2;
            }
            if (this.characterOperationSupported && object2 instanceof Character) {
                return new Long(((Character)object2).charValue());
            }
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Number" + (this.characterOperationSupported ? " or Character" : ""));
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_NOT)) {
            if (!(object2 instanceof Boolean)) {
                throw new IllegalArgumentException("Operand " + object2 + " not an instance of Boolean");
            }
            return (Boolean)object2 != false ? Boolean.FALSE : Boolean.TRUE;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_NOT)) {
            if (object2 instanceof Integer || object2 instanceof Long) {
                return new Long(((Number)object2).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (this.characterOperationSupported && object2 instanceof Character) {
                return new Long(~((Character)object2).charValue());
            }
            throw new IllegalArgumentException("Operand" + object2 + " not an instance of Integer or Long");
        }
        throw new IllegalArgumentException("Unary operator key " + object + " not implemented");
    }

    public Object getBinaryOperatorValue(Object object, Object object2, Object object3) {
        if (object.equals(Syntax.OPERATOR_LOGICAL_OR)) {
            return this.isTrue(object2) || this.isTrue(object3) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_XOR)) {
            boolean bl = this.isTrue(object2);
            boolean bl2 = this.isTrue(object3);
            return !bl && bl2 || bl && !bl2 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_AND)) {
            return this.isTrue(object2) && this.isTrue(object3) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_ADD) && this.concatenationSupported) {
            if (object2 instanceof String) {
                return String.valueOf((String)object2) + object3;
            }
            if (object3 instanceof String) {
                return String.valueOf(String.valueOf(object2)) + (String)object3;
            }
        }
        if (this.characterOperationSupported) {
            if (object2 instanceof Character) {
                object2 = new Integer(((Character)object2).charValue());
            }
            if (object3 instanceof Character) {
                object3 = new Integer(((Character)object3).charValue());
            }
        }
        if (object.equals(Syntax.OPERATOR_ADD)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            if ((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"))).equals(this.getResultClass(object2, object3))) {
                return new Long(((Number)object2).longValue() + ((Number)object3).longValue());
            }
            return new Double(((Number)object2).doubleValue() + ((Number)object3).doubleValue());
        }
        if (object.equals(Syntax.OPERATOR_SUBSTRACT)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            if ((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"))).equals(this.getResultClass(object2, object3))) {
                return new Long(((Number)object2).longValue() - ((Number)object3).longValue());
            }
            return new Double(((Number)object2).doubleValue() - ((Number)object3).doubleValue());
        }
        if (object.equals(Syntax.OPERATOR_MULTIPLY)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            if ((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"))).equals(this.getResultClass(object2, object3))) {
                return new Long(((Number)object2).longValue() * ((Number)object3).longValue());
            }
            return new Double(((Number)object2).doubleValue() * ((Number)object3).doubleValue());
        }
        if (object.equals(Syntax.OPERATOR_DIVIDE)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            if ((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"))).equals(this.getResultClass(object2, object3)) && this.integerDivisionSupported) {
                return new Long(((Number)object2).longValue() / ((Number)object3).longValue());
            }
            return new Double(((Number)object2).doubleValue() / ((Number)object3).doubleValue());
        }
        if (object.equals(Syntax.OPERATOR_POWER)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            if ((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"))).equals(this.getResultClass(object2, object3))) {
                return new Long((long)Math.pow(((Number)object2).longValue(), ((Number)object3).longValue()));
            }
            return new Double(Math.pow(((Number)object2).doubleValue(), ((Number)object3).doubleValue()));
        }
        if (object.equals(Syntax.OPERATOR_MODULO)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            if ((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"))).equals(this.getResultClass(object2, object3))) {
                long l = ((Number)object2).longValue();
                long l2 = ((Number)object3).longValue();
                long l3 = l - l2 * (l / l2);
                if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
                    l3 += l2;
                }
                return new Long(l3);
            }
            double d = ((Number)object2).doubleValue();
            double d2 = ((Number)object3).doubleValue();
            double d3 = d - d2 * (double)((long)(d / d2));
            if (d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0) {
                d3 += d2;
            }
            return new Double(d3);
        }
        if (object.equals(Syntax.OPERATOR_REMAINDER)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            if ((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"))).equals(this.getResultClass(object2, object3))) {
                return new Long(((Number)object2).longValue() % ((Number)object3).longValue());
            }
            return new Double(((Number)object2).doubleValue() % ((Number)object3).doubleValue());
        }
        if (object.equals(Syntax.OPERATOR_EQUAL)) {
            this.checkOperandsInstanceOfNumberOrBoolean(object2, object3);
            if (object2 instanceof Number) {
                return ((Number)object2).doubleValue() == ((Number)object3).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            return object2.equals(object3) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_DIFFERENT)) {
            this.checkOperandsInstanceOfNumberOrBoolean(object2, object3);
            if (object2 instanceof Number) {
                return ((Number)object2).doubleValue() == ((Number)object3).doubleValue() ? Boolean.FALSE : Boolean.TRUE;
            }
            return object2.equals(object3) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_OR)) {
            this.checkOperandsInstanceOfIntegerLongOrBoolean(object2, object3);
            if (object2 instanceof Number) {
                return new Long(((Number)object2).longValue() | ((Number)object3).longValue());
            }
            return (Boolean)object2 | (Boolean)object3 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_XOR)) {
            this.checkOperandsInstanceOfIntegerLongOrBoolean(object2, object3);
            if (object2 instanceof Number) {
                return new Long(((Number)object2).longValue() ^ ((Number)object3).longValue());
            }
            return (Boolean)object2 ^ (Boolean)object3 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_AND)) {
            this.checkOperandsInstanceOfIntegerLongOrBoolean(object2, object3);
            if (object2 instanceof Number) {
                return new Long(((Number)object2).longValue() & ((Number)object3).longValue());
            }
            return (Boolean)object2 & (Boolean)object3 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_LEFT)) {
            this.checkOperandsInstanceOfIntegerOrLong(object2, object3);
            return new Long(((Number)object2).longValue() << (int)((Number)object3).longValue());
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_RIGHT)) {
            this.checkOperandsInstanceOfIntegerOrLong(object2, object3);
            return new Long(((Number)object2).longValue() >> (int)((Number)object3).longValue());
        }
        if (object.equals(Syntax.OPERATOR_SHIFT_RIGHT_0)) {
            this.checkOperandsInstanceOfIntegerOrLong(object2, object3);
            return new Long(((Number)object2).longValue() >>> (int)((Number)object3).longValue());
        }
        if (object.equals(Syntax.OPERATOR_GREATER_OR_EQUAL)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            return ((Number)object2).doubleValue() >= ((Number)object3).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_LESS_OR_EQUAL)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            return ((Number)object2).doubleValue() <= ((Number)object3).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_GREATER)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            return ((Number)object2).doubleValue() > ((Number)object3).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals(Syntax.OPERATOR_LESS)) {
            this.checkOperandsInstanceOfNumber(object2, object3);
            return ((Number)object2).doubleValue() < ((Number)object3).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalArgumentException("Binary operator key " + object + " not implemented");
    }

    private void checkOperandsInstanceOfNumberOrBoolean(Object object, Object object2) {
        if (!(object instanceof Number) && !(object instanceof Boolean)) {
            throw new IllegalArgumentException("Operand " + object + " not an instance of Number" + (this.characterOperationSupported ? ", Character" : "") + " or Boolean");
        }
        if (!(object2 instanceof Number) && !(object2 instanceof Boolean)) {
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Number" + (this.characterOperationSupported ? ", Character" : "") + " or Boolean");
        }
        if (!(object instanceof Number && object2 instanceof Number || object instanceof Boolean && object2 instanceof Boolean)) {
            throw new IllegalArgumentException("Operands " + object + " and " + object2 + " must be of compatible type");
        }
    }

    private void checkOperandsInstanceOfIntegerLongOrBoolean(Object object, Object object2) {
        if (!(object instanceof Integer || object instanceof Long || object instanceof Boolean)) {
            throw new IllegalArgumentException("Operand " + object + " not an instance of Integer, Long" + (this.characterOperationSupported ? ", Character" : "") + " or Boolean");
        }
        if (!(object instanceof Integer || object instanceof Long || object2 instanceof Boolean)) {
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Integer, Long" + (this.characterOperationSupported ? ", Character" : "") + " or Boolean");
        }
        if (!(object instanceof Number && object2 instanceof Number || object instanceof Boolean && object2 instanceof Boolean)) {
            throw new IllegalArgumentException("Operands " + object + " and " + object2 + " must be of compatible type");
        }
    }

    private void checkOperandsInstanceOfIntegerOrLong(Object object, Object object2) {
        if (!(object instanceof Integer) && !(object instanceof Long)) {
            throw new IllegalArgumentException("Operand " + object + " not an instance of Integer" + (this.characterOperationSupported ? ", Character" : "") + " or Long");
        }
        if (!(object2 instanceof Integer) && !(object2 instanceof Long)) {
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Integer" + (this.characterOperationSupported ? ", Character" : "") + " or Long");
        }
    }

    private void checkOperandsInstanceOfNumber(Object object, Object object2) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Operand " + object + " not an instance of Number");
        }
        if (!(object2 instanceof Number)) {
            throw new IllegalArgumentException("Operand " + object2 + " not an instance of Number");
        }
    }

    private Class getResultClass(Object object, Object object2) {
        if ((object instanceof Integer || object instanceof Long) && (object2 instanceof Integer || object2 instanceof Long)) {
            return class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = WrapperInterpreter.class$("java.lang.Long"));
        }
        return class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = WrapperInterpreter.class$("java.lang.Double"));
    }

    public Object getCommonFunctionValue(Object object, Object object2) {
        if (object.equals(Syntax.FUNCTION_NOT)) {
            return this.isTrue(object2) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (this.characterOperationSupported && object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        if (object.equals(Syntax.FUNCTION_INTEGER)) {
            if (!(object2 instanceof Number)) {
                throw new IllegalArgumentException("Parameter " + object2 + " not an instance of Number");
            }
            if (object2 instanceof Long) {
                return object2;
            }
            return new Long(((Number)object2).longValue());
        }
        if (object.equals(Syntax.FUNCTION_FLOOR)) {
            if (!(object2 instanceof Number)) {
                throw new IllegalArgumentException("Parameter " + object2 + " not an instance of Number");
            }
            if (object2 instanceof Long) {
                return object2;
            }
            if (object2 instanceof Integer) {
                return new Long(((Integer)object2).longValue());
            }
            return new Double(Math.floor(((Number)object2).doubleValue()));
        }
        if (object.equals(Syntax.FUNCTION_CEIL)) {
            if (!(object2 instanceof Number)) {
                throw new IllegalArgumentException("Parameter " + object2 + " not an instance of Number");
            }
            if (object2 instanceof Long) {
                return object2;
            }
            if (object2 instanceof Integer) {
                return new Long(((Integer)object2).longValue());
            }
            return new Double(Math.ceil(((Number)object2).doubleValue()));
        }
        if (object.equals(Syntax.FUNCTION_ROUND)) {
            if (!(object2 instanceof Number)) {
                throw new IllegalArgumentException("Parameter " + object2 + " not an instance of Number");
            }
            if (object2 instanceof Long) {
                return object2;
            }
            if (object2 instanceof Integer) {
                return new Long(((Integer)object2).longValue());
            }
            return new Double(Math.rint(((Number)object2).doubleValue()));
        }
        if (object.equals(Syntax.FUNCTION_ABS)) {
            if (!(object2 instanceof Number)) {
                throw new IllegalArgumentException("Parameter " + object2 + " not an instance of Number");
            }
            if (object2 instanceof Long || object2 instanceof Integer) {
                return new Long(Math.abs(((Number)object2).longValue()));
            }
            return new Double(Math.abs(((Number)object2).doubleValue()));
        }
        if (object.equals(Syntax.FUNCTION_OPPOSITE)) {
            if (!(object2 instanceof Number)) {
                throw new IllegalArgumentException("Parameter " + object2 + " not an instance of Number");
            }
            if (object2 instanceof Long || object2 instanceof Integer) {
                return new Long(-((Number)object2).longValue());
            }
            return new Double(-((Number)object2).doubleValue());
        }
        return super.getCommonFunctionValue(object, object2);
    }

    public boolean isTrue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalArgumentException("Parameter " + object + " not an instance of Boolean");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

