/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

final class Config {
    private HashMap map = new HashMap();
    private File file;
    private boolean modified = false;

    Config(String string) {
        this.file = new File(string);
    }

    public void load() {
        Debug.println("Loading configuration file...");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = this.getPair(string);
                if (stringArray == null || stringArray[0] == null || stringArray[0].length() == 0) continue;
                this.map.put(stringArray[0], stringArray[1]);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.err.println("error parsing config file: " + exception);
        }
        this.modified = false;
    }

    public void save() {
        if (!this.modified) {
            return;
        }
        Debug.println("Saving configuration file...");
        String string = this.file + ".tmp";
        File file = new File(string);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = this.getPair(string2.toUpperCase());
                if (stringArray != null && stringArray[0] != null && this.map.get(stringArray[0]) != null) {
                    printWriter.println(stringArray[0] + '=' + this.map.get(stringArray[0]));
                    continue;
                }
                printWriter.println(string2);
            }
            bufferedReader.close();
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("io error saving config file: " + iOException);
            return;
        }
        catch (Exception exception) {
            System.err.println("error saving config file: " + exception);
            return;
        }
        this.file.delete();
        file.renameTo(this.file);
        this.modified = false;
    }

    private String[] getPair(String string) {
        int n = string.indexOf(61);
        if (n < 0) {
            return null;
        }
        if (string.startsWith("#") || string.startsWith(";")) {
            return null;
        }
        String[] stringArray = new String[]{string.substring(0, n).trim(), string.substring(n + 1).trim()};
        return stringArray;
    }

    public String get(String string) {
        return (String)this.map.get(string);
    }

    public int getInt(String string) {
        String string2 = (String)this.map.get(string);
        if (string2 == null) {
            return -1;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public boolean getBoolean(String string) {
        String string2 = (String)this.map.get(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals("TRUE");
    }

    public void set(String string, String string2) {
        this.modified = true;
        this.map.put(string, string2);
    }

    public void setInt(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    public void setBoolean(String string, boolean bl) {
        this.set(string, bl ? "TRUE" : "FALSE");
    }
}

