/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;

class FunctionListListener
implements ActionListener {
    JFrame frame;
    JTable table;
    private final ImageIcon helpIcon = SharpTools.getImageIcon("help32.gif");

    FunctionListListener(JFrame jFrame, JTable jTable) {
        this.frame = jFrame;
        this.table = jTable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        try {
            if (this.table.isEditing()) {
                int n = this.table.getEditingRow();
                int n2 = this.table.getEditingRow();
                JTextField jTextField = ((SharpCellEditor)this.table.getCellEditor(n, n2)).getTextField();
                if (!string.equals("Functions")) {
                    jTextField.replaceSelection(string + "()");
                    Function function = Formula.getFuncHandler(string);
                    if (function != null && function.requireParams()) {
                        jTextField.setCaretPosition(jTextField.getCaretPosition() - 1);
                    }
                } else {
                    this.showGeneralFunctionHelp();
                }
                jTextField.requestFocus();
            } else {
                Function function = Formula.getFuncHandler(string);
                if (function != null) {
                    String string2 = "<html><font size=2 color=black><b>" + function.getUsage() + "</b><p><p>" + function.getDescription() + "<p></font>";
                    SharpOptionPane.showMessageDialog(this.frame, string2, "Function", 1, this.helpIcon);
                } else {
                    this.showGeneralFunctionHelp();
                }
                this.table.requestFocus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jComboBox.setSelectedIndex(0);
    }

    private void showGeneralFunctionHelp() {
        String string = "<html><font size=2 color=black><b><font size=3>Functions</font></b><p><p>Functions are predefined formulas that perform calculations by<p>using specific values, called arguments, in a particular order,<p>or structure.<p><p><b>Arguments</b> Arguments can be numbers or cell references. A cell<p>reference can be a single cell or a range of cells.  A single cell can<p>use relative addressing (A1) or absolute addressing ($B$5).  A range<p>of cell is specified by a pair of diagonal cells (A1:C5, $A$1:$C$5).<p>Different functions may have different requirements on the number<p>or type of parameters.<p><p><b>Structure</b> The structure of a function begins with the function<p>name, followed by an opening parenthesis, the arguments for<p>the function separated by commas, and a closing parenthesis.<p>If the function starts a formula, type an equal sign (=) before<p>the function name.  As you are editing a formula that contains<p>a function, you can click on a function in this list to insert the<p>function name into the cell.<p><p><b>Examples:</b><p><p>=SUM(A10,B5:B10,50,37)<p>=AVERAGE($B$5:$B$10)/10</font>";
        SharpOptionPane.showMessageDialog(this.frame, string, "Function", 1, this.helpIcon);
    }
}

