/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

class SharpDialog
extends JDialog {
    public static final int CLOSED_OPTION = -1;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    private static final ImageIcon okIcon = SharpTools.getImageIcon("ok.gif");
    private static final ImageIcon cancelIcon = SharpTools.getImageIcon("cancel.gif");
    private static final ImageIcon noIcon = SharpTools.getImageIcon("no.gif");
    private final JButton okButton = new JButton(UIManager.get("OptionPane.okButtonText").toString(), okIcon);
    private final JButton cancelButton = new JButton(UIManager.get("OptionPane.cancelButtonText").toString(), cancelIcon);
    private final JButton yesButton = new JButton(UIManager.get("OptionPane.yesButtonText").toString(), okIcon);
    private final JButton noButton = new JButton(UIManager.get("OptionPane.noButtonText").toString(), noIcon);
    private final Object[] ok = new Object[]{this.okButton};
    private final Object[] yesno = new Object[]{this.yesButton, this.noButton};
    private final Object[] yesnocancel = new Object[]{this.yesButton, this.noButton, this.cancelButton};
    private final Object[] okcancel = new Object[]{this.okButton, this.cancelButton};
    private int choice = -1;

    SharpDialog(Dialog dialog) {
        super(dialog);
    }

    SharpDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    SharpDialog(Dialog dialog, String string) {
        super(dialog, string);
    }

    SharpDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    SharpDialog(Frame frame) {
        super(frame);
    }

    SharpDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    SharpDialog(Frame frame, String string) {
        super(frame, string);
    }

    SharpDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    protected JRootPane createRootPane() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane jRootPane = new JRootPane();
        jRootPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SharpDialog.this.onClose()) {
                    SharpDialog.this.choice = -1;
                    SharpDialog.this.setVisible(false);
                }
            }
        }, keyStroke, 2);
        return jRootPane;
    }

    protected void onOpen() {
    }

    protected boolean onClose() {
        return this.onCancel();
    }

    protected boolean onOK() {
        return true;
    }

    protected boolean onCancel() {
        return true;
    }

    protected boolean onYes() {
        return true;
    }

    protected boolean onNo() {
        return true;
    }

    protected void setOptionPane(Object object, int n, int n2, Icon icon) {
        this.setOptionPane(object, n, n2, icon, 0);
    }

    protected void setOptionPane(Object object, int n, int n2, Icon icon, int n3) {
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SharpDialog.this.onOpen();
            }

            public void windowClosing(WindowEvent windowEvent) {
                if (SharpDialog.this.onClose()) {
                    SharpDialog.this.choice = -1;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SharpDialog.this.onOK()) {
                    SharpDialog.this.choice = 0;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SharpDialog.this.onCancel()) {
                    SharpDialog.this.choice = 2;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.yesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SharpDialog.this.onYes()) {
                    SharpDialog.this.choice = 0;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.noButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SharpDialog.this.onNo()) {
                    SharpDialog.this.choice = 1;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.okButton.setMnemonic(79);
        this.cancelButton.setMnemonic(67);
        this.yesButton.setMnemonic(89);
        this.noButton.setMnemonic(78);
        Object[] objectArray = this.setButtons(n2);
        JOptionPane jOptionPane = new JOptionPane(object, n, n2, icon, objectArray, objectArray[n3]);
        this.setContentPane(jOptionPane);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private Object[] setButtons(int n) {
        Object[] objectArray;
        switch (n) {
            case 1: {
                objectArray = this.yesnocancel;
                break;
            }
            case 0: {
                objectArray = this.yesno;
                break;
            }
            case 2: {
                objectArray = this.okcancel;
                break;
            }
            default: {
                objectArray = this.ok;
            }
        }
        return objectArray;
    }

    public int getChoice() {
        return this.choice;
    }

    public boolean isCancelled() {
        return this.choice == 2 || this.choice == -1;
    }
}

