/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabPanel
extends JPanel {
    private Histogram owner;
    private SharpTableModel model;
    private JTabbedPane tab;
    private HistoPanel histo;
    private CellRange range;
    private Float startvalue;
    private Float endvalue;
    private Float bucketvalue;
    private Float xmin;
    private Float xmax;
    private Float ymin;
    private Float ymax;
    private Float xunit;
    private Float yunit;
    private boolean bypercentage = true;

    TabPanel(SharpTableModel sharpTableModel, CellRange cellRange, Histogram histogram, JTabbedPane jTabbedPane) {
        this.owner = histogram;
        this.model = sharpTableModel;
        this.tab = jTabbedPane;
        this.range = cellRange;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.histo = new HistoPanel();
        this.histo.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.histo, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel.setLayout(new FlowLayout(1, 10, 0));
        JButton jButton = new JButton("Remove", SharpTools.getImageIcon("no.gif"));
        jButton.setMnemonic(82);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabPanel.this.tab.remove(TabPanel.this.tab.getSelectedComponent());
                if (TabPanel.this.tab.getTabCount() == 0) {
                    TabPanel.this.owner.hide();
                }
            }
        });
        JButton jButton2 = new JButton("Options...", SharpTools.getImageIcon("options.gif"));
        jButton2.setMnemonic(79);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabPanel.this.getOptions(false);
            }
        });
        JButton jButton3 = new JButton("Update", SharpTools.getImageIcon("refresh.gif"));
        jButton3.setMnemonic(85);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabPanel.this.updateData();
                TabPanel.this.histo.paintImmediately(0, 0, TabPanel.this.histo.getWidth(), TabPanel.this.histo.getHeight());
            }
        });
        jPanel.add(jButton3);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    void getOptions(boolean bl) {
        HistoDialog histoDialog = new HistoDialog(this.owner);
        histoDialog.pack();
        histoDialog.setLocationRelativeTo(this.owner);
        histoDialog.setTitleField(this.tab.getTitleAt(this.tab.getSelectedIndex()));
        if (bl) {
            histoDialog.setCellRange(this.range);
            float[] fArray = TabPanel.getValueMinMax(this.model, this.range);
            int n = (int)fArray[0];
            int n2 = (int)fArray[1];
            this.startvalue = new Float(n);
            this.endvalue = new Float(n2);
            int n3 = 0;
            if (n2 > n) {
                n3 = (int)(Math.log(n2 - n) / Math.log(10.0));
            }
            if (n3 < 0) {
                --n3;
            }
            this.xunit = this.bucketvalue = new Float(Math.pow(10.0, n3));
            this.xmin = new Float(n);
            this.xmax = new Float(n2);
            this.ymin = new Float(0.0f);
            this.ymax = new Float(100.0f);
            this.yunit = new Float(10.0f);
        }
        histoDialog.setCellRange(this.range);
        histoDialog.setStartValue(this.startvalue);
        histoDialog.setEndValue(this.endvalue);
        histoDialog.setBucket(this.bucketvalue);
        histoDialog.setXMin(this.xmin);
        histoDialog.setXMax(this.xmax);
        histoDialog.setXUnit(this.xunit);
        histoDialog.setYMin(this.ymin);
        histoDialog.setYMax(this.ymax);
        histoDialog.setYUnit(this.yunit);
        histoDialog.setByPercentage(this.bypercentage);
        histoDialog.setVisible(true);
        if (!histoDialog.isCancelled()) {
            this.tab.setTitleAt(this.tab.getSelectedIndex(), histoDialog.getTitleField());
            this.range = histoDialog.getCellRange();
            this.startvalue = histoDialog.getStartValue();
            this.endvalue = histoDialog.getEndValue();
            this.bucketvalue = histoDialog.getBucket();
            this.xmin = histoDialog.getXMin();
            this.xmax = histoDialog.getXMax();
            this.ymin = histoDialog.getYMin();
            this.ymax = histoDialog.getYMax();
            this.xunit = histoDialog.getXUnit();
            this.yunit = histoDialog.getYUnit();
            this.bypercentage = histoDialog.getByPercentage();
            this.update();
        }
    }

    static float[] getValueMinMax(SharpTableModel sharpTableModel, CellRange cellRange) {
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        int n = cellRange.getStartRow();
        while (n <= cellRange.getEndRow()) {
            int n2 = cellRange.getStartCol();
            while (n2 <= cellRange.getEndCol()) {
                float f;
                try {
                    f = sharpTableModel.getNumericValueAt(n, n2).floatValue();
                }
                catch (ParserException parserException) {
                    f = 0.0f;
                }
                fArray[0] = Math.min(fArray[0], f);
                fArray[1] = Math.max(fArray[1], f);
                ++n2;
            }
            ++n;
        }
        return fArray;
    }

    public void update() {
        float f;
        float f2 = this.startvalue.floatValue();
        float f3 = this.endvalue.floatValue();
        float f4 = (f3 - f2) / (f = this.bucketvalue.floatValue());
        int n = (int)f4;
        if (n > n) {
            ++n;
        }
        float[] fArray = new float[n += 2];
        this.histo.setData(fArray);
        this.updateData();
        this.histo.setStartEndPoints(f2, f3, f);
        this.histo.setXYAxis(this.xmin.floatValue(), this.xmax.floatValue(), this.xunit.floatValue(), this.ymin.floatValue(), this.ymax.floatValue(), this.yunit.floatValue());
        this.histo.setByPercentage(this.bypercentage);
        this.histo.paintImmediately(0, 0, this.histo.getWidth(), this.histo.getHeight());
    }

    private void updateData() {
        int n;
        float f = this.startvalue.floatValue();
        float f2 = this.endvalue.floatValue();
        float f3 = this.bucketvalue.floatValue();
        float[] fArray = this.histo.getData();
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = 0.0f;
            ++n2;
        }
        int n3 = this.range.getStartRow();
        while (n3 <= this.range.getEndRow()) {
            n = this.range.getStartCol();
            while (n <= this.range.getEndCol()) {
                float f4 = 0.0f;
                try {
                    f4 = this.model.getNumericValueAt(n3, n).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (f4 < f) {
                    fArray[0] = fArray[0] + 1.0f;
                } else if (f4 > f2) {
                    int n4 = fArray.length - 1;
                    fArray[n4] = fArray[n4] + 1.0f;
                } else {
                    int n5;
                    int n6 = n5 = (int)((f4 - f) / f3) + 1;
                    fArray[n6] = fArray[n6] + 1.0f;
                }
                ++n;
            }
            ++n3;
        }
        if (this.bypercentage) {
            n = this.range.getWidth() * this.range.getHeight();
            int n7 = 0;
            while (n7 < fArray.length) {
                fArray[n7] = fArray[n7] * 100.0f / (float)n;
                ++n7;
            }
        }
    }
}

