/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.dnsalias.pcb.utilities.HelperClass;

public class HelpDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final long serialVersionUID = 19650221L;
    private int option;
    private String[] options;
    private String helpFilePath;
    private JFrame owner;
    private JTextArea tf;
    private JOptionPane dialogPane;
    private ResourceBundle HelpDialogResources;
    private static final String resourceSrc = "resources/HelpDialogResources";

    public HelpDialog(JFrame owner, boolean modal) {
        this(owner, owner.getTitle(), modal);
    }

    public HelpDialog(JFrame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.owner = owner;
        this.HelpDialogResources = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.helpFilePath = this.HelpDialogResources.getString("HelpFile_Name");
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        this.options = new String[1];
        this.options[0] = this.HelpDialogResources.getString("OK");
        this.dialogPane = new JOptionPane(this.HelpDialogResources.getString("Help"), -1, -1, null, this.options, this.options[0]);
        this.dialogPane.addPropertyChangeListener(this);
        JScrollPane sp = new JScrollPane();
        this.tf = this.createNewTextArea(sp);
        this.tf.setEditable(false);
        this.setAreaText(this.tf);
        this.dialogPane.add((Component)sp, 1);
        this.setContentPane(this.dialogPane);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
        this.dialogPane.selectInitialValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.dialogPane && prop.equals("value")) {
            this.option = -1;
            Object selectedValue = this.dialogPane.getValue();
            int maxCounter = this.options.length;
            for (int counter = 0; counter < maxCounter; ++counter) {
                if (!this.options[counter].equals(selectedValue)) continue;
                this.option = counter;
            }
            this.setVisible(false);
        }
    }

    public int getOption() {
        return this.option;
    }

    private JTextArea createNewTextArea(JScrollPane scrollpane) {
        JTextArea textArea = new JTextArea(28, 60);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(textArea.getLineWrap());
        textArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        scrollpane.setViewportView(textArea);
        return textArea;
    }

    private void setAreaText(JTextArea textarea) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.helpFilePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            textarea.read(reader, null);
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

