/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.utilities.dnd;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.dnsalias.pcb.utilities.dnd.StringTransferHandler;

public class TableCellTransferHandler
extends StringTransferHandler {
    private int[] rows = null;
    private int addIndex = -1;
    private int addCount = 0;
    private ArrayList<CellObject> objectList = null;
    private ArrayList<CellObject> cleanupObjectList = null;
    private ArrayList<CellObject> targetObjectList = null;

    @Override
    protected String exportString(JComponent c) {
        int col;
        int row;
        JTable table = (JTable)c;
        DefaultTableModel tm = (DefaultTableModel)table.getModel();
        this.objectList = new ArrayList();
        int colCount = table.getColumnCount();
        this.rows = table.getSelectedRows();
        StringBuffer buff = new StringBuffer();
        for (row = 0; row < table.getRowCount(); ++row) {
            for (col = 0; col < table.getColumnCount(); ++col) {
                if (!table.isCellSelected(row, col)) continue;
                Object o = table.getValueAt(row, col);
                this.objectList.add(new CellObject(o == null ? "" : o.toString(), row, col));
            }
        }
        for (row = 0; row < this.rows.length; ++row) {
            for (col = 0; col < colCount; ++col) {
                Object val = table.getValueAt(this.rows[table.convertRowIndexToModel(row)], table.convertColumnIndexToModel(col));
                if (table.isCellSelected(this.rows[table.convertRowIndexToModel(row)], table.convertColumnIndexToModel(col))) {
                    buff.append(val == null ? "" : val.toString());
                } else {
                    buff.append("");
                }
                if (col == colCount - 1) continue;
                buff.append("\t");
            }
            if (row == this.rows.length - 1) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    @Override
    protected void importString(JComponent c, String str) {
        int firstCol;
        JTable target = (JTable)c;
        DefaultTableModel model = (DefaultTableModel)target.getModel();
        int index = target.getSelectedRow();
        int firstRow = target.getSelectedRow();
        int colIndex = firstCol = target.getSelectedColumn();
        int rowIndex = firstRow;
        String value = null;
        if (this.objectList == null) {
            if (this.rows != null && index >= this.rows[0] - 1 && index <= this.rows[this.rows.length - 1]) {
                this.rows = null;
                return;
            }
            int max = model.getRowCount();
            if (index < 0) {
                index = max;
            } else if (++index > max) {
                index = max;
            }
            this.addIndex = index;
            String[] values = str.split("\\n");
            this.addCount = values.length;
            int columns = 0;
            if (values.length > 0) {
                columns = values[0].split("\\t").length;
            }
            int colCount = target.getColumnCount();
            if (columns == 1) {
                index = firstRow;
                max = model.getRowCount() - 1;
                Object[] o = null;
                for (int i = 0; i < values.length; ++i) {
                    if (index > max) {
                        model.insertRow(index, o);
                    }
                    model.setValueAt(values[i], index, firstCol);
                    ++index;
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    model.insertRow(index++, values[i].split("\\t"));
                }
            }
        } else if (firstCol != -1 && firstRow != -1 && this.objectList != null) {
            int lowestRowIndex = this.objectList.get(0).getRowPos();
            int lowestColIndex = this.objectList.get(0).getColumnPos();
            for (CellObject cellObject : this.objectList) {
                lowestRowIndex = Math.min(lowestRowIndex, cellObject.getRowPos());
                lowestColIndex = Math.min(lowestColIndex, cellObject.getColumnPos());
            }
            this.targetObjectList = new ArrayList(this.objectList.size());
            for (CellObject cellObject : this.objectList) {
                value = cellObject.getValue();
                rowIndex = cellObject.getRowPos() + firstRow - lowestRowIndex;
                colIndex = cellObject.getColumnPos() + firstCol - lowestColIndex;
                this.targetObjectList.add(new CellObject(value, rowIndex, colIndex));
                while (rowIndex > target.getRowCount() - 1) {
                    Object[] dummy = null;
                    model.addRow(dummy);
                }
                while (colIndex > target.getColumnCount() - 1) {
                    model.addColumn(null);
                }
                model.setValueAt(value, target.convertRowIndexToModel(rowIndex), target.convertColumnIndexToModel(colIndex));
            }
            this.cleanupObjectList = this.objectList;
            this.objectList = null;
            this.clearClipboard();
        }
    }

    @Override
    protected void cleanup(JComponent c, boolean remove) {
        JTable source = (JTable)c;
        if (remove && this.cleanupObjectList != null && this.targetObjectList != null) {
            DefaultTableModel model = (DefaultTableModel)source.getModel();
            for (CellObject cellObject : this.cleanupObjectList) {
                boolean deleteCell = true;
                int rowPos = cellObject.getRowPos();
                int colPos = cellObject.getColumnPos();
                for (CellObject targetCellObject : this.targetObjectList) {
                    int targetColPos = targetCellObject.getColumnPos();
                    int targetRowPos = targetCellObject.getRowPos();
                    if (colPos != targetColPos || rowPos != targetRowPos) continue;
                    deleteCell = false;
                }
                if (!deleteCell) continue;
                model.setValueAt("", source.convertRowIndexToModel(rowPos), source.convertColumnIndexToModel(colPos));
            }
            this.cleanupObjectList = null;
            this.targetObjectList = null;
        }
    }

    public boolean clearClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            clipboard.setContents(new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[0];
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return false;
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                    throw new UnsupportedFlavorException(flavor);
                }
            }, null);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private class CellObject {
        private int rowPos;
        private int columnPos;
        private String value;

        public CellObject(String value, int rowPos, int columnPos) {
            this.value = value;
            this.rowPos = rowPos;
            this.columnPos = columnPos;
        }

        public String getValue() {
            return this.value;
        }

        public int getRowPos() {
            return this.rowPos;
        }

        public int getColumnPos() {
            return this.columnPos;
        }
    }
}

