/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import sunw.hotjava.bean.CurrentDocument;
import sunw.hotjava.bean.HTMLBrowsable;
import sunw.hotjava.misc.HJBProperties;

public class SecurityMonitorImageButton
extends Canvas
implements PropertyChangeListener {
    private PropertyChangeSupport support;
    private boolean isSecure = false;
    private Image locked;
    private Image unlocked;
    private Image old;
    private boolean depressed = false;
    private boolean wasDepressed = false;
    private static Color OUTLINE = new Color(102, 102, 102);
    private static Color HIGHLIGHT = Color.white;
    private static Color OVERLAP = new Color(204, 204, 204);
    private static final int hMargin = 6;
    private static final int vMargin = 4;
    private ActionListener listeners;
    private HJBProperties props = HJBProperties.getHJBProperties("hjbrowser");

    public SecurityMonitorImageButton(String string, HTMLBrowsable hTMLBrowsable) {
        this.locked = this.props.getImage(this.props.getProperty("button." + string + ".locked"));
        this.unlocked = this.props.getImage(this.props.getProperty("button." + string + ".unlocked"));
        this.addMouseListener(new ImageButtonMouseListener());
        hTMLBrowsable.addPropertyChangeListener(this);
        this.support = new PropertyChangeSupport(this);
        try {
            Class<?> clazz = Class.forName("sunw.hotjava.security.SecurityMonitorListener");
            Object obj = clazz.newInstance();
            this.support.addPropertyChangeListener((PropertyChangeListener)obj);
            this.addActionListener((ActionListener)obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSize(this.props.getInteger("button." + string + ".width") + 6, this.props.getInteger("button." + string + ".height") + 4);
        this.repaintImage();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, actionListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("secureConnection")) {
            this.repaintImage();
            this.support.firePropertyChange("secureConnection", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("currentDocument")) {
            if (((CurrentDocument)propertyChangeEvent.getNewValue()).documentURL.getProtocol().equals("https")) {
                this.isSecure = true;
                this.repaintImage();
            } else {
                this.isSecure = false;
                this.repaintImage();
            }
            this.support.firePropertyChange("currentDocument", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public void update(Graphics graphics) {
        Image image = this.getImage();
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        Dimension dimension = this.getSize();
        graphics.setColor(OUTLINE);
        graphics.drawRect(0, 0, dimension.width - 2, dimension.height - 2);
        graphics.setColor(HIGHLIGHT);
        graphics.drawRect(1, 1, dimension.width - 2, dimension.height - 2);
        graphics.setColor(OVERLAP);
        graphics.drawLine(1, dimension.height - 2, 1, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, 1);
        graphics.drawImage(image, (dimension.width - n) / 2, (dimension.height - n2) / 2, this.getBackground(), this);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    protected void repaintImage() {
        Image image = this.getImage();
        if (image != this.old) {
            this.old = image;
            this.prepareImage(image, this);
            this.repaint();
        }
    }

    protected Image getImage() {
        Image image = this.isSecure ? this.locked : this.unlocked;
        return image;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.wasDepressed = true;
                this.depressed = true;
                break;
            }
            case 502: {
                if (this.wasDepressed) {
                    this.wasDepressed = false;
                    if (this.depressed) {
                        this.depressed = false;
                        ActionEvent actionEvent = new ActionEvent(this, 1001, null, mouseEvent.getModifiers());
                        this.listeners.actionPerformed(actionEvent);
                        break;
                    }
                }
            }
            case 504: {
                if (!this.wasDepressed) break;
                this.depressed = true;
                break;
            }
            case 505: {
                if (!this.wasDepressed) break;
                this.depressed = false;
                break;
            }
        }
        this.redispatch(mouseEvent);
    }

    private void redispatch(MouseEvent mouseEvent) {
        mouseEvent.getComponent().getParent().dispatchEvent(mouseEvent);
    }

    private final class ImageButtonMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            SecurityMonitorImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SecurityMonitorImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            SecurityMonitorImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SecurityMonitorImageButton.this.processMouseEvent(mouseEvent);
        }

        ImageButtonMouseListener() {
            SecurityMonitorImageButton.this = SecurityMonitorImageButton.this;
        }
    }
}

