/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.DoubleMeta;
import com.swabunga.spell.engine.EditDistance;
import com.swabunga.spell.engine.GenericTransformator;
import com.swabunga.spell.engine.Transformator;
import com.swabunga.spell.engine.Word;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class SpellDictionary {
    private static final char[] replacelist = new char[]{'A', 'B', 'X', 'S', 'K', 'J', 'T', 'F', 'H', 'L', 'M', 'N', 'P', 'R', '0'};
    private static final int INITIAL_CAPACITY = 16384;
    protected HashMap mainDictionary = new HashMap(16384);
    private Transformator tf = null;
    private File dictFile = null;

    public SpellDictionary(Reader reader) throws IOException {
        this.tf = new DoubleMeta();
        this.createDictionary(new BufferedReader(reader));
    }

    public SpellDictionary(String string) throws IOException {
        this.tf = new DoubleMeta();
        InputStream inputStream = this.getClass().getResourceAsStream("dictionary/" + string);
        this.createDictionary(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public SpellDictionary(File file) throws FileNotFoundException, IOException {
        this(new FileReader(file));
        this.dictFile = file;
    }

    public SpellDictionary(File file, File file2) throws FileNotFoundException, IOException {
        this.tf = new GenericTransformator(file2);
        this.dictFile = file;
        this.createDictionary(new BufferedReader(new FileReader(file)));
    }

    public void addWord(String string) {
        this.putWord(string);
        if (this.dictFile == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.dictFile.toString(), true);
            fileWriter.write(string);
            fileWriter.write("\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error writing to dictionary file");
        }
    }

    protected void createDictionary(BufferedReader bufferedReader) throws IOException {
        String string = "";
        while (string != null) {
            string = bufferedReader.readLine();
            if (string == null) continue;
            string = new String(string.toCharArray());
            this.putWord(string);
        }
    }

    public String getCode(String string) {
        return this.tf.transform(string);
    }

    protected void putWord(String string) {
        String string2 = this.getCode(string);
        LinkedList<String> linkedList = (LinkedList<String>)this.mainDictionary.get(string2);
        if (linkedList != null) {
            linkedList.add(string);
        } else {
            linkedList = new LinkedList<String>();
            linkedList.add(string);
            this.mainDictionary.put(string2, linkedList);
        }
    }

    public LinkedList getWords(String string) {
        LinkedList linkedList = (LinkedList)this.mainDictionary.get(string);
        if (linkedList == null) {
            return new LinkedList();
        }
        return linkedList;
    }

    public boolean isCorrect(String string) {
        LinkedList linkedList = this.getWords(this.getCode(string));
        if (linkedList.contains(string)) {
            return true;
        }
        return linkedList.contains(string.toLowerCase());
    }

    public LinkedList getSuggestions(String string, int n) {
        int n2;
        int n3;
        int n4;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.getCode(string);
        hashSet.add(string2);
        char[] cArray = string.toCharArray();
        for (n4 = 0; n4 < string.length() - 1; ++n4) {
            n3 = cArray[n4];
            cArray[n4] = n2 = cArray[n4 + 1];
            cArray[n4 + 1] = n3;
            hashSet.add(this.getCode(new String(cArray)));
            cArray[n4] = n3;
            cArray[n4 + 1] = n2;
        }
        cArray = string.toCharArray();
        for (n4 = 0; n4 < string.length(); ++n4) {
            n3 = cArray[n4];
            for (n2 = 0; n2 < replacelist.length; ++n2) {
                cArray[n4] = replacelist[n2];
                hashSet.add(this.getCode(new String(cArray)));
            }
            cArray[n4] = n3;
        }
        string = string + " ";
        cArray = string.toCharArray();
        n4 = cArray.length - 1;
        while (true) {
            for (n3 = 0; n3 < replacelist.length; ++n3) {
                cArray[n4] = replacelist[n3];
                hashSet.add(this.getCode(new String(cArray)));
            }
            if (n4 == 0) break;
            cArray[n4] = cArray[n4 - 1];
            --n4;
        }
        string = string.trim();
        cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length - 1];
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray2[n2] = cArray[n2];
        }
        n2 = cArray[cArray.length - 1];
        int n5 = cArray2.length;
        while (true) {
            hashSet.add(this.getCode(new String(cArray)));
            if (n5 == 0) break;
            int n6 = n2;
            n2 = cArray2[n5 - 1];
            cArray2[n5 - 1] = n6;
            --n5;
        }
        LinkedList linkedList = this.getWordsFromCode(string, hashSet);
        Collections.sort(linkedList, new Word());
        return linkedList;
    }

    private LinkedList getWordsFromCode(String string, Collection collection) {
        Configuration configuration = Configuration.getConfiguration();
        LinkedList<Word> linkedList = new LinkedList<Word>();
        for (String string2 : collection) {
            LinkedList linkedList2 = this.getWords(string2);
            for (String string3 : linkedList2) {
                int n = EditDistance.getDistance(string, string3);
                if (n >= configuration.getInteger("SPELL_THRESHOLD")) continue;
                Word word = new Word(string3, n);
                linkedList.add(word);
            }
        }
        return linkedList;
    }

    public void dispose() {
        this.mainDictionary = null;
        this.tf = null;
        this.dictFile = null;
    }
}

