/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.hotedit.edit;

import dk.hfalk.HotEditAction;
import dk.hfalk.db.DBHotEditManager;
import dk.hfalk.db.DBHotSpotItem;
import dk.hfalk.hotedit.util.PlugInInterface;
import dk.hfalk.hotedit.util.PropertyItem;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HotSpotPropertiesDialog
extends JDialog
implements ActionListener {
    protected Button okButton;
    protected Button cancelButton;
    protected TextField idNameTextField;
    protected TextArea descriptionTextArea;
    DBHotSpotItem currentItem;
    HotEditAction controller;
    private ResourceBundle resource;
    boolean isAdding;

    public HotSpotPropertiesDialog(HotEditAction hotEditAction, String string, boolean bl, DBHotSpotItem dBHotSpotItem) {
        super(hotEditAction.getFrame(), string, true);
        Serializable serializable;
        this.controller = hotEditAction;
        try {
            serializable = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("dk.hfalk.hotedit.edit.HotSpotPropertiesDialogL", (Locale)serializable);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog(hotEditAction.getFrame(), missingResourceException.getMessage(), "INFORMATION_MESSAGE", 1);
            return;
        }
        this.enableEvents(64L);
        this.getContentPane().setLayout(new CardLayout(10, 10));
        this.setTitle(string);
        this.currentItem = dBHotSpotItem;
        this.isAdding = bl;
        serializable = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        Label label = new Label(this.resource.getString("JEditHotSpot_LabelName"));
        this.idNameTextField = new TextField(32);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("West", label);
        jPanel2.add("East", this.idNameTextField);
        jPanel.add("Center", jPanel2);
        Label label2 = new Label(this.resource.getString("JEditHotSpot_LabelDescription"));
        this.descriptionTextArea = new TextArea(10, 30);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", label2);
        jPanel3.add("South", this.descriptionTextArea);
        jPanel.add("South", jPanel3);
        ((Container)serializable).add("Center", jPanel);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.okButton = new Button(DBHotEditManager.instance().common("Common_OK"));
        this.okButton.addActionListener(this);
        jPanel4.add(this.okButton);
        this.cancelButton = new Button(DBHotEditManager.instance().common("Common_Cancel"));
        this.cancelButton.addActionListener(this);
        jPanel4.add(this.cancelButton);
        ((Container)serializable).add("South", jPanel4);
        this.getContentPane().add("Center", (Component)serializable);
        Enumeration enumeration = DBHotEditManager.instance().getPlugInList().elements();
        while (enumeration.hasMoreElements()) {
            PlugInInterface plugInInterface = (PlugInInterface)enumeration.nextElement();
            Hashtable hashtable = plugInInterface.getAttributes();
            if (hashtable == null) continue;
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                PropertyItem propertyItem = (PropertyItem)enumeration2.nextElement();
                if (dBHotSpotItem.hasAttribute(propertyItem.getPlugin(), propertyItem.getName())) continue;
                dBHotSpotItem.addAttribute(propertyItem);
            }
        }
        System.out.println("A");
        if (dBHotSpotItem != null && !this.isAdding) {
            this.idNameTextField.setText(dBHotSpotItem.name());
            this.idNameTextField.setEditable(false);
            ((Component)this.idNameTextField).setBackground(Color.lightGray);
            this.descriptionTextArea.setText(dBHotSpotItem.description());
        }
        System.out.println("B");
        this.getContentPane().setBackground(Color.lightGray);
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DBHotEditManager.instance().common("Common_OK"))) {
            String string2 = null;
            string2 = this.descriptionTextArea.getText();
            if (string2.length() == 0) {
                JOptionPane.showMessageDialog(this.controller.getFrame(), this.resource.getString("JEditHotSpot_NoDescription"), this.getTitle(), 1);
                return;
            }
            string2 = this.idNameTextField.getText();
            if (string2.length() > 64) {
                JOptionPane.showMessageDialog(this.controller.getFrame(), this.resource.getString("JEditHotSpot_ValidName"), this.getTitle(), 1);
                return;
            }
            if (string2.length() == 0) {
                JOptionPane.showMessageDialog(this.controller.getFrame(), this.resource.getString("JEditHotSpot_EmptyName"), this.getTitle(), 1);
                return;
            }
            this.currentItem.setDescription(this.descriptionTextArea.getText());
            this.currentItem.setVisible(true);
            if (this.isAdding) {
                this.currentItem.setUID(this.controller.getActiveWindow().hotSpotGroup.getUID());
                this.currentItem.setName(this.idNameTextField.getText());
                this.controller.getActiveWindow().hotSpotGroup.add(this.currentItem);
            }
            this.setVisible(false);
            this.dispose();
        }
        if (string.equals(DBHotEditManager.instance().common("Common_Cancel"))) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean getFocus(Event event, Object object) {
        this.okButton.requestFocus();
        return true;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.setVisible(false);
                this.dispose();
                break;
            }
            default: {
                super.processWindowEvent(windowEvent);
            }
        }
    }

    public void setLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation();
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }
}

