/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.jimagemapper;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.vafada.jimagemapper.Shape;

public class Polygon
extends Shape {
    private java.awt.Polygon _polygon;

    public Polygon(int[] nArray, int[] nArray2) {
        this._polygon = new java.awt.Polygon(nArray, nArray2, nArray.length);
    }

    @Override
    public void draw(Graphics2D graphics2D, double d) {
        java.awt.Polygon polygon = this.computeZoomedPolygon(d);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        if (this.active) {
            this.drawHighlighted(graphics2D, d);
        }
    }

    @Override
    public void drawHighlighted(Graphics2D graphics2D, double d) {
        java.awt.Polygon polygon = this.computeZoomedPolygon(d);
        graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        graphics2D.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    private java.awt.Polygon computeZoomedPolygon(double d) {
        int[] nArray = new int[this._polygon.npoints];
        int[] nArray2 = new int[this._polygon.npoints];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)Math.round((double)this._polygon.xpoints[i] * d);
            nArray2[i] = (int)Math.round((double)this._polygon.ypoints[i] * d);
        }
        return new java.awt.Polygon(nArray, nArray2, nArray.length);
    }

    @Override
    public boolean contains(Point point, double d) {
        java.awt.Polygon polygon = this.computeZoomedPolygon(d);
        return polygon.contains(point);
    }

    public int[] getXPoints() {
        return this._polygon.xpoints;
    }

    public int[] getYPoints() {
        return this._polygon.ypoints;
    }

    public int getNPoints() {
        return this._polygon.npoints;
    }

    public static Polygon computeOriginalPolygon(Polygon polygon, double d) {
        int[] nArray = new int[polygon.getNPoints()];
        int[] nArray2 = new int[polygon.getNPoints()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)Math.round((double)polygon.getXPoints()[i] / d);
            nArray2[i] = (int)Math.round((double)polygon.getYPoints()[i] / d);
        }
        return new Polygon(nArray, nArray2);
    }
}

