/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CfgReader
extends Hashtable {
    File fn;

    public CfgReader(String string) {
        this.fn = new File(string);
        if (!this.fn.exists()) {
            try {
                new File(this.fn.getParent()).mkdirs();
            }
            catch (SecurityException securityException) {
                System.err.println("Can't create configuration file: " + securityException.toString());
            }
        }
        this.run();
    }

    public String commentOff(String string) {
        int n = string.lastIndexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.length() > 0) {
            return string;
        }
        return null;
    }

    public String data() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        int n = this.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n2] = enumeration.nextElement();
            ++n2;
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            stringBuffer.append(objectArray[n3]);
            stringBuffer.append("=");
            if (this.get(objectArray[n3]) != null) {
                stringBuffer.append(this.get(objectArray[n3]));
            } else {
                stringBuffer.append("");
            }
            stringBuffer.append("\r\n");
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String[] getRule(String string) {
        String[] stringArray = new String[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.hasMoreTokens()) {
            stringArray[0] = stringTokenizer.nextToken().trim().toUpperCase();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringArray[1] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        CfgReader cfgReader = new CfgReader(stringArray[0]);
    }

    public void run() {
        try {
            int n;
            FileReader fileReader = new FileReader(this.fn);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[512];
            while ((n = fileReader.read(cArray)) != -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
            ((Reader)fileReader).close();
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                String string = this.commentOff(stringTokenizer.nextToken());
                if (string == null) continue;
                String[] stringArray = this.getRule(string);
                try {
                    this.put(stringArray[0], stringArray[1]);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println();
            System.err.println(fileNotFoundException.toString());
            System.err.println("Configuration file will be created on exit.");
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    public void write() {
        try {
            FileWriter fileWriter = new FileWriter(this.fn);
            String string = this.data();
            ((Writer)fileWriter).write(string, 0, string.length());
            ((Writer)fileWriter).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }
}

