/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class Manager
extends JPanel {
    private static ResourceBundle resources;
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    private Hashtable commands = new Hashtable();
    private Hashtable menuitems = new Hashtable();
    private Hashtable toolitems = new Hashtable();
    private JToolBar toolbar;
    private JMenuBar menubar;
    protected JSplitPane splitpane;
    protected JSplitPane intsplitpane;
    private JDialog aboutdialog;
    private JOptionPane aboutpane;
    private CDocument document;
    protected FileDialog fileDialog;
    private Settings settings;
    StatusBar status = new StatusBar();
    Point loc;
    JustStyle js;
    JFrame frame;

    static {
        try {
            resources = ResourceBundle.getBundle("resources.Manager", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("resources/Manager.properties not found");
            System.exit(1);
        }
    }

    public Manager(JustStyle justStyle) {
        this(justStyle, null);
    }

    public Manager(JustStyle justStyle, Point point) {
        this.js = justStyle;
        this.loc = point;
        this.settings = new Settings();
        this.setLayout(new BorderLayout());
        this.setupAction();
        this.setupMenu();
        this.add((Component)this.getToolBar(), "North");
        this.status = new StatusBar();
        this.setDoubleBuffered(true);
        this.setupDocument();
    }

    public String RegistredTo() {
        if (this.check(this.getSettings().getString("REGC", ""))) {
            return "         " + this.getSettings().getString("REGN", "");
        }
        return "         UNREGISTERED";
    }

    public String Serial() {
        if (this.check(this.getSettings().getString("REGC", ""))) {
            return "         " + this.getSettings().getString("REGC", "") + " (1 license)";
        }
        return "         UNREGISTERED";
    }

    static /* synthetic */ JOptionPane access$2(Manager manager) {
        return manager.aboutpane;
    }

    private boolean check(String string) {
        HashFunc hashFunc = new HashFunc(string);
        int n = CHeap.o.length;
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(CHeap.o[n2]);
            ++n2;
        }
        return vector.contains(hashFunc.asHex());
    }

    protected PropertyChangeListener createActionChangeListener(JButton jButton) {
        return new ActionChangedListener2(jButton);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public Action[] createActions() {
        Action[] actionArray = new Action[]{new OpenAction(), new AddAction(), new ExitAction(), new AboutAction(), new DelAction(), new NewDocAction(), new GcAction(), new RenAction(), new SaveAction(), new SaveasAction(), new RegAction(), new HelpAction(), new NIAction(), new ImpHTMLTagsAction(), new LinkToHTMLAction(), new InsertToHTMLAction(), new ExportPlainCSSAction()};
        return actionArray;
    }

    public CDocument createDocument() {
        return new CDocument("Body");
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize(this.getResourceString(string));
        JMenu jMenu = new JMenu(this.getResourceString(String.valueOf(string) + labelSuffix));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = this.createMenuItem(stringArray[n]);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        return jMenu;
    }

    protected JMenuItem createMenuItem(String string) {
        String string2;
        JMenuItem jMenuItem = new JMenuItem(this.getResourceString(String.valueOf(string) + labelSuffix));
        URL uRL = this.getResource(String.valueOf(string) + imageSuffix);
        if (uRL != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(new ImageIcon(uRL));
        }
        if ((string2 = this.getResourceString(String.valueOf(string) + actionSuffix)) == null) {
            string2 = string;
        }
        jMenuItem.setActionCommand(string2);
        Action action = this.getAction(string2);
        if (action != null) {
            jMenuItem.addActionListener(action);
            action.addPropertyChangeListener(this.createActionChangeListener(jMenuItem));
            jMenuItem.setEnabled(action.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        this.menuitems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = this.tokenize(this.getResourceString("menubar"));
        int n = 0;
        while (n < stringArray.length) {
            JMenu jMenu = this.createMenu(stringArray[n]);
            if (jMenu != null) {
                jMenuBar.add(jMenu);
            }
            ++n;
        }
        return jMenuBar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = this.tokenize(this.getResourceString("toolbar"));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                this.toolbar.addSeparator();
            } else {
                this.toolbar.add(this.createTool(stringArray[n]));
            }
            ++n;
        }
        this.toolbar.add(Box.createHorizontalStrut(5));
        return this.toolbar;
    }

    protected JButton createToolbarButton(String string) {
        Action action;
        URL uRL = this.getResource(String.valueOf(string) + imageSuffix);
        JButton jButton = new JButton(new ImageIcon(uRL));
        jButton.setAlignmentY(0.5f);
        jButton.setRequestFocusEnabled(false);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        String string2 = this.getResourceString(String.valueOf(string) + actionSuffix);
        if (string2 == null) {
            string2 = string;
        }
        if ((action = this.getAction(string2)) != null) {
            jButton.setActionCommand(string2);
            jButton.addActionListener(action);
            action.addPropertyChangeListener(this.createActionChangeListener(jButton));
        } else {
            jButton.setEnabled(false);
        }
        String string3 = this.getResourceString(String.valueOf(string) + tipSuffix);
        if (string3 != null) {
            jButton.setToolTipText(string3);
        }
        this.toolitems.put(string2, jButton);
        return jButton;
    }

    protected void documentChanged() {
        if (this.splitpane == null || this.intsplitpane == null) {
            this.intsplitpane = new JSplitPane(1, new JScrollPane(this.document.getTree()), new JScrollPane(this.document.getTable()));
            this.intsplitpane.setDividerSize(2);
            this.intsplitpane.setBorder(null);
            this.splitpane = new JSplitPane(0, this.intsplitpane, new JScrollPane(this.document.getTextArea()));
            this.splitpane.setDividerSize(2);
            this.splitpane.setBorder(null);
            this.add((Component)this.splitpane, "Center");
        } else {
            this.settings.put("D1", String.valueOf(this.splitpane.getDividerLocation()));
            this.settings.put("D2", String.valueOf(this.intsplitpane.getDividerLocation()));
            this.settings.write();
            this.intsplitpane.setLeftComponent(new JScrollPane(this.document.getTree()));
            this.intsplitpane.setRightComponent(new JScrollPane(this.document.getTable()));
            this.splitpane.setBottomComponent(new JScrollPane(this.document.getTextArea()));
        }
        this.intsplitpane.setDividerLocation(this.getSettings().getInt("D2", 150));
        this.splitpane.setDividerLocation(this.getSettings().getInt("D1", 250));
        this.validate();
    }

    void exit(int n) {
        this.settings.put("WIDTH", String.valueOf(this.getFrame().getSize().width));
        this.settings.put("HEIGHT", String.valueOf(this.getFrame().getSize().height));
        this.settings.put("X", String.valueOf(this.getFrame().getLocationOnScreen().x));
        this.settings.put("Y", String.valueOf(this.getFrame().getLocationOnScreen().y));
        this.settings.put("D1", String.valueOf(this.splitpane.getDividerLocation()));
        this.settings.put("D2", String.valueOf(this.intsplitpane.getDividerLocation()));
        this.settings.write();
        this.frame.dispose();
        this.js.managerRemoved();
    }

    public ResourceBundle gerResources() {
        return resources;
    }

    protected Action getAction(String string) {
        if (this.commands.get(string) != null) {
            return (Action)this.commands.get(string);
        }
        return null;
    }

    public CDocument getDocument() {
        return this.document;
    }

    protected Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    protected URL getResource(String string) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            URL uRL = this.getClass().getResource(string2);
            return uRL;
        }
        return null;
    }

    protected String getResourceString(String string) {
        String string2;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = null;
        }
        return string2;
    }

    public Settings getSettings() {
        return this.settings;
    }

    JToolBar getToolBar() {
        return (JToolBar)this.createToolbar();
    }

    protected File nFileDialog(int n) {
        if (n == 1) {
            return this.nFileDialog(n, "Save As");
        }
        return this.nFileDialog(n, "Open");
    }

    protected File nFileDialog(int n, String string) {
        File file;
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.getFrame());
        }
        if (n == 1) {
            this.fileDialog.setFile(null);
            this.fileDialog.setDirectory(null);
        }
        ((Dialog)this.fileDialog).setTitle(string);
        this.fileDialog.setMode(n);
        this.fileDialog.show();
        String string2 = this.fileDialog.getFile();
        String string3 = this.fileDialog.getDirectory();
        try {
            file = new File(string3, string2);
        }
        catch (NullPointerException nullPointerException) {
            file = null;
        }
        return file;
    }

    private void oh() {
        SwingUtilities.invokeLater(new RemDialog(this.getFrame(), this.getAction("reg")));
    }

    public Component parentComponent() {
        return this;
    }

    public JFrame podporka() {
        final JFrame jFrame = new JFrame(this.gerResources().getString("Title"));
        jFrame.setDefaultCloseOperation(0);
        int n = this.getSettings().getInt("WIDTH", 680);
        int n2 = this.getSettings().getInt("HEIGHT", 460);
        ((Component)jFrame).setSize(n, n2);
        Point point = ComponentTools.setPos(jFrame);
        if (this.loc == null) {
            ((Component)jFrame).setLocation(this.getSettings().getInt("X", point.x), this.getSettings().getInt("Y", point.y));
        } else {
            ((Component)jFrame).setLocation(this.loc.x, this.loc.y);
        }
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!this.throwDocument()) {
                    return;
                }
                this.exit(0);
                jFrame.dispose();
            }
        });
        jFrame.setJMenuBar(this.getMenuBar());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this, "Center");
        jFrame.getContentPane().add((Component)this.status, "South");
        this.frame = jFrame;
        this.frame.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultHtmlHelp defaultHtmlHelp = new DefaultHtmlHelp("index.htm");
            }
        }, KeyStroke.getKeyStroke(112, 0), 2);
        this.updateTitle();
        return jFrame;
    }

    public void setDocument(CDocument cDocument) {
        this.document = cDocument;
        this.document.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Manager.this.document.getTree().getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null) {
                    if (!defaultMutableTreeNode.isRoot()) {
                        Manager.this.getAction("ren").setEnabled(true);
                        Manager.this.getAction("del").setEnabled(true);
                    } else {
                        Manager.this.getAction("ren").setEnabled(false);
                        Manager.this.getAction("del").setEnabled(false);
                    }
                }
            }
        });
        if (this.getDocument().getType() == CDocument.CSS) {
            this.getAction("exportplaincss").setEnabled(false);
            this.getAction("linktohtml").setEnabled(true);
            this.getAction("imphtmltags").setEnabled(true);
            this.getAction("inserttohtml").setEnabled(true);
        } else if (this.getDocument().getType() == CDocument.HTML) {
            this.getAction("exportplaincss").setEnabled(true);
            this.getAction("linktohtml").setEnabled(false);
            this.getAction("imphtmltags").setEnabled(false);
            this.getAction("inserttohtml").setEnabled(false);
        }
        if (this.document.getTree().getRowCount() > 1) {
            this.document.getTree().setSelectionRow(1);
        } else {
            this.document.getTree().setSelectionRow(0);
        }
        this.document.setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Manager.this.status.setText(" Document changed ");
            }
        });
        this.status(" ");
        this.updateTitle();
        this.documentChanged();
    }

    protected void setupAction() {
        Action[] actionArray = this.createActions();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            this.commands.put(action.getValue("Name"), action);
            ++n;
        }
    }

    protected void setupDocument() {
        this.setDocument(this.createDocument());
    }

    protected void setupMenu() {
        this.menubar = this.createMenubar();
    }

    public void sheckReg() {
        if (!this.check(this.getSettings().getString("REGC", ""))) {
            this.oh();
        }
    }

    protected void showNormalCursor() {
        this.getFrame().setCursor(new Cursor(0));
    }

    protected void showWaitCursor() {
        this.getFrame().setCursor(new Cursor(3));
    }

    public void status(String string) {
        this.status.setText(string);
    }

    protected boolean throwDocument() {
        if (!this.document.isChanged()) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(null, "The current document has changed.\nDo you want to save the changes?", "Save current document?", 1);
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        if (n == 0) {
            this.getAction("save").actionPerformed(null);
            return this.document.isChanged() ^ true;
        }
        return false;
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public void toolStateChanged(String string, boolean bl) {
        JButton jButton = (JButton)this.toolitems.get(string);
        if (jButton != null) {
            jButton.setEnabled(bl);
        }
    }

    public void updateTitle() {
        if (this.frame != null) {
            this.frame.setTitle(String.valueOf(this.gerResources().getString("Title")) + " - " + this.getDocument().title());
        }
        this.getDocument().getTree().treeDidChange();
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("open");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CDocument cDocument = null;
            if (!Manager.this.throwDocument()) {
                return;
            }
            try {
                File file = Manager.this.nFileDialog(0, "Open");
                Manager.this.showWaitCursor();
                FileLoader fileLoader = new FileLoader(file);
                fileLoader.run();
                String string = fileLoader.getData();
                try {
                    Vector vector = HTMLLinker.importCSSElementsFromHTML(string);
                    cDocument = new CDocument(file, vector, CDocument.HTML);
                    cDocument.setAssocFileContent(string);
                }
                catch (FileFormatException fileFormatException) {
                    Vector vector = CParser.getAllCElements(string);
                    cDocument = new CDocument(file, vector, CDocument.CSS);
                }
                if (cDocument != null) {
                    Manager.this.setDocument(cDocument);
                    Manager.this.updateTitle();
                }
                Manager.this.showNormalCursor();
            }
            catch (IOException iOException) {
                Manager.this.showNormalCursor();
            }
            catch (NullPointerException nullPointerException) {
                Manager.this.showNormalCursor();
            }
        }
    }

    class SaveasAction
    extends AbstractAction {
        SaveasAction() {
            super("saveas");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = Manager.this.nFileDialog(1, "Save as");
            if (file != null) {
                ActionEvent actionEvent2 = new ActionEvent(file, 1001, "saveas");
                Manager.this.getAction("save").actionPerformed(actionEvent2);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("save");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            Manager.this.showWaitCursor();
            File file2 = Manager.this.getDocument().getAssocFile();
            try {
                file = actionEvent.getActionCommand().equals("saveas") ? (File)actionEvent.getSource() : file2;
            }
            catch (NullPointerException nullPointerException) {
                file = file2;
            }
            if (file == null) {
                Manager.this.getAction("saveas").actionPerformed(actionEvent);
                return;
            }
            if (Manager.this.getDocument().getType() == CDocument.CSS) {
                FileSaver fileSaver = new FileSaver(file, Manager.this.getDocument().toText());
                fileSaver.run();
            } else if (Manager.this.getDocument().getType() == CDocument.HTML) {
                String string = Manager.this.getDocument().getAssocFileContent();
                StringBuffer stringBuffer = new StringBuffer(string);
                try {
                    Object object;
                    HTMLLinker.insertCSSToHTML(stringBuffer, Manager.this.getDocument().toText(), true);
                    if (file == file2) {
                        object = new File(file.getParent(), String.valueOf(file.getName()) + ".bak");
                        FileSaver fileSaver = new FileSaver((File)object, string);
                        fileSaver.run();
                    }
                    object = new FileSaver(file, stringBuffer.toString());
                    ((FileSaver)object).run();
                }
                catch (FileFormatException fileFormatException) {
                    JOptionPane.showMessageDialog(null, fileFormatException.toString());
                }
                catch (NullPointerException nullPointerException) {
                    JOptionPane.showMessageDialog(null, nullPointerException.toString());
                }
            }
            Manager.this.getDocument().setChanged(false);
            Manager.this.status(" ");
            Manager.this.getDocument().setAssocFile(file);
            Manager.this.updateTitle();
            Manager.this.showNormalCursor();
        }
    }

    class ExportPlainCSSAction
    extends AbstractAction {
        ExportPlainCSSAction() {
            super("exportplaincss");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = Manager.this.nFileDialog(1, "Save as");
            if (file != null) {
                FileSaver fileSaver = new FileSaver(file, Manager.this.getDocument().toText());
                fileSaver.run();
            }
        }
    }

    class ImpHTMLTagsAction
    extends AbstractAction {
        ImpHTMLTagsAction() {
            super("imphtmltags");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!Manager.this.throwDocument()) {
                return;
            }
            if (Manager.this.fileDialog == null) {
                Manager.this.fileDialog = new FileDialog(Manager.this.getFrame());
            }
            Manager.this.fileDialog.setMode(0);
            Manager.this.fileDialog.show();
            String string = Manager.this.fileDialog.getFile();
            String string2 = Manager.this.fileDialog.getDirectory();
            if (string == null) {
                return;
            }
            Manager.this.showWaitCursor();
            FileLoader fileLoader = new FileLoader(new File(string2, string));
            try {
                fileLoader.run();
                Vector vector = HTMLUtils.tags(fileLoader.getData());
                int n = vector.size();
                Vector<CElement> vector2 = new Vector<CElement>(n);
                int n2 = 0;
                while (n2 < n) {
                    vector2.addElement(new CElement(vector.elementAt(n2).toString()));
                    ++n2;
                }
                CDocument cDocument = new CDocument(vector2, CDocument.CSS);
                Manager.this.setDocument(cDocument);
                Manager.this.updateTitle();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException.toString(), "Import", 2);
                Manager.this.showNormalCursor();
            }
            Manager.this.showNormalCursor();
        }
    }

    class LinkToHTMLAction
    extends AbstractAction {
        LinkToHTMLAction() {
            super("linktohtml");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Manager.this.getDocument().getAssocFile() == null) {
                JOptionPane.showMessageDialog(null, "You must save current CSS document,\nbefore trying to attach it to HTML documents.", "File is not saved!", 2);
                return;
            }
            if (Manager.this.getDocument().getType() != CDocument.CSS) {
                JOptionPane.showMessageDialog(null, "It is not a plain CSS document.\nPlease use \"Export plain CSS...\" in the \"File\" menu.");
                return;
            }
            try {
                File file = Manager.this.nFileDialog(0, "Select file");
                Manager.this.showWaitCursor();
                FileLoader fileLoader = new FileLoader(file);
                fileLoader.run();
                String string = fileLoader.getData();
                String string2 = FileTools.relative(Manager.this.getDocument().getAssocFile().getAbsolutePath(), file.getParent());
                string2 = FileTools.toURL(string2);
                String string3 = FileTools.toURL(Manager.this.getDocument().getAssocFile().getAbsolutePath());
                String string4 = Manager.this.getDocument().getAssocFile().getName();
                StringPair[] stringPairArray = new StringPair[]{new StringPair(String.valueOf(string2) + " (Relative)", string2), new StringPair(String.valueOf(string3) + " (Full)", string3), new StringPair(String.valueOf(string4) + " (Short)", string4), new StringPair("Other", "INPUT")};
                PathChooseDialog pathChooseDialog = new PathChooseDialog(Manager.this.getFrame(), "Select path", "Select type of path to css document:", stringPairArray);
                String string5 = pathChooseDialog.ask();
                String[] stringArray = HTMLLinker.listLinkedFiles(string);
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].toLowerCase().equals(string5.toLowerCase())) {
                        JOptionPane.showMessageDialog(null, "File " + Manager.this.getDocument().getAssocFile().getAbsolutePath() + " is already attached to " + file.getAbsolutePath() + ".", "Already attached!", 1);
                        return;
                    }
                    ++n;
                }
                try {
                    File file2 = new File(file.getParent(), String.valueOf(file.getName()) + ".bak");
                    FileSaver fileSaver = new FileSaver(file2, string);
                    fileSaver.run();
                    StringBuffer stringBuffer = new StringBuffer(string);
                    HTMLLinker.attachCSSToHTML(stringBuffer, string5);
                    FileSaver fileSaver2 = new FileSaver(file, stringBuffer.toString());
                    fileSaver2.run();
                }
                catch (NullPointerException nullPointerException) {
                    JOptionPane.showMessageDialog(null, "Error while trying to save file:\n" + nullPointerException.toString());
                    throw nullPointerException;
                }
                JOptionPane.showMessageDialog(null, "File " + Manager.this.getDocument().getAssocFile().getName() + " successfully attached to " + file.getName() + ".", "Successfully attached!", 1);
            }
            catch (IOException iOException) {
                Manager.this.showNormalCursor();
            }
            catch (NullPointerException nullPointerException) {
                Manager.this.showNormalCursor();
            }
            catch (FileFormatException fileFormatException) {
                JOptionPane.showMessageDialog(null, fileFormatException.toString());
                Manager.this.showNormalCursor();
            }
            Manager.this.showNormalCursor();
        }
    }

    class InsertToHTMLAction
    extends AbstractAction {
        InsertToHTMLAction() {
            super("inserttohtml");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            String string = null;
            try {
                if (file == null) {
                    file = Manager.this.nFileDialog(0, "Select document");
                    Manager.this.showWaitCursor();
                    FileLoader fileLoader = new FileLoader(file);
                    fileLoader.run();
                    string = fileLoader.getData();
                }
                Manager.this.showWaitCursor();
                StringBuffer stringBuffer = new StringBuffer(string);
                Vector vector = HTMLLinker.importCSSElementsFromHTML(string);
                Vector vector2 = Manager.this.getDocument().children();
                Vector vector3 = new Vector();
                int n = 0;
                while (n < vector.size()) {
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        boolean bl = vector2.elementAt(n2).toString().toLowerCase().equals(vector.elementAt(n).toString().toLowerCase());
                        if (bl && !vector3.contains(vector2.elementAt(n2).toString())) {
                            vector3.addElement(vector.elementAt(n));
                        }
                        ++n2;
                    }
                    ++n;
                }
                if (vector3.size() > 0) {
                    MultiAddDialog multiAddDialog = new MultiAddDialog(Manager.this.getFrame(), "Select Elements", vector3, (Vector)vector3.clone(), "Already defined in " + file.getName() + ":", "Don't overwrite in " + file.getName() + ":");
                    Vector vector4 = multiAddDialog.showDialog();
                    if (vector4 == null) throw new NullPointerException();
                    HTMLLinker.insertCSSToHTML(stringBuffer, Manager.this.getDocument().toText(vector4), true);
                } else {
                    HTMLLinker.insertCSSToHTML(stringBuffer, Manager.this.getDocument().toText(), true);
                }
                try {
                    File file2 = new File(file.getParent(), String.valueOf(file.getName()) + ".bak");
                    FileSaver fileSaver = new FileSaver(file2, string);
                    fileSaver.run();
                    FileSaver fileSaver2 = new FileSaver(file, stringBuffer.toString());
                    fileSaver2.run();
                }
                catch (NullPointerException nullPointerException) {
                    JOptionPane.showMessageDialog(null, "Error while trying to save file:\n" + nullPointerException.toString());
                    throw nullPointerException;
                }
                JOptionPane.showMessageDialog(null, "Insertion into " + file.getName() + " completed successfully.", "Inserted successfully!", 1);
            }
            catch (FileFormatException fileFormatException) {
                Manager.this.showNormalCursor();
                JOptionPane.showMessageDialog(null, fileFormatException.toString());
            }
            catch (IOException iOException) {
                Manager.this.showNormalCursor();
            }
            catch (NullPointerException nullPointerException) {
                Manager.this.showNormalCursor();
            }
            Manager.this.showNormalCursor();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!Manager.this.throwDocument()) {
                return;
            }
            Manager.this.exit(0);
        }
    }

    class NIAction
    extends AbstractAction {
        NIAction() {
            super("ni");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.js.newManager();
        }
    }

    class GcAction
    extends AbstractAction {
        GcAction() {
            super("gc");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
        }
    }

    class NewDocAction
    extends AbstractAction {
        NewDocAction() {
            super("new");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!Manager.this.throwDocument()) {
                return;
            }
            Manager.this.showWaitCursor();
            Manager.this.setDocument(Manager.this.createDocument());
            Manager.this.showNormalCursor();
        }
    }

    class AddAction
    extends AbstractAction {
        AddAction() {
            super("add");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Manager.this.document.askElValue(Manager.this.getFrame());
            if (string != null && string.length() > 0) {
                Manager.this.document.addElement(new CElement(string));
            }
        }
    }

    class RenAction
    extends AbstractAction {
        RenAction() {
            super("ren");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.document.renameSelectedElement();
        }
    }

    class DelAction
    extends AbstractAction {
        DelAction() {
            super("del");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.document.delSelectedElements();
        }
    }

    class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("about");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = new String("\nJustStyle Cascade Style Sheets Editor\nVersion 1.2\nCopyright (c) UCWare Group, 2001\n\nWeb:\n         http://juststyle.mastak.com  \nSupport:\n         juststyle@zworg.com\n\nRegistred to: \n" + Manager.this.RegistredTo() + "\n" + "S/N: \n" + Manager.this.Serial() + "\n\n" + "Configuration file:\n" + "         " + System.getProperties().getProperty("user.home") + System.getProperties().getProperty("file.separator") + "juststyle\\juststyle  \n" + "JRE Version:\n" + "         " + System.getProperties().getProperty("java.version") + " " + System.getProperties().getProperty("java.vendor") + "\n");
            new AboutDialog(Manager.this.getFrame(), string).show();
        }
    }

    class RegAction
    extends AbstractAction {
        RegAction() {
            super("reg");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RegDialog regDialog = new RegDialog(Manager.this.getFrame());
            String[] stringArray = regDialog.ask();
            if (stringArray[0] != null || stringArray[1] != null) {
                if (Manager.this.check(stringArray[1])) {
                    Manager.this.getSettings().put("REGN", stringArray[0]);
                    Manager.this.getSettings().put("REGC", stringArray[1]);
                    Manager.this.aboutpane = null;
                    new AboutAction().actionPerformed(null);
                } else {
                    Manager.this.oh();
                }
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            super("help");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultHtmlHelp defaultHtmlHelp = new DefaultHtmlHelp("index.htm");
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            }
        }
    }

    private class ActionChangedListener2
    implements PropertyChangeListener {
        JButton menuItem;

        ActionChangedListener2(JButton jButton) {
            this.menuItem = jButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            }
        }
    }
}

