/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.parser;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.CSSParser;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.parser.DTDParser;
import com.totalvalidator.sgml.CData;
import com.totalvalidator.sgml.Data;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.SupportedDTDs;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.MyReader;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagParser {
    private static final char TAG_END = '>';
    private static final char TAG_START = '<';
    private static final String UTF16 = "UTF-16";
    private static final String UTF16LE = "UTF-16LE";
    private static final String FRAMESET = "frameset";
    private static final String SCRIPT = "script";
    private static final String STYLE = "style";
    private static final String MATH = "math";
    private static final String SVG = "svg";
    private static final String SCRIPT_ENDTAG = "</script>";
    private static final String STYLE_ENDTAG = "</style>";
    private static final String MATH_ENDTAG = "</math>";
    private static final String SVG_ENDTAG = "</svg>";
    private static final int SCRIPT_TYPE = 0;
    private static final int STYLE_TYPE = 1;
    private static final int MATH_TYPE = 2;
    private static final int SVG_TYPE = 3;
    private boolean inStyle;
    private int styleLines;
    private boolean inScript;
    private boolean inMath;
    private boolean inSvg;
    private Piece scriptTag;
    private Piece styleTag;
    private Piece mathTag;
    private Piece svgTag;
    char[] buffer = new char[9];
    private DTDParser parser;
    private String parserDocType;
    private boolean frameset;
    private boolean initialData = false;
    private boolean isXml;
    StringBuilder styleData;
    private boolean parseCss;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Piece> parseFile(MyReader myReader, boolean httpStream, DTDParser parserInput, boolean onDemand, FileUtils fileUtils, CommandLineParser clp, EntityEncoder ee) throws ValidationException {
        block138: {
            block143: {
                block153: {
                    block142: {
                        block128: {
                            block132: {
                                block141: {
                                    block151: {
                                        block129: {
                                            block130: {
                                                this.isXml = myReader.isXml();
                                                showWarnings = clp.isShowWarnings();
                                                ignoreMessages = clp.getIgnoreMessages();
                                                this.parseCss = clp.isCss();
                                                this.parser = parserInput;
                                                if (this.parser != null) {
                                                    this.parserDocType = this.parser.getOrigDocType();
                                                }
                                                pieces = new ArrayList<Piece>();
                                                debugCopy = null;
                                                if (GeneralUtils.LOGGER.isLoggable(Level.FINEST)) {
                                                    try {
                                                        debugCopy = new FileOutputStream(FileUtils.getDataFolder() + "DebugCopy.html");
                                                    }
                                                    catch (Exception e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                                src = null;
                                                i = -1;
                                                lineNumber = 1;
                                                this.styleLines = 0;
                                                charNumber = 0;
                                                withinTag = false;
                                                inComment = false;
                                                inCdata = false;
                                                inSpecial = false;
                                                inDoubleQuotes = false;
                                                inSingleQuotes = false;
                                                foundStart = false;
                                                foundEnd = false;
                                                newPiece = new StringBuilder();
                                                data = new StringBuilder();
                                                this.styleData = new StringBuilder();
                                                try {
                                                    try {
                                                        src = this.lookForBOM(myReader, clp, ee, pieces);
lbl35:
                                                        // 33 sources

                                                        while ((i = src.read()) != -1) {
                                                            block144: {
                                                                block145: {
                                                                    block146: {
                                                                        block147: {
                                                                            block133: {
                                                                                block148: {
                                                                                    c = (char)i;
                                                                                    ++charNumber;
                                                                                    if (debugCopy != null) {
                                                                                        debugCopy.write(i);
                                                                                    }
                                                                                    if (!httpStream && i == 0) {
                                                                                        i = src.read();
                                                                                        if (i == -1) break block128;
                                                                                        if (i == 0) {
                                                                                            i = src.read();
                                                                                            if (i == -1) break block128;
                                                                                            if (i == 0) {
                                                                                                GeneralUtils.LOGGER.severe("Three null characters found at " + lineNumber + ":" + charNumber);
                                                                                                var27_32 = null;
                                                                                                var36_52 = null;
                                                                                                if (debugCopy == null) break block129;
                                                                                                break block130;
                                                                                            }
                                                                                            src.unread(i);
                                                                                            src.unread(0);
                                                                                        } else {
                                                                                            src.unread(i);
                                                                                        }
                                                                                    }
                                                                                    if (c == '\n') {
                                                                                        ++lineNumber;
                                                                                        if (this.inStyle) {
                                                                                            ++this.styleLines;
                                                                                        }
                                                                                        charNumber = 0;
                                                                                    } else if (c == '\r') {
                                                                                        i = src.read();
                                                                                        if (i == -1) break block128;
                                                                                        if (i != 10) {
                                                                                            src.unread(i);
                                                                                        }
                                                                                        c = '\n';
                                                                                        ++lineNumber;
                                                                                        if (this.inStyle) {
                                                                                            ++this.styleLines;
                                                                                        }
                                                                                        charNumber = 0;
                                                                                    } else if (c == '\f' || c == '\t') {
                                                                                        c = ' ';
                                                                                    }
                                                                                    if (this.inScript) {
                                                                                        this.handleSpecial(0, c, pieces, lineNumber, ee, ignoreMessages, showWarnings);
                                                                                        continue;
                                                                                    }
                                                                                    if (this.inStyle) {
                                                                                        this.handleSpecial(1, c, pieces, lineNumber, ee, ignoreMessages, showWarnings);
                                                                                        continue;
                                                                                    }
                                                                                    if (this.inMath) {
                                                                                        this.handleSpecial(2, c, pieces, lineNumber, ee, ignoreMessages, showWarnings);
                                                                                        continue;
                                                                                    }
                                                                                    if (this.inSvg) {
                                                                                        this.handleSpecial(3, c, pieces, lineNumber, ee, ignoreMessages, showWarnings);
                                                                                        continue;
                                                                                    }
                                                                                    if ((inComment || inCdata || inSpecial) && !Character.isWhitespace(c)) {
                                                                                        if (inSpecial && c == '[' && newPiece.toString().equals("![CDATA")) {
                                                                                            inCdata = true;
                                                                                            inSpecial = false;
                                                                                        }
                                                                                        this.buffer[2] = this.buffer[1];
                                                                                        this.buffer[1] = this.buffer[0];
                                                                                        this.buffer[0] = c;
                                                                                    }
                                                                                    if (c == '>') {
                                                                                        if (inComment) {
                                                                                            if (this.buffer[2] != '-' || this.buffer[1] != '-') continue;
                                                                                            inComment = false;
                                                                                            withinTag = false;
                                                                                            newPiece = new StringBuilder();
                                                                                            continue;
                                                                                        }
                                                                                        if (inCdata) {
                                                                                            if (this.buffer[2] != ']' || this.buffer[1] != ']') continue;
                                                                                            inCdata = false;
                                                                                            withinTag = false;
                                                                                            cdataPiece = new CData(newPiece.toString(), lineNumber, ee, ignoreMessages, showWarnings);
                                                                                            pieces.add(cdataPiece);
                                                                                            newPiece = new StringBuilder();
                                                                                            data = new StringBuilder();
                                                                                            continue;
                                                                                        }
                                                                                        if (inSpecial) {
                                                                                            inSpecial = false;
                                                                                            withinTag = false;
                                                                                            tag = new Tag(newPiece.toString(), lineNumber, ee, ignoreMessages, showWarnings);
                                                                                            tag.setProblem(ValidationProblem.CONDITIONAL_COMMENT);
                                                                                            tag.setMalformed(1);
                                                                                            pieces.add(tag);
                                                                                            newPiece = new StringBuilder();
                                                                                            data = new StringBuilder();
                                                                                            this.specialTagCheck(tag);
                                                                                            continue;
                                                                                        }
                                                                                        tag = null;
                                                                                        if (!withinTag) {
                                                                                            if (data.length() == 0) {
                                                                                                tag = new Tag("", lineNumber, ee, ignoreMessages, showWarnings);
                                                                                                tag.setProblem(ValidationProblem.EXTRA_END_ERROR);
                                                                                                tag.setMalformed(5);
                                                                                            } else {
                                                                                                tag = new Tag(data.toString(), lineNumber, ee, ignoreMessages, showWarnings);
                                                                                                tag.setProblem(ValidationProblem.MISSING_START_ERROR);
                                                                                                tag.setMalformed(3);
                                                                                            }
                                                                                        } else {
                                                                                            if (inDoubleQuotes || inSingleQuotes) {
                                                                                                if (foundStart) {
                                                                                                    foundStart = false;
                                                                                                } else {
                                                                                                    foundEnd = true;
                                                                                                }
                                                                                                newPiece.append(c);
                                                                                                continue;
                                                                                            }
                                                                                            withinTag = false;
                                                                                            inSingleQuotes = false;
                                                                                            inDoubleQuotes = false;
                                                                                            tag = new Tag(newPiece.toString(), lineNumber, ee, ignoreMessages, showWarnings);
                                                                                            if (onDemand) {
                                                                                                onDemand = this.getParser(tag, fileUtils) == false;
                                                                                            }
                                                                                        }
                                                                                        pieces.add(tag);
                                                                                        newPiece = new StringBuilder();
                                                                                        data = new StringBuilder();
                                                                                        this.specialTagCheck(tag);
                                                                                        if (!tag.isEndTag() || (elementName = tag.getStrippedElement()) == null) continue;
                                                                                        matchingTag = null;
                                                                                        skipBlock = false;
                                                                                        break block132;
                                                                                    }
                                                                                    if (inComment || inCdata) {
                                                                                        newPiece.append(c);
                                                                                        continue;
                                                                                    }
                                                                                    if (c != 60) break block144;
                                                                                    if (withinTag) break block145;
                                                                                    if (data.length() > 0 && data.toString().trim().length() > 0 || this.initialData) {
                                                                                        dataPiece = new Data(data.toString(), lineNumber, ee, ignoreMessages, showWarnings);
                                                                                        pieces.add(dataPiece);
                                                                                        data = new StringBuilder();
                                                                                        this.initialData = false;
                                                                                    }
                                                                                    if ((one = src.read()) == -1) {
                                                                                        withinTag = true;
                                                                                        break block128;
                                                                                    }
                                                                                    first = (char)one;
                                                                                    if (first != '!') break block146;
                                                                                    two = src.read();
                                                                                    if (two == -1) {
                                                                                        newPiece.append(first);
                                                                                        withinTag = true;
                                                                                        break block128;
                                                                                    }
                                                                                    second = (char)two;
                                                                                    if (second == '[') {
                                                                                        inSpecial = true;
                                                                                        src.unread(two);
                                                                                        src.unread(one);
                                                                                        withinTag = true;
                                                                                        continue;
                                                                                    }
                                                                                    if (second != '-' && !Character.isWhitespace(second)) break block147;
                                                                                    inComment = true;
                                                                                    badComment = false;
                                                                                    comment = new StringBuilder();
                                                                                    for (j = 0; j < 9; ++j) {
                                                                                        this.buffer[j] = 65535;
                                                                                    }
                                                                                    if (second != '-') break block148;
                                                                                    three = src.read();
                                                                                    if (three == -1) {
                                                                                        newPiece.append(first);
                                                                                        newPiece.append(second);
                                                                                        withinTag = true;
                                                                                        break block128;
                                                                                    }
                                                                                    third = (char)three;
                                                                                    if (third == '-') {
                                                                                        newPiece.append(first);
                                                                                        newPiece.append(second);
                                                                                        newPiece.append(third);
                                                                                        withinTag = true;
                                                                                        break block133;
                                                                                    } else {
                                                                                        badComment = true;
                                                                                        comment.append(first).append(second).append(third == '\n' ? "\\n" : "" + third);
                                                                                        if (third == '\n') {
                                                                                            ++lineNumber;
                                                                                            charNumber = 0;
                                                                                            break block133;
                                                                                        } else {
                                                                                            src.unread(three);
                                                                                        }
                                                                                    }
                                                                                    break block133;
                                                                                }
                                                                                badComment = true;
                                                                                comment.append(first).append(second == '\n' ? "\\n" : "" + second);
                                                                                if (second == '\n') {
                                                                                    ++lineNumber;
                                                                                    charNumber = 0;
                                                                                }
                                                                            }
                                                                            if (!badComment) continue;
                                                                            dataPiece = new Data("<" + comment, lineNumber, ee, ignoreMessages, showWarnings);
                                                                            if (showWarnings) {
                                                                                dataPiece.setProblem(ValidationProblem.BAD_COMMENT);
                                                                            }
                                                                            dataPiece.setMalformed(1);
                                                                            pieces.add(dataPiece);
                                                                            continue;
                                                                        }
                                                                        src.unread(two);
                                                                        src.unread(one);
                                                                        withinTag = true;
                                                                        continue;
                                                                    }
                                                                    src.unread(one);
                                                                    withinTag = true;
                                                                    continue;
                                                                }
                                                                if (inDoubleQuotes || inSingleQuotes) {
                                                                    if (foundEnd || foundStart) {
                                                                        src.unread(60);
                                                                        inDoubleQuotes = false;
                                                                        inSingleQuotes = false;
                                                                        continue;
                                                                    }
                                                                    foundStart = true;
                                                                    newPiece.append(c);
                                                                    continue;
                                                                }
                                                                tag = null;
                                                                if (newPiece.length() == 0) {
                                                                    tag = new Tag("", lineNumber, ee, ignoreMessages, showWarnings);
                                                                    tag.setProblem(ValidationProblem.EXTRA_START_ERROR);
                                                                    tag.setMalformed(4);
                                                                } else {
                                                                    tag = new Tag(newPiece.toString(), lineNumber, ee, ignoreMessages, showWarnings);
                                                                    tag.setProblem(ValidationProblem.MISSING_END_ERROR);
                                                                    tag.setMalformed(2);
                                                                    this.specialTagCheck(tag);
                                                                }
                                                                pieces.add(tag);
                                                                newPiece = new StringBuilder();
                                                                data = new StringBuilder();
                                                                continue;
                                                            }
                                                            if (withinTag) {
                                                                newPiece.append(c);
                                                                if (inSpecial || inCdata) continue;
                                                                nxt = src.read();
                                                                if (nxt != -1) {
                                                                    next = (char)nxt;
                                                                    if (c == '\'' && next == '\'' || c == '\"' && next == '\"') {
                                                                        newPiece.append(next);
                                                                        ++charNumber;
                                                                        continue;
                                                                    }
                                                                    src.unread(nxt);
                                                                    if (inDoubleQuotes) {
                                                                        if (c != '\"') continue;
                                                                        inDoubleQuotes = false;
                                                                        continue;
                                                                    }
                                                                    if (inSingleQuotes) {
                                                                        if (c != '\'') continue;
                                                                        inSingleQuotes = false;
                                                                        continue;
                                                                    }
                                                                    if (c == '\"') {
                                                                        inDoubleQuotes = true;
                                                                        foundStart = false;
                                                                        foundEnd = false;
                                                                        continue;
                                                                    }
                                                                    if (c != '\'') continue;
                                                                    inSingleQuotes = true;
                                                                    foundStart = false;
                                                                    foundEnd = false;
                                                                    continue;
                                                                }
                                                                break block128;
                                                            }
                                                            data.append(c);
                                                        }
                                                        break block128;
                                                    }
                                                    catch (IOException e) {
                                                        block137: {
                                                            if (e.getMessage() == null) throw new ValidationException(e);
                                                            if (!e.getMessage().equalsIgnoreCase("Premature EOF")) {
                                                                throw new ValidationException(e);
                                                            }
                                                            var36_54 = null;
                                                            if (debugCopy != null) {
                                                                try {
                                                                    debugCopy.close();
                                                                }
                                                                catch (IOException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (src != null) {
                                                                try {
                                                                    try {
                                                                        if (httpStream) {
                                                                            while (src.read() != -1) {
                                                                            }
                                                                        }
                                                                        var40_66 = null;
                                                                    }
                                                                    catch (IOException e) {
                                                                        try {
                                                                            is = myReader.getInputStream();
                                                                            while (is.read() != -1) {
                                                                            }
                                                                        }
                                                                        catch (IOException e1) {
                                                                        }
                                                                        var40_67 = null;
                                                                        try {
                                                                            src.close();
                                                                        }
                                                                        catch (IOException e) {}
                                                                        break block137;
                                                                    }
                                                                }
                                                                catch (Throwable var39_94) {
                                                                    var40_68 = null;
                                                                    ** try [egrp 7[TRYBLOCK] [13 : 2350->2358)] { 
lbl351:
                                                                    // 1 sources

                                                                    src.close();
                                                                    throw var39_94;
lbl353:
                                                                    // 1 sources

                                                                    catch (IOException e) {
                                                                        // empty catch block
                                                                    }
                                                                    throw var39_94;
                                                                }
                                                                try {}
                                                                catch (IOException e) {}
                                                                src.close();
                                                            }
                                                        }
                                                        try {
                                                            myReader.getInputStream().close();
                                                        }
                                                        catch (IOException e) {}
                                                        break block138;
                                                    }
                                                }
                                                catch (Throwable var35_96) {
                                                    block140: {
                                                        block149: {
                                                            block139: {
                                                                var36_55 = null;
                                                                if (debugCopy != null) {
                                                                    ** try [egrp 3[TRYBLOCK] [7 : 2272->2280)] { 
lbl372:
                                                                    // 1 sources

                                                                    debugCopy.close();
                                                                    break block139;
lbl374:
                                                                    // 1 sources

                                                                    catch (IOException e) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                            }
                                                            if (src == null) break block140;
                                                            ** try [egrp 4[TRYBLOCK] [10 : 2287->2340)] { 
lbl379:
                                                            // 1 sources

                                                            ** try [egrp 5[TRYBLOCK] [8 : 2287->2303)] { 
lbl380:
                                                            // 1 sources

                                                            if (httpStream) {
                                                                while (src.read() != -1) {
                                                                }
                                                            }
                                                            break block149;
lbl384:
                                                            // 1 sources

                                                            catch (IOException e) {
                                                                block150: {
                                                                    ** try [egrp 6[TRYBLOCK] [9 : 2311->2332)] { 
lbl386:
                                                                    // 1 sources

                                                                    is = myReader.getInputStream();
                                                                    while (is.read() != -1) {
                                                                    }
                                                                    break block150;
lbl390:
                                                                    // 1 sources

                                                                    catch (IOException e1) {
                                                                    }
                                                                }
                                                                var40_70 = null;
                                                                try {}
                                                                catch (IOException e) {}
                                                                src.close();
                                                                break block140;
                                                            }
lbl399:
                                                            // 1 sources

                                                            catch (Throwable var39_95) {
                                                                var40_71 = null;
                                                                ** try [egrp 7[TRYBLOCK] [13 : 2350->2358)] { 
lbl403:
                                                                // 1 sources

                                                                src.close();
                                                                throw var39_95;
lbl405:
                                                                // 1 sources

                                                                catch (IOException e) {
                                                                    // empty catch block
                                                                }
                                                                throw var39_95;
                                                            }
                                                        }
                                                        var40_69 = null;
                                                        try {}
                                                        catch (IOException e) {}
                                                        src.close();
                                                    }
                                                    ** try [egrp 8[TRYBLOCK] [14 : 2362->2372)] { 
lbl416:
                                                    // 1 sources

                                                    myReader.getInputStream().close();
                                                    throw var35_96;
lbl418:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    throw var35_96;
                                                }
                                            }
                                            ** try [egrp 3[TRYBLOCK] [7 : 2272->2280)] { 
lbl423:
                                            // 1 sources

                                            debugCopy.close();
                                            break block129;
lbl425:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                        }
                                        if (src == null) break block141;
                                        ** try [egrp 4[TRYBLOCK] [10 : 2287->2340)] { 
lbl430:
                                        // 1 sources

                                        ** try [egrp 5[TRYBLOCK] [8 : 2287->2303)] { 
lbl431:
                                        // 1 sources

                                        if (httpStream) {
                                            while (src.read() != -1) {
                                            }
                                        }
                                        break block151;
lbl435:
                                        // 1 sources

                                        catch (IOException e) {
                                            block152: {
                                                ** try [egrp 6[TRYBLOCK] [9 : 2311->2332)] { 
lbl437:
                                                // 1 sources

                                                is = myReader.getInputStream();
                                                while (is.read() != -1) {
                                                }
                                                break block152;
lbl441:
                                                // 1 sources

                                                catch (IOException e1) {
                                                }
                                            }
                                            var40_61 = null;
                                            try {}
                                            catch (IOException e) {}
                                            src.close();
                                            break block141;
                                        }
lbl450:
                                        // 1 sources

                                        catch (Throwable var39_92) {
                                            var40_62 = null;
                                            ** try [egrp 7[TRYBLOCK] [13 : 2350->2358)] { 
lbl454:
                                            // 1 sources

                                            src.close();
                                            throw var39_92;
lbl456:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                            throw var39_92;
                                        }
                                    }
                                    var40_60 = null;
                                    try {}
                                    catch (IOException e) {}
                                    src.close();
                                }
                                ** try [egrp 8[TRYBLOCK] [14 : 2362->2372)] { 
lbl467:
                                // 1 sources

                                myReader.getInputStream().close();
                                return var27_32;
lbl469:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var27_32;
                            }
                            for (j = pieces.size() - 2; j >= 0; --j) {
                                oldTag = (Piece)pieces.get(j);
                                oldElement = oldTag.getStrippedElement();
                                if (oldElement == null) continue;
                                if (skipBlock) {
                                    if (oldTag != matchingTag) continue;
                                    matchingTag = null;
                                    skipBlock = false;
                                    continue;
                                }
                                if (oldTag.isEndTag() && oldTag.hasMatchingTag()) {
                                    matchingTag = oldTag.getMatchingTag();
                                    skipBlock = true;
                                    continue;
                                }
                                if (oldTag.isEndTag() || !elementName.equals(oldElement) || oldTag.hasMatchingTag() || oldTag.isSingleton()) continue;
                                oldTag.setMatchingTag(tag);
                                tag.setMatchingTag(oldTag);
                                ** GOTO lbl35
                            }
                            ** GOTO lbl35
                        }
                        var36_53 = null;
                        if (debugCopy != null) {
                            ** try [egrp 3[TRYBLOCK] [7 : 2272->2280)] { 
lbl495:
                            // 1 sources

                            debugCopy.close();
                            break block142;
lbl497:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (src == null) break block143;
                    ** try [egrp 4[TRYBLOCK] [10 : 2287->2340)] { 
lbl502:
                    // 1 sources

                    ** try [egrp 5[TRYBLOCK] [8 : 2287->2303)] { 
lbl503:
                    // 1 sources

                    if (httpStream) {
                        while (src.read() != -1) {
                        }
                    }
                    break block153;
lbl507:
                    // 1 sources

                    catch (IOException e) {
                        block154: {
                            ** try [egrp 6[TRYBLOCK] [9 : 2311->2332)] { 
lbl509:
                            // 1 sources

                            is = myReader.getInputStream();
                            while (is.read() != -1) {
                            }
                            break block154;
lbl513:
                            // 1 sources

                            catch (IOException e1) {
                            }
                        }
                        var40_64 = null;
                        try {}
                        catch (IOException e) {}
                        src.close();
                        break block143;
                    }
lbl522:
                    // 1 sources

                    catch (Throwable var39_93) {
                        var40_65 = null;
                        ** try [egrp 7[TRYBLOCK] [13 : 2350->2358)] { 
lbl526:
                        // 1 sources

                        src.close();
                        throw var39_93;
lbl528:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var39_93;
                    }
                }
                var40_63 = null;
                try {}
                catch (IOException e) {}
                src.close();
            }
            try {}
            catch (IOException e) {}
            myReader.getInputStream().close();
        }
        if (!withinTag) {
            if (data.length() <= 0) return pieces;
            if (data.toString().trim().length() <= 0) return pieces;
            dataPiece = new Data(data.toString(), lineNumber, ee, ignoreMessages, showWarnings);
            pieces.add(dataPiece);
            return pieces;
        }
        piece = null;
        if (newPiece.length() == 0) {
            piece = new Tag("", lineNumber, ee, ignoreMessages, showWarnings);
            piece.setProblem(ValidationProblem.EXTRA_START_ERROR);
            piece.setMalformed(4);
        } else if (inComment) {
            piece = new Data("<!--", lineNumber, ee, ignoreMessages, showWarnings);
            piece.setProblem(ValidationProblem.BAD_COMMENT_ERROR);
            piece.setMalformed(1);
        } else if (inCdata) {
            piece = new CData("<![CDATA[", lineNumber, ee, ignoreMessages, showWarnings);
            piece.setProblem(ValidationProblem.BAD_CDATA);
            piece.setMalformed(1);
        } else {
            piece = new Tag(newPiece.toString(), lineNumber, ee, ignoreMessages, showWarnings);
            piece.setProblem(ValidationProblem.MISSING_END_ERROR);
            piece.setMalformed(2);
            this.specialTagCheck(piece);
        }
        pieces.add(piece);
        return pieces;
    }

    private PushbackReader lookForBOM(MyReader myReader, CommandLineParser clp, EntityEncoder ee, List<Piece> pieces) throws IOException {
        Data dataPiece;
        String httpCharset;
        boolean showWarnings = clp.isShowWarnings();
        List<String> ignoreMessages = clp.getIgnoreMessages();
        boolean foundBOM = false;
        InputStream is = myReader.getInputStream();
        int[] bombuffer = new int[4];
        for (int i = 0; i < bombuffer.length; ++i) {
            bombuffer[i] = -1;
        }
        bombuffer[0] = is.read();
        bombuffer[1] = is.read();
        boolean readFourBytes = false;
        if (bombuffer[0] == 254 && bombuffer[1] == 255) {
            foundBOM = true;
            httpCharset = clp.getHttpCharset();
            if (httpCharset != null) {
                if (!httpCharset.equalsIgnoreCase(UTF16) && !httpCharset.equalsIgnoreCase("UTF-16BE")) {
                    dataPiece = new Data("", 1, ee, ignoreMessages, showWarnings);
                    dataPiece.setProblem(new ValidationProblem("The BOM specifies a character set of UTF16, but the 'content-type' HTTP header specifies " + httpCharset, ValidationProblem.BOM_MISMATCH));
                    pieces.add(dataPiece);
                }
            } else {
                myReader.setCharset(UTF16);
                GeneralUtils.LOGGER.info("Modified character set to: UTF16");
                clp.setBomCharset(UTF16);
            }
        } else if (bombuffer[0] == 255 && bombuffer[1] == 254) {
            foundBOM = true;
            httpCharset = clp.getHttpCharset();
            if (httpCharset != null) {
                if (!httpCharset.equalsIgnoreCase(UTF16) && !httpCharset.equalsIgnoreCase(UTF16LE)) {
                    dataPiece = new Data("", 1, ee, ignoreMessages, showWarnings);
                    dataPiece.setProblem(new ValidationProblem("The BOM specifies a character set of UTF16LE, but the 'content-type' HTTP header specifies " + httpCharset, ValidationProblem.BOM_MISMATCH));
                    pieces.add(dataPiece);
                }
            } else {
                myReader.setCharset(UTF16LE);
                GeneralUtils.LOGGER.info("Modified character set to: UTF16LE");
                clp.setBomCharset(UTF16LE);
            }
        } else if (bombuffer[0] == 239 && bombuffer[1] == 187) {
            bombuffer[2] = is.read();
            bombuffer[3] = is.read();
            readFourBytes = true;
            if (bombuffer[2] == 191) {
                foundBOM = true;
                httpCharset = clp.getHttpCharset();
                if (httpCharset != null) {
                    if (!httpCharset.equalsIgnoreCase("UTF-8")) {
                        dataPiece = new Data("", 1, ee, ignoreMessages, showWarnings);
                        dataPiece.setProblem(new ValidationProblem("The BOM specifies a character set of UTF8, but the 'content-type' HTTP header specifies " + httpCharset, ValidationProblem.BOM_MISMATCH));
                        pieces.add(dataPiece);
                    }
                } else {
                    myReader.setCharset("UTF-8");
                    GeneralUtils.LOGGER.info("Modified character set to: UTF8");
                    clp.setBomCharset("UTF-8");
                }
            }
        }
        PushbackReader src = null;
        if (!foundBOM) {
            int i;
            if (bombuffer[0] != 60) {
                this.initialData = true;
            }
            if (!myReader.haveCharset()) {
                char ch;
                myReader.convertToBuffer();
                String charset = null;
                i = -1;
                is = myReader.getInputStream();
                while (!((i = is.read()) == -1 || (ch = (char)i) == '<' && "?xml".equalsIgnoreCase(this.getNextChars(is, 4)) && (charset = this.getCharset(is, "ENCODING", false)) != null)) {
                }
                myReader.resetBuffer();
                if (charset == null) {
                    i = -1;
                    is = myReader.getInputStream();
                    while (!((i = is.read()) == -1 || (ch = (char)i) == '<' && "meta".equalsIgnoreCase(this.getNextChars(is, 4)) && (charset = this.getCharset(is, "CHARSET", true)) != null)) {
                    }
                    myReader.resetBuffer();
                }
                if (charset != null) {
                    myReader.setCharset(charset);
                    GeneralUtils.LOGGER.info("Modified character set to: " + charset);
                    clp.setOtherCharset(charset);
                }
            }
            src = new PushbackReader(new BufferedReader(myReader.getReader()), 9);
            String httpCharset2 = clp.getHttpCharset();
            if (httpCharset2 != null && (httpCharset2.equalsIgnoreCase(UTF16) || httpCharset2.equalsIgnoreCase("UTF-16BE") || httpCharset2.equalsIgnoreCase(UTF16LE))) {
                for (i = bombuffer.length - 1; i > -1; i -= 2) {
                    if (bombuffer[i] == -1) continue;
                    int j = bombuffer[i] << 4;
                    src.unread(j += bombuffer[i + 1]);
                }
            } else {
                for (i = bombuffer.length - 1; i > -1; --i) {
                    if (bombuffer[i] == -1) continue;
                    src.unread(bombuffer[i]);
                }
            }
        } else {
            src = new PushbackReader(new BufferedReader(myReader.getReader()), 9);
            if (readFourBytes) {
                src.unread(bombuffer[3]);
            }
        }
        return src;
    }

    private String getCharset(InputStream is, String attribute, boolean meta) throws IOException {
        String tagContents;
        char ch;
        int i = -1;
        StringBuilder sb = new StringBuilder();
        while ((i = is.read()) != -1 && (ch = (char)i) != '>') {
            sb.append(ch);
        }
        if (sb.length() == 0) {
            return null;
        }
        if (meta && (tagContents = sb.toString().toLowerCase(Locale.ENGLISH)).indexOf("charset") == -1 && (tagContents.indexOf("http-equiv") == -1 || tagContents.indexOf("content-type") == -1)) {
            return null;
        }
        String charset = FileUtils.getCharset(sb.toString(), attribute);
        if (charset != null) {
            try {
                if (!Charset.isSupported(charset)) {
                    charset = null;
                }
            }
            catch (IllegalCharsetNameException e) {
                charset = null;
            }
        }
        return charset;
    }

    private String getNextChars(InputStream is, int size) throws IOException {
        byte[] bytes = new byte[size];
        is.read(bytes);
        String s = new String(bytes);
        return s;
    }

    private void handleSpecial(int type, char c, List<Piece> pieces, int lineNumber, EntityEncoder ee, List<String> ignoreMessages, boolean showWarnings) {
        Piece specialTag = null;
        String endTag = null;
        switch (type) {
            case 0: {
                specialTag = this.scriptTag;
                endTag = SCRIPT_ENDTAG;
                break;
            }
            case 1: {
                specialTag = this.styleTag;
                endTag = STYLE_ENDTAG;
                break;
            }
            case 2: {
                specialTag = this.mathTag;
                endTag = MATH_ENDTAG;
                break;
            }
            case 3: {
                specialTag = this.svgTag;
                endTag = SVG_ENDTAG;
            }
        }
        int bufferLen = endTag.length() - 1;
        if (!Character.isWhitespace(c)) {
            for (int j = 0; j < bufferLen; ++j) {
                this.buffer[j] = this.buffer[j + 1];
            }
            this.buffer[bufferLen] = c;
            if (endTag.equals(new String(this.buffer, 0, bufferLen + 1).toLowerCase(Locale.ENGLISH))) {
                String styleDataStr;
                if (type == 1 && this.parseCss && (styleDataStr = this.styleData.substring(0, this.styleData.length() - bufferLen)).trim().length() > 0) {
                    List<Piece> cssPieces = new CSSParser().parseCSS(styleDataStr, lineNumber - this.styleLines, ignoreMessages, showWarnings);
                    pieces.addAll(cssPieces);
                    this.styleData = new StringBuilder();
                }
                Tag tag = new Tag(new String(this.buffer, 1, bufferLen - 1), lineNumber, ee, ignoreMessages, showWarnings);
                pieces.add(tag);
                specialTag.setMatchingTag(tag);
                tag.setMatchingTag(specialTag);
                switch (type) {
                    case 0: {
                        this.inScript = false;
                        break;
                    }
                    case 1: {
                        this.inStyle = false;
                        break;
                    }
                    case 2: {
                        this.inMath = false;
                        break;
                    }
                    case 3: {
                        this.inSvg = false;
                    }
                }
            } else if (type == 1) {
                this.styleData.append(c);
            }
        } else if (type == 1) {
            this.styleData.append(c);
        }
    }

    private void specialTagCheck(Piece piece) {
        String element = piece.getStrippedElement();
        if (!(element == null || !element.equals(SCRIPT) || piece.isSingleton() || this.inStyle || this.inMath || this.inSvg)) {
            if (piece.isEndTag()) {
                this.inScript = false;
            } else if (!this.inScript) {
                this.inScript = true;
                this.scriptTag = piece;
                for (int j = 0; j < 9; ++j) {
                    this.buffer[j] = 65535;
                }
            }
        } else if (!(element == null || !element.equals(STYLE) || piece.isSingleton() || this.inScript || this.inMath || this.inSvg)) {
            if (piece.isEndTag()) {
                this.inStyle = false;
            } else if (!this.inStyle) {
                this.inStyle = true;
                this.styleLines = 0;
                this.styleTag = piece;
                for (int j = 0; j < 9; ++j) {
                    this.buffer[j] = 65535;
                }
            }
        } else if (!(element == null || !element.equals(MATH) || piece.isSingleton() || this.inScript || this.inStyle || this.inSvg)) {
            if (piece.isEndTag()) {
                this.inMath = false;
            } else if (!this.inMath) {
                this.inMath = true;
                this.mathTag = piece;
                for (int j = 0; j < 9; ++j) {
                    this.buffer[j] = 65535;
                }
            }
        } else if (!(element == null || !element.equals(SVG) || piece.isSingleton() || this.inScript || this.inMath || this.inStyle)) {
            if (piece.isEndTag()) {
                this.inSvg = false;
            } else if (!this.inSvg) {
                this.inSvg = true;
                this.svgTag = piece;
                for (int j = 0; j < 9; ++j) {
                    this.buffer[j] = 65535;
                }
            }
        } else if (element != null && element.equals(FRAMESET) && !piece.isEndTag()) {
            this.frameset = true;
        }
    }

    private boolean getParser(Tag tag, FileUtils fileUtils) throws ValidationException {
        if (tag.getStrippedElement() != null && tag.getStrippedElement().equals("?xml")) {
            this.isXml = true;
        } else if (tag.getStrippedElement() != null && tag.getStrippedElement().equals("!doctype")) {
            Map<String, RealAttribute> attributes = tag.getAttributes();
            if (attributes != null) {
                for (RealAttribute attr : attributes.values()) {
                    InputStream dtd;
                    String val = attr.getValue();
                    if (attributes.size() == 1 && attributes.containsKey("html")) {
                        val = "about:legacy-compat";
                    }
                    if (!val.startsWith("-//") && !val.startsWith("ISO/IEC") && !val.startsWith("about:")) continue;
                    if (val.equalsIgnoreCase(this.parserDocType)) {
                        return true;
                    }
                    String dtdName = SupportedDTDs.getDTDFromDocType(val);
                    if (dtdName == null) {
                        tag.setProblem(ValidationProblem.UNRECOGNISED_DTD);
                        return false;
                    }
                    if ("dtds/5.0/html5.dtd".equals(dtdName) && this.isXml) {
                        dtdName = "dtds/5.0/xhtml5.dtd";
                    }
                    if ((dtd = fileUtils.getInputStream(FileUtils.getInstallationFolder() + dtdName + ".object")) == null) continue;
                    this.parserDocType = val;
                    this.parser = DTDParser.getParser(dtd, dtdName);
                    return true;
                }
            }
            tag.setProblem(ValidationProblem.UNRECOGNISED_DTD);
        }
        return false;
    }

    public DTDParser getParser() {
        if (this.parserDocType == null && this.parser.getOrigDocType() == null) {
            this.parser = null;
        }
        return this.parser;
    }

    public String getParserDocType() {
        return this.parserDocType;
    }

    public boolean isFrameset() {
        return this.frameset;
    }
}

