/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.parser;

import com.totalvalidator.sgml.CSSPiece;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSParser {
    private static final char DASH = '-';
    private static final char TAG_END = '>';
    private static final char SLASH = '/';
    private static final char STAR = '*';
    private static final char BANG = '!';
    private static final char TAG_START = '<';
    private static final char QUOTE = '\'';
    private static final char DBL_QUOTE = '\"';
    private static final char BACK_SLASH = '\\';
    private static final char AT = '@';
    private static final char BLOCK_START = '{';
    private static final char BLOCK_END = '}';
    private static final char AT_END = ';';
    private static final char SPACE = ' ';
    private static final char NL = '\n';

    List<Piece> parseCSS(String cssData, int lineNumber, List<String> ignoreMessages, boolean showWarnings) {
        CSSPiece cssPiece;
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        boolean inComment = false;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inAtRule = false;
        boolean inBlock = false;
        boolean inStatement = false;
        int blockCount = 0;
        StringBuilder newPiece = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        cssData = this.trimEnd(cssData);
        char[] chars = cssData.toCharArray();
        int dataLength = chars.length;
        for (int i = 0; i < dataLength; ++i) {
            if (chars[i] == '\n') {
                ++lineNumber;
                if (!inStatement) continue;
                newPiece.append(' ');
                continue;
            }
            if (inComment) {
                if (chars[i] == '*' && i + 1 < dataLength && chars[i + 1] == '/') {
                    buffer = new StringBuilder();
                    newPiece.append(' ');
                    inComment = false;
                    continue;
                }
                buffer.append(chars[i]);
                continue;
            }
            if (Character.isWhitespace(chars[i])) {
                if (!inStatement) continue;
                newPiece.append(' ');
                continue;
            }
            if (!inStatement && chars[i] == '-' && i + 2 < dataLength && chars[i + 1] == '-' && chars[i + 2] == '>') {
                i += 2;
                continue;
            }
            if (!inStatement && chars[i] == '<' && i + 3 < dataLength && chars[i + 1] == '!' && chars[i + 2] == '-' && chars[i + 3] == '-') {
                i += 3;
                continue;
            }
            if (inSingleQuotes) {
                newPiece.append(chars[i]);
                if (chars[i] != '\'' || chars[i - 1] == '\\') continue;
                inSingleQuotes = false;
                continue;
            }
            if (inDoubleQuotes) {
                newPiece.append(chars[i]);
                if (chars[i] != '\"' || chars[i - 1] == '\\') continue;
                inDoubleQuotes = false;
                continue;
            }
            if (chars[i] == '/' && i + 1 < dataLength && chars[i + 1] == '*') {
                buffer = new StringBuilder();
                buffer.append('/').append('*');
                inComment = true;
                ++i;
                continue;
            }
            if (inBlock) {
                newPiece.append(chars[i]);
                if (chars[i] == '\'' && chars[i - 1] != '\\') {
                    inSingleQuotes = true;
                    continue;
                }
                if (chars[i] == '\"' && chars[i - 1] != '\\') {
                    inDoubleQuotes = true;
                    continue;
                }
                if (chars[i] == '}') {
                    if (--blockCount != 0) continue;
                    cssPiece = new CSSPiece(true, newPiece.toString().trim(), lineNumber, ignoreMessages, showWarnings);
                    pieces.add(cssPiece);
                    newPiece = new StringBuilder();
                    inBlock = false;
                    inAtRule = false;
                    inStatement = false;
                    continue;
                }
                if (chars[i] != '{') continue;
                ++blockCount;
                continue;
            }
            if (inAtRule) {
                newPiece.append(chars[i]);
                if (chars[i] == '\'' && chars[i - 1] != '\\') {
                    inSingleQuotes = true;
                    continue;
                }
                if (chars[i] == '\"' && chars[i - 1] != '\\') {
                    inDoubleQuotes = true;
                    continue;
                }
                if (chars[i] == ';') {
                    cssPiece = new CSSPiece(true, newPiece.toString().trim(), lineNumber, ignoreMessages, showWarnings);
                    pieces.add(cssPiece);
                    newPiece = new StringBuilder();
                    inAtRule = false;
                    inStatement = false;
                    continue;
                }
                if (chars[i] != '{') continue;
                inBlock = true;
                inStatement = true;
                blockCount = 1;
                continue;
            }
            if (chars[i] == '{') {
                newPiece.append(chars[i]);
                inBlock = true;
                inStatement = true;
                blockCount = 1;
                continue;
            }
            if (inStatement) {
                newPiece.append(chars[i]);
                continue;
            }
            newPiece.append(chars[i]);
            inStatement = true;
            if (chars[i] != '@') continue;
            inAtRule = true;
        }
        String remainder = newPiece.toString() + buffer.toString();
        remainder = remainder.trim();
        if (inComment) {
            cssPiece = new CSSPiece(false, remainder, lineNumber, ignoreMessages, showWarnings);
            cssPiece.setProblem(ValidationProblem.BAD_CSS_COMMENT_ERROR);
            cssPiece.setMalformed(1);
            pieces.add(cssPiece);
        } else if (inSingleQuotes || inDoubleQuotes) {
            cssPiece = new CSSPiece(false, remainder, lineNumber, ignoreMessages, showWarnings);
            cssPiece.setProblem(ValidationProblem.MISSING_CSS_QUOTE);
            cssPiece.setMalformed(1);
            pieces.add(cssPiece);
        } else if (inBlock) {
            cssPiece = new CSSPiece(false, remainder, lineNumber, ignoreMessages, showWarnings);
            cssPiece.setProblem(ValidationProblem.MISSING_BLOCK_END);
            cssPiece.setMalformed(1);
            pieces.add(cssPiece);
        } else if (remainder.length() > 0) {
            cssPiece = new CSSPiece(true, remainder, lineNumber, ignoreMessages, showWarnings);
            pieces.add(cssPiece);
        }
        return pieces;
    }

    private String trimEnd(String cssData) {
        StringBuilder sb = new StringBuilder();
        boolean foundEnd = false;
        char[] chars = cssData.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            if (!foundEnd && Character.isWhitespace(chars[i])) continue;
            foundEnd = true;
            sb.insert(0, chars[i]);
        }
        return sb.toString();
    }
}

