/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.ProxyDetails;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyAuthenticator
extends Authenticator {
    private Map<String, PasswordAuthentication> proxyAuths = new HashMap<String, PasswordAuthentication>();
    private Map<String, Map<String, PasswordAuthentication>> serverAuths = new HashMap<String, Map<String, PasswordAuthentication>>();

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication auth = null;
        String host = this.getRequestingHost();
        if (host == null) {
            host = "";
        }
        if (this.getRequestorType() == Authenticator.RequestorType.SERVER) {
            Map<String, PasswordAuthentication> authList;
            String realm = this.getRequestingPrompt();
            String hostRealm = host;
            if (realm != null) {
                hostRealm = hostRealm + realm;
            }
            if ((authList = this.serverAuths.get(hostRealm)) != null) {
                auth = this.getServerAuth(authList, hostRealm);
            } else if (realm != null && realm.length() > 0 && host.length() > 0 && (authList = this.serverAuths.get(hostRealm = host)) != null) {
                auth = this.getServerAuth(authList, hostRealm);
            }
            if (auth == null && (authList = this.serverAuths.get(hostRealm = "")) != null) {
                auth = this.getServerAuth(authList, hostRealm);
            }
        } else {
            auth = this.proxyAuths.get(host);
            if (auth == null) {
                host = "";
                this.proxyAuths.get(host);
            }
            GeneralUtils.LOGGER.info("Retrieving proxy authentication for " + host + " and got " + auth);
        }
        return auth;
    }

    private PasswordAuthentication getServerAuth(Map<String, PasswordAuthentication> authList, String hostRealm) {
        PasswordAuthentication auth = null;
        URL url = this.getRequestingURL();
        String path = "";
        if (url != null) {
            path = this.getFolder(url.getPath());
        }
        if ((auth = authList.get(path)) == null && path.length() > 0) {
            path = "";
            auth = authList.get(path);
        }
        GeneralUtils.LOGGER.info("Retrieving server authentication for " + hostRealm + " : " + path + " and got " + auth);
        return auth;
    }

    public void addServerAuthentication(String userName, String password, String urlString, String realm) {
        if (userName != null) {
            PasswordAuthentication auth = new PasswordAuthentication(userName, password.toCharArray());
            URL url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                url = null;
            }
            String hostRealm = "";
            if (url != null) {
                hostRealm = url.getHost();
            }
            if (realm != null) {
                if (realm.startsWith("Realm: ")) {
                    realm = realm.substring(7);
                }
                hostRealm = hostRealm + realm;
            }
            String path = "";
            Map<String, PasswordAuthentication> authList = this.serverAuths.get(hostRealm);
            if (authList == null) {
                authList = new HashMap<String, PasswordAuthentication>();
            }
            authList.put(path, auth);
            if (url != null && (path = this.getFolder(url.getPath())).length() > 0) {
                authList.put(path, auth);
            }
            this.serverAuths.put(hostRealm, authList);
            GeneralUtils.LOGGER.info("Stored server authentication for " + hostRealm + " : " + path + " : " + auth);
        }
    }

    private String getFolder(String path) {
        int index = path.lastIndexOf(47);
        if (index != -1) {
            path = path.substring(0, index);
        }
        return path;
    }

    public void addProxyAuthentication(ProxyDetails proxyDetails) {
        if (proxyDetails == null) {
            return;
        }
        String userName = proxyDetails.getUserName();
        if (userName.length() > 0) {
            PasswordAuthentication auth = new PasswordAuthentication(userName, proxyDetails.getPassword().toCharArray());
            String host = proxyDetails.getHost();
            this.proxyAuths.put(host, auth);
            GeneralUtils.LOGGER.info("Stored proxy authentication for " + host + " : " + auth);
        }
    }
}

