/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.utils.Cookie;
import com.totalvalidator.utils.CookieCache;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCookieHandler
extends CookieHandler {
    public static final String ACCEPT_NONE = "ACCEPT_NONE";
    public static final String ACCEPT_ALL = "ACCEPT_ALL";
    public static final String ACCEPT_SESSION = "ACCEPT_SESSION";
    public static final String ACCEPT_ORIGINAL_SERVER = "ACCEPT_SERVER";
    private static String[] cookiePolicies = new String[]{"Accept all", "Original server only", "Session only", "Accept none"};
    public static final String CACHE_NONE = "CACHE_NONE";
    public static final String CACHE_ALL = "CACHE_ALL";
    public static final String CACHE_PERMANENT = "CACHE_PERMANENT";
    private static String[] cachePolicies = new String[]{"All", "Permanent", "None"};
    public static final String SEND_NONE = "SEND_NONE";
    public static final String SEND_ALL = "SEND_ALL";
    public static final String SEND_PERMANENT = "SEND_PERMANENT";
    private static String[] sendPolicies = new String[]{"All", "Permanent", "None"};
    private static final String COOKIE_CACHE = "cookiecache.object";
    private CookieCache cookieCache;
    private String cookiePolicy = "ACCEPT_SERVER";
    private String cachePolicy = "CACHE_PERMANENT";
    public static Map<String, String> cookiePolicyMap = new HashMap<String, String>();
    public static Map<String, String> cachePolicyMap;
    public static Map<String, String> sendPolicyMap;

    public MyCookieHandler(String cookiePolicy, String cachePolicy, String sendPolicy, List<String> cookies, String url) {
        this.cachePolicy = cachePolicy;
        GeneralUtils.LOGGER.fine("cookiePolicy:" + cookiePolicy);
        GeneralUtils.LOGGER.fine("cachePolicy:" + cachePolicy);
        GeneralUtils.LOGGER.fine("sendPolicy:" + sendPolicy);
        if (sendPolicy.equals(SEND_NONE)) {
            this.cookieCache = new CookieCache();
        } else {
            this.cookieCache = MyCookieHandler.deserialise();
            if (sendPolicy.equals(SEND_PERMANENT)) {
                for (Cookie cookie : this.cookieCache.getCookies()) {
                    if (cookie.getMaxAge() != -1L) continue;
                    cookie.setMaxAge(0L);
                }
            }
        }
        try {
            URI uri = new URI(url);
            this.cookiePolicy = ACCEPT_ALL;
            for (String cookieString : cookies) {
                try {
                    List<Cookie> cookieList = Cookie.parse(cookieString);
                    for (Cookie cookie : cookieList) {
                        if (!this.checkCookiePolicy(cookie, uri)) continue;
                        GeneralUtils.LOGGER.fine("Storing cookie: " + cookie);
                        this.cookieCache.add(uri, cookie);
                    }
                }
                catch (IllegalArgumentException e) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Invalid cookie", e);
                }
            }
        }
        catch (URISyntaxException e1) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "URI Syntax error", e1);
        }
        this.cookiePolicy = cookiePolicy;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        HashMap<String, List<String>> cookieMap = new HashMap<String, List<String>>();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookieCache.get2(uri)) {
            if (!this.pathMatches(uri.getPath(), cookie.getPath())) continue;
            cookies.add(cookie);
            GeneralUtils.LOGGER.fine("Using cookie: " + cookie);
        }
        List<String> cookieHeader = this.sortByPath(cookies);
        cookieMap.put("Cookie", cookieHeader);
        return Collections.unmodifiableMap(cookieMap);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        for (String headerKey : responseHeaders.keySet()) {
            if (headerKey == null || !headerKey.equalsIgnoreCase("Set-Cookie2") && !headerKey.equalsIgnoreCase("Set-Cookie")) continue;
            for (String headerValue : responseHeaders.get(headerKey)) {
                try {
                    List<Cookie> cookies = Cookie.parse(headerValue);
                    for (Cookie cookie : cookies) {
                        if (!this.checkCookiePolicy(cookie, uri)) continue;
                        GeneralUtils.LOGGER.fine("Storing cookie: " + cookie);
                        this.cookieCache.add(uri, cookie);
                    }
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void serialise(CookieCache cookieCache) {
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new FileOutputStream(FileUtils.getDataFolder() + COOKIE_CACHE));
        oos.writeObject(cookieCache);
        oos.flush();
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static CookieCache deserialise() {
        ois = null;
        cookieCache = null;
        oldFile = false;
        try {
            ois = new ObjectInputStream(new FileInputStream(FileUtils.getDataFolder() + "cookiecache.object"));
        }
        catch (Exception e) {
            try {
                ois = new ObjectInputStream(new FileInputStream(FileUtils.getInstallationFolder() + "cookiecache.object"));
                oldFile = true;
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (ois != null) {
            block20: {
                try {
                    cookieCache = (CookieCache)ois.readObject();
                    var6_7 = null;
                    ** if (ois == null) goto lbl-1000
                }
                catch (Throwable var5_13) {
                    var6_9 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    throw var5_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        ois.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block20;
                    catch (Exception e1) {
                        GeneralUtils.LOGGER.fine("Existing cookie cache unreadable - Creating new one");
                        cookieCache = new CookieCache();
                        var6_8 = null;
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (oldFile && (GeneralUtils.isMacOSX() || GeneralUtils.isWinNT())) {
                try {
                    FileUtils.deleteFile(new File(FileUtils.getInstallationFolder() + "cookiecache.object"), false);
                }
                catch (IOException var3_5) {
                    // empty catch block
                }
            }
        }
        if (cookieCache == null) {
            GeneralUtils.LOGGER.fine("Existing cookie cache not found - Creating new one");
            cookieCache = new CookieCache();
        }
        return cookieCache;
    }

    private boolean checkCookiePolicy(Cookie cookie, URI uri) {
        if (this.cookiePolicy.equals(ACCEPT_ALL)) {
            return true;
        }
        if (this.cookiePolicy.equals(ACCEPT_NONE)) {
            return false;
        }
        if (this.cookiePolicy.equals(ACCEPT_SESSION)) {
            return cookie.getMaxAge() == -1L;
        }
        if (cookie.getDomain() == null) {
            return true;
        }
        return Cookie.domainMatches(cookie.getDomain(), uri.getHost());
    }

    private boolean pathMatches(String path, String pathToMatchWith) {
        if (path == pathToMatchWith) {
            return true;
        }
        if (path == null || pathToMatchWith == null) {
            return false;
        }
        return path.startsWith(pathToMatchWith);
    }

    private List<String> sortByPath(List<Cookie> cookies) {
        Collections.sort(cookies, new CookiePathComparator());
        ArrayList<String> cookieHeader = new ArrayList<String>();
        for (Cookie cookie : cookies) {
            if (cookies.indexOf(cookie) == 0 && cookie.getVersion() > 0) {
                cookieHeader.add("$Version=\"1\"");
            }
            cookieHeader.add(cookie.toString());
        }
        return cookieHeader;
    }

    public static String[] getCookiePolicies() {
        return cookiePolicies;
    }

    public static String getCookiePolicy(String cookiePolicy) {
        return cookiePolicyMap.get(cookiePolicy);
    }

    public static String getCachePolicy(String cachePolicy) {
        return cachePolicyMap.get(cachePolicy);
    }

    public static String getSendPolicy(String sendPolicy) {
        return sendPolicyMap.get(sendPolicy);
    }

    public static String getDisplayName(Map<String, String> policyMap, String policyName) {
        String displayName = null;
        for (String name : policyMap.keySet()) {
            if (!policyName.equals(policyMap.get(name))) continue;
            displayName = name;
            break;
        }
        return displayName;
    }

    public static String[] getCachePolicies() {
        return cachePolicies;
    }

    public static String[] getSendPolicies() {
        return sendPolicies;
    }

    public void finish() {
        if (!this.cachePolicy.equals(CACHE_NONE)) {
            if (this.cachePolicy.equals(CACHE_PERMANENT)) {
                for (Cookie cookie : this.cookieCache.getCookies()) {
                    if (cookie.getMaxAge() != -1L) continue;
                    cookie.setMaxAge(0L);
                }
            }
            CookieCache diskCache = MyCookieHandler.deserialise();
            List<Object> domains = this.cookieCache.getDomains();
            for (Object obj : domains) {
                String domain = (String)obj;
                List<Cookie> cookies = this.cookieCache.get(domain);
                for (Cookie cookie : cookies) {
                    diskCache.add(domain, cookie);
                }
            }
            List<Object> uris = this.cookieCache.getURIs();
            for (Object obj : uris) {
                URI uri = (URI)obj;
                List<Cookie> cookies = this.cookieCache.get(uri);
                for (Cookie cookie : cookies) {
                    diskCache.add(uri, cookie);
                }
            }
            MyCookieHandler.serialise(diskCache);
        }
    }

    static {
        cookiePolicyMap.put(cookiePolicies[0], ACCEPT_ALL);
        cookiePolicyMap.put(cookiePolicies[1], ACCEPT_ORIGINAL_SERVER);
        cookiePolicyMap.put(cookiePolicies[2], ACCEPT_SESSION);
        cookiePolicyMap.put(cookiePolicies[3], ACCEPT_NONE);
        cachePolicyMap = new HashMap<String, String>();
        cachePolicyMap.put(cachePolicies[0], CACHE_ALL);
        cachePolicyMap.put(cachePolicies[1], CACHE_PERMANENT);
        cachePolicyMap.put(cachePolicies[2], CACHE_NONE);
        sendPolicyMap = new HashMap<String, String>();
        sendPolicyMap.put(sendPolicies[0], SEND_ALL);
        sendPolicyMap.put(sendPolicies[1], SEND_PERMANENT);
        sendPolicyMap.put(sendPolicies[2], SEND_NONE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CookiePathComparator
    implements Comparator<Cookie> {
        CookiePathComparator() {
        }

        @Override
        public int compare(Cookie c1, Cookie c2) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            if (!c1.getName().equals(c2.getName())) {
                return 0;
            }
            if (c1.getPath().startsWith(c2.getPath())) {
                return -1;
            }
            if (c2.getPath().startsWith(c1.getPath())) {
                return 1;
            }
            return 0;
        }
    }
}

