/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;

public class Molecule3D
extends Applet
implements Serializable,
Runnable {
    private MVMolecule molecule = null;
    private File moleculeFile;
    private transient Image backImage;
    private Dimension backImageSize;
    private boolean lock;
    private int spinSpeed;
    private transient Thread motor;

    public Molecule3D() {
        this.setMoleculeFile(null);
        this.enableEvents(48L);
        this.backImageSize = new Dimension(0, 0);
        this.setRotationLock(false);
        this.setSpinSpeed(0);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Application Wrapper");
        ((Component)frame).setSize(300, 300);
        Molecule3D molecule3D = new Molecule3D();
        frame.add(molecule3D);
        ((Component)frame).setVisible(true);
        molecule3D.setColor(true);
        molecule3D.setLabel(true);
        molecule3D.setMoleculeFile(new File("models", "cyclohexane.xyz"));
        molecule3D.setSpinSpeed(2);
    }

    public void setMoleculeFile(File file) {
        this.stop();
        MVMolecule mVMolecule = null;
        MVReadData mVReadData = new MVReadData();
        mVMolecule = file == null ? MVReadData.createDataSet(this.molecule) : mVReadData.readDataSet(file, this.molecule);
        if (mVMolecule != null) {
            this.molecule = mVMolecule;
            this.molecule.autoBond();
            this.moleculeFile = file;
        }
        this.redraw();
        this.start();
    }

    public File getMoleculeFile() {
        return this.moleculeFile;
    }

    public void setShade(boolean bl) {
        this.molecule.setDisplayMode("Shade", bl);
        this.redraw();
    }

    public boolean isShade() {
        return this.molecule.getDisplayMode("Shade");
    }

    public void setColor(boolean bl) {
        this.molecule.setDisplayMode("Color", bl);
        this.redraw();
    }

    public boolean isColor() {
        return this.molecule.getDisplayMode("Color");
    }

    public void setLabel(boolean bl) {
        this.molecule.setDisplayMode("Label", bl);
        this.redraw();
    }

    public boolean islabel() {
        return this.molecule.getDisplayMode("Label");
    }

    public void setWireframe(boolean bl) {
        this.molecule.setDisplayMode("Wireframe", bl);
        this.redraw();
    }

    public boolean isWireframe() {
        return this.molecule.getDisplayMode("Wireframe");
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setRotationLock(boolean bl) {
        this.lock = bl;
    }

    public boolean isRotationLock() {
        return this.lock;
    }

    public void start() {
        super.start();
        if (this.motor != null) {
            this.motor.stop();
            this.motor = null;
        }
        this.motor = new Thread(this);
        this.motor.start();
    }

    public void stop() {
        super.stop();
        if (this.motor != null) {
            this.motor.stop();
        }
        this.motor = null;
    }

    public void setSpinSpeed(int n) {
        this.spinSpeed = n;
        if (this.spinSpeed < 0) {
            this.spinSpeed = 0;
        }
        if (this.spinSpeed > 15) {
            this.spinSpeed = 15;
        }
        if (this.spinSpeed == 0) {
            this.stop();
        }
        if (this.spinSpeed != 0) {
            this.start();
        }
    }

    public int getSpinSpeed() {
        return this.spinSpeed;
    }

    public synchronized void run() {
        int n = 0;
        int n2 = 0;
        do {
            try {
                Thread.sleep(100L);
                if (n2 == 0) {
                    this.molecule.setRotation(this.spinSpeed, 0.0);
                }
                if (n2 == 1) {
                    this.molecule.setRotation(0.0, this.spinSpeed);
                }
                if (n2 >= 2) {
                    this.molecule.setRotation(this.spinSpeed, this.spinSpeed);
                }
                this.redraw();
                if (++n <= 10) continue;
                n = 0;
                n2 = (int)(Math.random() * 3.0);
            }
            catch (Exception exception) {}
        } while (this.motor != null);
    }

    public void print(Graphics graphics) {
        Color color;
        this.molecule.setDimension(this.getSize());
        Color color2 = this.getForeground();
        if (color2 == null) {
            color2 = Color.black;
        }
        if ((color = this.getBackground()) == null) {
            color = Color.white;
        }
        this.molecule.paint(graphics, color2, color);
    }

    public void redraw() {
        this.molecule.setDimension(this.getSize());
        try {
            Color color;
            if (this.backImageSize.width != this.getSize().width) {
                this.backImage = null;
            }
            if (this.backImageSize.height != this.getSize().height) {
                this.backImage = null;
            }
            if (this.backImage == null) {
                this.backImageSize = new Dimension(this.getSize());
                this.backImage = this.createImage(this.backImageSize.width, this.backImageSize.height);
            }
            Graphics graphics = this.backImage.getGraphics();
            Color color2 = this.getForeground();
            if (color2 == null) {
                color2 = Color.black;
            }
            if ((color = this.getBackground()) == null) {
                color = Color.white;
            }
            this.molecule.paint(graphics, color2, color);
            this.paint(this.getGraphics());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void paint(Graphics graphics) {
        if (this.backImageSize.width != this.getSize().width) {
            this.backImage = null;
        }
        if (this.backImageSize.height != this.getSize().height) {
            this.backImage = null;
        }
        if (this.backImage == null) {
            this.redraw();
        }
        graphics.drawImage(this.backImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.lock) {
            return;
        }
        if (mouseEvent.getID() == 501) {
            this.molecule.mouseDown(mouseEvent.getX(), mouseEvent.getY());
        }
        if (mouseEvent.getID() == 502) {
            this.molecule.mouseUp(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.lock) {
            return;
        }
        if (mouseEvent.getID() != 506) {
            return;
        }
        this.molecule.mouseDrag(mouseEvent.getX(), mouseEvent.getY());
        this.redraw();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }
}

