/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUIFrame;
import emsl.awt.GUIPanel;
import emsl.editors.DocumentSizeEditor;
import emsl.system.UndoGroup;
import emsl.system.UndoManager;
import emsl.text.EditPanel;
import emsl.text.TextBook;
import emsl.text.TextClipboard;
import emsl.text.TextPanel;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;

public class Publisher
extends GUIFrame
implements ActionListener,
ComponentListener {
    private WindowManager windowManager;
    private UndoManager undoManager;
    private PageManager pageManager;
    private GUIStyleBar styleBar;
    private GUICommandBar commandBar;
    private GUIPageBar pageBar;
    private GUIMenus menuBar;
    private GUIFind findManager;
    private DemoFileAccess fileAccess;
    private SymbolCharacters symbolCharacters;
    static /* synthetic */ Class class$Publisher;

    public void setWindowManager(Object object) {
        this.windowManager = (WindowManager)object;
        this.setTitle("EMSL Publisher (Lite) - Initializing");
        ((Component)this).setSize(850, 700);
        ((Component)this).setLocation(100, 50);
        ((Component)this).setFont(new Font("SansSerif", 0, 12));
        this.setLayout(new BorderLayout(0, 0));
        ((Component)this).setBackground(Color.lightGray);
        this.menuBar = new GUIMenus(this);
        this.setMenuBar(this.menuBar);
        this.setBeansMenu();
        this.undoManager = new UndoManager("PublisherUndoManager");
        this.fileAccess = new DemoFileAccess(this, this.windowManager.getBeanClassLoader());
        try {
            Class.forName("FullFileAccess");
            this.fileAccess = new FullFileAccess((Frame)this, this.windowManager.getBeanClassLoader());
        }
        catch (Exception exception) {}
        this.pageManager = new PageManager(this);
        TextBook textBook = this.pageManager.getTextBook();
        textBook.addActionListener(this);
        textBook.getTextClipboard().setClipboardManager(this.windowManager.getClipboardManager());
        textBook.getTextUndo().setUndoManager(this.undoManager);
        this.add("Center", this.pageManager);
        this.setMainTextBook(textBook);
        this.add("North", this.createToolBars());
        this.pageBar = new GUIPageBar(this);
        this.add("South", this.pageBar);
        this.findManager = new GUIFind(this, textBook);
        this.setViewScale("100 %");
        this.setWindowTitle("Untitled");
        this.setLayoutMode("Text Mode");
    }

    public static void main(String[] stringArray) {
        WindowManager windowManager = new WindowManager("EMSL Publisher v1.11 (Lite)", class$Publisher != null ? class$Publisher : (class$Publisher = Publisher.class$("Publisher")));
        windowManager.initialize();
    }

    public boolean quit() {
        boolean bl = super.quit();
        if (bl) {
            this.windowManager.quitApplication(this);
        }
        return bl;
    }

    private GUIPanel createToolBars() {
        GUIPanel gUIPanel = new GUIPanel();
        gUIPanel.setLayout(new BorderLayout(0, 0));
        this.commandBar = new GUICommandBar(this);
        gUIPanel.add("North", this.commandBar);
        this.styleBar = new GUIStyleBar(this);
        gUIPanel.add("South", this.styleBar);
        return gUIPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        ((Component)this).setCursor(new Cursor(3));
        Object object2 = actionEvent.getSource();
        Menu menu = null;
        String string = "";
        String string2 = actionEvent.getActionCommand();
        boolean bl = false;
        if (object2 instanceof TextPanel) {
            if (string2.equals("Focus Gained")) {
                this.setFocusTextPanel((KeyListener)object2);
            }
            this.styleBar.setTextStyle((TextPanel)this.getFocusTextPanel());
        }
        if (object2 instanceof MenuItem) {
            object = (MenuItem)object2;
            string2 = ((MenuItem)object).getLabel();
            menu = (Menu)((MenuComponent)object).getParent();
            if (menu != null) {
                string = menu.getLabel();
            }
        }
        if (object2 instanceof CheckboxMenuItem) {
            object = (CheckboxMenuItem)object2;
            menu = (Menu)((MenuComponent)object).getParent();
            if (menu != null) {
                string = menu.getLabel();
            }
            string2 = ((MenuItem)object).getLabel();
            bl = ((CheckboxMenuItem)object).getState();
        }
        if (string2.startsWith("New Window")) {
            this.windowManager.newApplication(this);
        }
        if (string2.startsWith("New Document") && this.checkAndConfirmLoss("New Document")) {
            object = new Document();
            ((Document)object).setColor(this.getDocument().getColor());
            ((Document)object).setDocumentSize(this.getDocument().getDocumentSize());
            this.setDocument((Document)object);
        }
        if (string2.startsWith("Open Document") && this.checkAndConfirmLoss("Open Document") && (object = this.fileAccess.openDocument()) != null) {
            this.setDocument((Document)object);
        }
        if (string2.startsWith("Open Text") && this.checkAndConfirmLoss("Open Text") && (object = this.fileAccess.openText()) != null) {
            this.setDocument((Document)object);
        }
        if (string2.equals("Save Document")) {
            object = this.getDocument();
            if (this.fileAccess.saveDocument((Document)object)) {
                this.setUnsavedChanges(false);
            }
            this.setWindowTitle(((Document)object).getName());
        }
        if (string2.equals("Save Document As...")) {
            object = this.getDocument();
            if (this.fileAccess.saveDocumentAs((Document)object)) {
                this.setUnsavedChanges(false);
            }
            this.setWindowTitle(((Document)object).getName());
        }
        if (string2.startsWith("Save Text")) {
            this.fileAccess.saveTextAs(this.getDocument());
        }
        if (string2.startsWith("Document Size")) {
            object = new DocumentSizeEditor(this);
            ((DocumentSizeEditor)object).setDocumentSize(this.pageManager.getPagePanel().getDocumentSize());
            ((GUIDialogueBox)object).display();
            ((GUIDialogueBox)object).dispose();
            if (((GUIDialogueBox)object).getExitButton().equals("OK")) {
                this.pageManager.getPagePanel().setDocumentSize(((DocumentSizeEditor)object).getDocumentSize());
                ((TextBook)this.getMainTextBook()).reformatAll();
                this.redrawCurrentPage();
            }
        }
        if (string2.startsWith("Print")) {
            this.print(string2);
        }
        if (string2.startsWith("Quit")) {
            this.quit();
        }
        if (this.getFocusTextPanel() != null) {
            object = ((TextPanel)this.getFocusTextPanel()).getTextClipboard();
            if (string2.startsWith("Undo")) {
                ((TextClipboard)object).actionPerformed(actionEvent);
            }
            if (string2.startsWith("Redo")) {
                ((TextClipboard)object).actionPerformed(actionEvent);
            }
            if (string2.startsWith("Copy")) {
                ((TextClipboard)object).actionPerformed(actionEvent);
            }
            if (string2.startsWith("Cut")) {
                ((TextClipboard)object).actionPerformed(actionEvent);
            }
            if (string2.startsWith("Paste")) {
                ((TextClipboard)object).actionPerformed(actionEvent);
            }
            if (string2.startsWith("Delete")) {
                ((TextClipboard)object).actionPerformed(actionEvent);
            }
            if (string2.startsWith("Select All")) {
                ((TextClipboard)object).actionPerformed(actionEvent);
            }
            if (string2.startsWith("Find")) {
                this.findManager.findDisplay();
            }
            if (string2.startsWith("Replace")) {
                this.findManager.replaceDisplay();
            }
        }
        if (string2.equals("Insert Page Break")) {
            this.insertPageBreak();
        }
        if (string2.equals("New Page")) {
            this.pageAction("New");
        }
        if (string2.equals("Page Up")) {
            this.pageAction("Up");
        }
        if (string2.equals("Page Down")) {
            this.pageAction("Down");
        }
        if (string2.equals("Page Selected")) {
            this.pageAction("Select");
        }
        if (string2.equals("TextBook Page Change")) {
            this.pageAction("AutoChange");
        }
        if (string2.equals("Add Pages...")) {
            this.pageAction("Add");
        }
        if (string2.equals("Remove Pages...")) {
            this.pageAction("Remove");
        }
        if (string2.equals("Set Background Color...")) {
            GUIDialogues.getColorSelection(this, "Select Background Color...", this.pageManager.getPagePanel());
        }
        if (string2.equals("Text Mode")) {
            this.setLayoutMode(string2);
        }
        if (string2.equals("Layout Mode")) {
            this.setLayoutMode(string2);
        }
        if (string2.equals("Fit to Window")) {
            this.setViewScale(string2);
        }
        if (string2.indexOf("%") > 0) {
            this.setViewScale(string2);
        }
        if (string2.indexOf("Border") >= 0) {
            this.setBorders(string2, bl);
        }
        if (menu != null && menu.getLabel().equals("Components")) {
            this.setComponents(string2, bl);
        }
        if (string2.startsWith("BeanManagerUpdate")) {
            this.setBeansMenu();
        }
        if (string.startsWith("Beans")) {
            if (string2.startsWith("Load Beans")) {
                this.windowManager.loadBeans(this);
            } else {
                this.insertBean(string2);
            }
        }
        if (string2.startsWith("Feedback")) {
            GUIDialogues.feedback();
        }
        if (string2.startsWith("About")) {
            GUIDialogues.about(this);
        }
        if (string2.indexOf("Symbol Characters") >= 0) {
            if (this.symbolCharacters == null) {
                this.symbolCharacters = new SymbolCharacters(this);
            }
            this.symbolCharacters.display();
        }
        if (string2.indexOf("Chemical Equations") >= 0) {
            object = new ChemicalEquations(this);
            ((GUIDialogueBox)object).display();
        }
        if (string2.indexOf("Text Marker") > 0) {
            ((TextPanel)this.getMainTextBook()).setMarkerVisible(this.styleBar.getMarkerVisible());
        }
        if (this.getFocusTextPanel() == null) {
            this.menuBar.setFocusMenus(false);
            this.menuBar.setUndoMenu(false, null);
            this.menuBar.setRedoMenu(false, null);
            this.menuBar.setSelectionMenus(false);
        } else {
            this.menuBar.setFocusMenus(true);
            this.menuBar.setUndoMenu(this.undoManager.isUndoable(), this.undoManager.getUndoMenuLabel());
            this.menuBar.setRedoMenu(this.undoManager.isRedoable(), this.undoManager.getRedoMenuLabel());
            this.menuBar.setSelectionMenus(((TextPanel)this.getFocusTextPanel()).getTextSelector().isSelected());
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setViewScale(null);
    }

    public void setWindowTitle(String string) {
        String string2 = "EMSL Publisher v1.11 (Lite)  -   " + string;
        this.setTitle(string2);
    }

    public String getWindowTitle() {
        String string = this.getTitle();
        return string.substring(19);
    }

    public void print(String string) {
        this.setLayoutMode("Text Mode");
        DemoPrinter demoPrinter = new DemoPrinter(this, this.pageManager);
        try {
            Class.forName("FullPrinter");
            demoPrinter = new FullPrinter((Frame)this, this.pageManager);
        }
        catch (Exception exception) {}
        if (string.indexOf("Page") > 0) {
            demoPrinter.print(((TextBook)this.getMainTextBook()).getPageNumber());
            return;
        }
        demoPrinter.print();
    }

    public void pageAction(String string) {
        int n;
        TextBook textBook = (TextBook)this.getMainTextBook();
        if (string.equals("Home")) {
            this.pageBar.setPageNumber(1);
            this.pageAction("Select");
        }
        if (string.equals("New")) {
            textBook.addPage();
            textBook.pageDown();
        }
        if (string.equals("Up")) {
            textBook.pageUp();
        }
        if (string.equals("Down")) {
            textBook.pageDown();
        }
        if (string.equals("Select")) {
            textBook.setPageNumber(this.pageBar.getPageNumber());
        }
        string.equals("AutoChange");
        if (string.equals("Add")) {
            n = GUIDialogues.changePages(this, string);
            textBook.setTotalPages(textBook.getTotalPages() + n);
        }
        if (string.equals("Remove")) {
            n = GUIDialogues.changePages(this, string);
            textBook.setTotalPages(textBook.getTotalPages() - n);
        }
        this.pageBar.setTotalPages(textBook.getTotalPages());
        this.pageBar.setPageNumber(textBook.getPageNumber());
    }

    public void setBorders(String string, boolean bl) {
        if (string.indexOf("Text Border") >= 0) {
            if (bl) {
                this.pageManager.getPagePanel().setContentBorder(3);
            } else {
                this.pageManager.getPagePanel().setContentBorder(0);
            }
        }
        if (string.indexOf("Page Border") >= 0) {
            if (bl) {
                this.pageManager.setBackground(((Component)this).getBackground());
                this.pageManager.getPagePanel().setPageBorder(2);
            } else {
                this.pageManager.getPagePanel().setPageBorder(0);
                TextBook textBook = (TextBook)this.getMainTextBook();
                this.pageManager.setBackground(textBook.getBackground());
            }
        }
        this.redrawCurrentPage();
    }

    public void setComponents(String string, boolean bl) {
        if (string.startsWith("Show All")) {
            bl = true;
        }
        if (string.startsWith("Hide All")) {
            bl = false;
        }
        if (string.indexOf("All") >= 0) {
            string = "Command Text Style Page Horizontal Vertical";
        }
        this.pageManager.setVisible(false);
        if (string.indexOf("Command") >= 0) {
            this.commandBar.setVisible(bl);
        }
        if (string.indexOf("Text Style") >= 0) {
            this.styleBar.setVisible(bl);
        }
        if (string.indexOf("Page") >= 0) {
            this.pageBar.setVisible(bl);
        }
        if (string.indexOf("Horizontal") >= 0) {
            this.pageManager.setHRulerVisible(bl);
        }
        if (string.indexOf("Vertical") >= 0) {
            this.pageManager.setVRulerVisible(bl);
        }
        this.menuBar.setChecked("Components", "Command Bar", this.commandBar.isVisible());
        this.menuBar.setChecked("Components", "Text Style Bar", this.styleBar.isVisible());
        this.menuBar.setChecked("Components", "Page Bar", this.pageBar.isVisible());
        this.menuBar.setChecked("Components", "Horizontal Ruler", this.pageManager.isHRulerVisible());
        this.menuBar.setChecked("Components", "Vertical Ruler", this.pageManager.isVRulerVisible());
        this.pageManager.setVisible(true);
        this.validate();
    }

    public void setViewScale(String string) {
        if (string != null) {
            this.menuBar.setChecked("View", "200 %", false);
            this.menuBar.setChecked("View", "175 %", false);
            this.menuBar.setChecked("View", "150 %", false);
            this.menuBar.setChecked("View", "125 %", false);
            this.menuBar.setChecked("View", "100 %", false);
            this.menuBar.setChecked("View", "75 %", false);
            this.menuBar.setChecked("View", "50 %", false);
            this.menuBar.setChecked("View", "25 %", false);
            this.menuBar.setChecked("View", "Fit to Window", false);
            this.menuBar.setChecked("View", string, true);
            this.pageManager.setViewScale(string);
            this.pageBar.setViewScale(string);
        }
        this.redrawCurrentPage();
    }

    public void setLayoutMode(String string) {
        this.menuBar.setChecked("Page", "Layout Mode", string.equals("Layout Mode"));
        this.menuBar.setChecked("Page", "Text Mode", string.equals("Text Mode"));
        this.pageBar.setEditMode(string);
        TextBook textBook = (TextBook)this.getMainTextBook();
        Vector vector = textBook.getTextData().getCharacterList().getComponentList();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!(component instanceof EditPanel)) continue;
            ((EditPanel)component).setEditing(this.pageBar.isEditMode());
        }
    }

    public void insertPageBreak() {
        TextPanel textPanel = (TextPanel)this.getFocusTextPanel();
        if (textPanel == null) {
            return;
        }
        int n = textPanel.getTextCursor().getCursorPosition() + 1;
        UndoGroup undoGroup = textPanel.getTextUndo().getUndoGroup("Insert Page Break");
        textPanel.insert('\u0002', n, undoGroup);
        textPanel.getTextUndo().setUndoGroup(undoGroup);
        textPanel.layoutAfterChange(n);
    }

    public void insertBean(String string) {
        Component component = this.windowManager.getBean(string);
        if (component == null) {
            return;
        }
        TextPanel textPanel = (TextPanel)this.getFocusTextPanel();
        if (textPanel == null) {
            return;
        }
        this.setLayoutMode("Layout Mode");
        EditPanel editPanel = new EditPanel();
        editPanel.setInchBounds(new Rectangle(0, 0, 1000, 500));
        editPanel.updateBounds();
        editPanel.setComponent(component);
        editPanel.setEditing(this.pageBar.isEditMode());
        int n = textPanel.getTextCursor().getCursorPosition() + 1;
        UndoGroup undoGroup = textPanel.getTextUndo().getUndoGroup("Insert Bean");
        textPanel.insert(editPanel, n, undoGroup);
        textPanel.getTextUndo().setUndoGroup(undoGroup);
        textPanel.layoutAfterChange(n);
    }

    public void setDocument(Document document) {
        this.pageManager.setVisible(false);
        TextBook textBook = (TextBook)this.getMainTextBook();
        textBook.setTextData(document.getTextData());
        this.pageManager.getPagePanel().setBackground(document.getColor());
        this.pageManager.getPagePanel().setDocumentSize(document.getDocumentSize());
        textBook.setTotalPages(document.getTotalPages());
        textBook.reformatAll();
        this.pageAction("Home");
        this.pageManager.setVisible(true);
        this.redrawCurrentPage();
        this.setUnsavedChanges(false);
        this.setWindowTitle(document.getName());
        this.setLayoutMode("Text Mode");
    }

    public Document getDocument() {
        TextBook textBook = (TextBook)this.getMainTextBook();
        Document document = new Document();
        document.setTextData(textBook.getTextData());
        document.setDocumentSize(this.pageManager.getPagePanel().getDocumentSize());
        document.setColor(textBook.getBackground());
        document.setName(this.getWindowTitle());
        document.setTotalPages(textBook.getTotalPages());
        return document;
    }

    public void setBeansMenu() {
        Menu menu = this.menuBar.getMenu("Beans");
        if (menu == null) {
            return;
        }
        menu.removeAll();
        Vector vector = this.windowManager.getBeanList();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.menuBar.addMenuItem(menu, string, 0);
        }
        this.menuBar.addSeparator(menu);
        this.menuBar.addMenuItem(menu, "Load Beans...", 0);
    }

    public void setUnsavedChanges(boolean bl) {
        if (this.undoManager != null && !bl) {
            this.undoManager.resetUndo();
        }
    }

    public boolean isUnsavedChanges() {
        return this.undoManager.isUndoable();
    }

    public void redrawCurrentPage() {
        this.pageManager.redrawCurrentPage();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

