/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.net.URL;

public class GUIIcon
extends GUIPanel {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private String text;
    private int align;
    private transient Image image;
    private String imageName;
    private String imagePath;
    private Class imageOwner;
    private Dimension iconSize;
    private transient FontMetrics fontMetrics;
    private transient Font font;
    private transient int stringWidth;

    public GUIIcon(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension(-2, -2);
        }
        this.setSize(dimension);
        this.iconSize = dimension;
        this.setAlignment(1);
    }

    public GUIIcon(Dimension dimension, String string) {
        this(dimension);
        this.setText(string);
    }

    public GUIIcon(String string) {
        this((Dimension)null);
        this.setText(string);
    }

    public GUIIcon(String string, int n) {
        this((Dimension)null);
        this.setText(string);
        this.setAlignment(n);
    }

    public GUIIcon(Dimension dimension, Color color) {
        this(dimension);
        this.setBackground(color);
    }

    public GUIIcon(Dimension dimension, Class clazz, String string, String string2) {
        this(dimension);
        this.setImage(clazz, string, string2);
    }

    public GUIIcon(Class clazz, String string, String string2) {
        this((Dimension)null);
        this.setImage(clazz, string, string2);
    }

    public void setAlignment(int n) {
        this.align = n;
        if (n != 0 || n != 1 || n != 2) {
            n = 0;
        }
        this.fontMetrics = null;
    }

    public void setText(String string) {
        this.text = string;
        this.fontMetrics = null;
    }

    public void setImage(Class clazz, String string, String string2) {
        String string3 = String.valueOf(string) + "/" + string2;
        if (string == null) {
            string3 = string2;
        }
        if (string2 == null) {
            return;
        }
        URL uRL = clazz.getResource(string3);
        this.imageOwner = clazz;
        this.imageName = string;
        this.imagePath = string2;
        try {
            this.image = this.getToolkit().getImage(uRL);
            this.prepareImage(this.image, this);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.image, 1);
            mediaTracker.waitForAll();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = null;
    }

    private int getStringWidth(Graphics graphics) {
        if (this.fontMetrics != null) {
            return this.stringWidth;
        }
        try {
            this.font = this.getFont();
            if (graphics != null && this.font != null) {
                graphics.setFont(this.font);
            }
            this.fontMetrics = graphics != null ? graphics.getFontMetrics() : this.getFontMetrics(this.font);
            this.stringWidth = this.fontMetrics.stringWidth(this.text);
            return this.stringWidth;
        }
        catch (Exception exception) {
            this.fontMetrics = null;
            return 0;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.iconSize);
        if (this.iconSize.width == -2) {
            if (this.text != null) {
                dimension.width = this.getStringWidth(null) + 10;
            }
            if (this.image != null) {
                dimension.width = this.image.getWidth(this) + this.getInsets().left + this.getInsets().right;
            }
        }
        if (this.iconSize.height == -2) {
            if (this.text != null) {
                this.getStringWidth(null);
                if (this.fontMetrics != null) {
                    dimension.height = this.fontMetrics.getHeight() + 4;
                }
            }
            if (this.image != null) {
                dimension.height = this.image.getHeight(this) + this.getInsets().top + this.getInsets().bottom;
            }
        }
        this.setSize(dimension);
        return super.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintImage(graphics);
        this.paintText(graphics);
    }

    private void paintImage(Graphics graphics) {
        if (this.image == null) {
            this.setImage(this.imageOwner, this.imagePath, this.imageName);
        }
        if (this.image == null) {
            return;
        }
        Rectangle rectangle = this.getDrawableSize();
        this.prepareImage(this.image, rectangle.width, rectangle.height, this);
        if ((this.checkImage(this.image, this) & 0x40) != 0) {
            this.image = null;
            System.out.println("Error loading icon image :" + this.imageName);
            return;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
    }

    private void paintText(Graphics graphics) {
        if (this.text == null) {
            return;
        }
        this.getStringWidth(graphics);
        if (this.fontMetrics == null) {
            return;
        }
        Rectangle rectangle = this.getDrawableSize();
        int n = rectangle.x + 3;
        int n2 = this.fontMetrics.getAscent();
        int n3 = rectangle.y + (rectangle.height / 2 + n2 / 2);
        if (this.align == 1) {
            n = rectangle.x + (rectangle.width / 2 - this.stringWidth / 2);
        }
        if (this.align == 2) {
            n = rectangle.x + rectangle.width - 1 - this.stringWidth;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Color color = this.getForeground();
        if (color == null) {
            color = Color.black;
        }
        graphics.setColor(color);
        graphics.drawString(this.text, n, n3);
    }
}

